/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.BitmapEncoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupLinearFunctional;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.functional.LinearRegression;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.AInsertionSorter;
import org.apache.sysds.runtime.compress.colgroup.insertionsort.InsertionSorterFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.utils.stats.Timing;

public class ColGroupFactory {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupFactory.class.getName());
    private final MatrixBlock in;
    private final CompressedSizeInfo csi;
    private final CompressionSettings cs;
    private final ACostEstimate ce;
    private final int k;
    private final int nRow;
    private final int nCol;
    private final ExecutorService pool;

    private ColGroupFactory(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, ACostEstimate ce, int k) {
        this.in = in;
        this.csi = csi;
        this.cs = cs;
        this.k = k;
        this.ce = ce;
        this.nRow = cs.transposed ? in.getNumColumns() : in.getNumRows();
        this.nCol = cs.transposed ? in.getNumRows() : in.getNumColumns();
        this.pool = k > 1 ? CommonThreadPool.get(k) : null;
    }

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs) {
        return ColGroupFactory.compressColGroups(in, csi, cs, 1);
    }

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, int k) {
        return new ColGroupFactory(in, csi, cs, null, k).compress();
    }

    public static List<AColGroup> compressColGroups(MatrixBlock in, CompressedSizeInfo csi, CompressionSettings cs, ACostEstimate ce, int k) {
        return new ColGroupFactory(in, csi, cs, ce, k).compress();
    }

    private List<AColGroup> compress() {
        try {
            if (this.in instanceof CompressedMatrixBlock) {
                List<AColGroup> list = CLALibCombineGroups.combine((CompressedMatrixBlock)this.in, this.csi, this.pool, this.k);
                return list;
            }
            List<AColGroup> list = this.compressExecute();
            return list;
        }
        catch (Exception e) {
            throw new DMLCompressionException("Compression Failed", e);
        }
        finally {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    private List<AColGroup> compressExecute() throws Exception {
        if (this.in.isEmpty()) {
            ColGroupEmpty empty = ColGroupEmpty.create(this.cs.transposed ? this.in.getNumRows() : this.in.getNumColumns());
            return Collections.singletonList(empty);
        }
        if (this.k <= 1) {
            return this.compressColGroupsSingleThreaded();
        }
        return this.compressColGroupsParallel();
    }

    private List<AColGroup> compressColGroupsSingleThreaded() throws Exception {
        ArrayList<AColGroup> ret = new ArrayList<AColGroup>(this.csi.getNumberColGroups());
        for (CompressedSizeInfoColGroup g : this.csi.getInfo()) {
            ret.add(this.compressColGroup(g));
        }
        return ret;
    }

    private List<AColGroup> compressColGroupsParallel() throws Exception {
        List<CompressedSizeInfoColGroup> groups = this.csi.getInfo();
        int nGroups = groups.size();
        int skip = Math.min(this.k * 10, nGroups);
        ArrayList<CompressTask> tasks = new ArrayList<CompressTask>(skip);
        Collections.sort(groups, Comparator.comparing(g -> -g.getNumVals()));
        AColGroup[] ret = new AColGroup[nGroups];
        for (int i = 0; i < skip; ++i) {
            tasks.add(new CompressTask(groups, ret, i, skip));
        }
        for (Future t : this.pool.invokeAll(tasks)) {
            t.get();
        }
        return Arrays.asList(ret);
    }

    protected AColGroup compressColGroup(CompressedSizeInfoColGroup cg) throws Exception {
        if (LOG.isDebugEnabled() && this.nCol < 1000 && this.ce != null) {
            Timing time = new Timing(true);
            AColGroup ret = this.compressColGroupAllSteps(cg);
            this.logEstVsActual(time.stop(), ret, cg);
            return ret;
        }
        return this.compressColGroupAllSteps(cg);
    }

    private void logEstVsActual(double time, AColGroup act, CompressedSizeInfoColGroup est) {
        double estC = this.ce.getCost(est);
        double actC = this.ce.getCost(act, this.nRow);
        String retType = act.getClass().getSimpleName().toString();
        String cols = est.getColumns().toString();
        String wanted = est.getBestCompressionType().toString();
        if (estC < actC * 0.75) {
            String warning = "The estimate cost is significantly off : " + est;
            LOG.debug((Object)String.format("time[ms]: %10.2f %25s est %10.0f -- act %10.0f distinct:%5d cols:%s wanted:%s\n\t\t%s", time, retType, estC, actC, act.getNumValues(), cols, wanted, warning));
        } else {
            LOG.debug((Object)String.format("time[ms]: %10.2f %25s est %10.0f -- act %10.0f distinct:%5d cols:%s wanted:%s", time, retType, estC, actC, act.getNumValues(), cols, wanted));
        }
    }

    private AColGroup compressColGroupAllSteps(CompressedSizeInfoColGroup cg) throws Exception {
        AColGroup g = this.compress(cg);
        if (this.ce != null && this.ce.shouldSparsify() && this.nCol >= 4) {
            g = ColGroupFactory.sparsifyFOR(g);
        }
        return g;
    }

    private static AColGroup sparsifyFOR(AColGroup g) {
        if (g instanceof ColGroupDDC) {
            return ((ColGroupDDC)g).sparsifyFOR();
        }
        if (g instanceof ColGroupSDC) {
            return ((ColGroupSDC)g).sparsifyFOR();
        }
        return g;
    }

    private AColGroup compress(CompressedSizeInfoColGroup cg) throws Exception {
        IColIndex colIndexes = cg.getColumns();
        AColGroup.CompressionType ct = cg.getBestCompressionType();
        boolean t = this.cs.transposed;
        if (ct == AColGroup.CompressionType.EMPTY && !t || t && colIndexes.size() == 1 && this.in.isInSparseFormat() && this.in.getSparseBlock().isEmpty(colIndexes.get(0))) {
            return new ColGroupEmpty(colIndexes);
        }
        if (ct == AColGroup.CompressionType.UNCOMPRESSED) {
            return ColGroupUncompressed.create(colIndexes, this.in, t);
        }
        if ((ct == AColGroup.CompressionType.SDC || ct == AColGroup.CompressionType.CONST) && this.in.isInSparseFormat() && t && (colIndexes.size() > 1 && (double)cg.getNumOffs() < 0.3 * (double)this.nRow || colIndexes.size() == 1)) {
            return this.compressSDCFromSparseTransposedBlock(colIndexes, cg.getNumVals(), cg.getTupleSparsity());
        }
        if (ct == AColGroup.CompressionType.DDC) {
            return this.directCompressDDC(colIndexes, cg);
        }
        if (ct == AColGroup.CompressionType.LinearFunctional) {
            return ColGroupFactory.compressLinearFunctional(colIndexes, this.in, this.cs);
        }
        if (ct == AColGroup.CompressionType.DDCFOR) {
            AColGroup g = this.directCompressDDC(colIndexes, cg);
            if (g instanceof ColGroupDDC) {
                return ColGroupDDCFOR.sparsifyFOR((ColGroupDDC)g);
            }
            return g;
        }
        if (ct == AColGroup.CompressionType.SDC && colIndexes.size() == 1 && !t) {
            return this.compressSDCSingleColDirectBlock(colIndexes, cg.getNumVals());
        }
        ABitmap ubm = BitmapEncoder.extractBitmap(colIndexes, this.in, cg.getNumVals(), this.cs);
        if (ubm == null) {
            return new ColGroupEmpty(colIndexes);
        }
        IntArrayList[] of = ubm.getOffsetList();
        if (of.length == 1 && of[0].size() == this.nRow) {
            return ColGroupConst.create(colIndexes, DictionaryFactory.create(ubm));
        }
        double tupleSparsity = colIndexes.size() > 4 ? cg.getTupleSparsity() : 1.0;
        switch (ct) {
            case RLE: {
                return ColGroupRLE.compressRLE(colIndexes, ubm, this.nRow, tupleSparsity);
            }
            case OLE: {
                return ColGroupOLE.compressOLE(colIndexes, ubm, this.nRow, tupleSparsity);
            }
            case CONST: 
            case EMPTY: {
                LOG.warn((Object)("Requested " + ct + " on non constant column, fallback to SDC"));
            }
            case SDC: {
                return ColGroupFactory.compressSDC(colIndexes, this.nRow, ubm, this.cs, tupleSparsity);
            }
            case SDCFOR: {
                AColGroup g = ColGroupFactory.compressSDC(colIndexes, this.nRow, ubm, this.cs, tupleSparsity);
                if (g instanceof ColGroupSDC) {
                    return ColGroupSDCFOR.sparsifyFOR((ColGroupSDC)g);
                }
                return g;
            }
        }
        throw new DMLCompressionException("Not implemented compression of " + ct + " in factory.");
    }

    private AColGroup compressSDCSingleColDirectBlock(IColIndex colIndexes, int nVal) {
        DoubleCountHashMap cMap = new DoubleCountHashMap(nVal);
        int col = colIndexes.get(0);
        this.countElements(cMap, col);
        double def = (Double)cMap.getMostFrequent();
        int dictSize = cMap.size() - 1;
        if (dictSize == 0) {
            return ColGroupConst.create(colIndexes, def);
        }
        int defCount = cMap.getC(Double.valueOf((double)def)).count;
        cMap.replaceWithUIDs(def);
        Dictionary dict = Dictionary.create(cMap.getDictionary(dictSize));
        IntArrayList offs = new IntArrayList(this.nRow - defCount);
        AMapToData map = MapToFactory.create(this.nRow - defCount, dictSize);
        this.getOffsets(offs, map, cMap, col, def);
        AOffset aoff = OffsetFactory.createOffset(offs);
        return ColGroupSDC.create(colIndexes, this.nRow, dict, new double[]{def}, aoff, map, null);
    }

    private void getOffsets(IntArrayList offs, AMapToData map, DoubleCountHashMap cMap, int col, double def) {
        if (this.in.isInSparseFormat()) {
            if (def == 0.0) {
                SparseBlock sb = this.in.getSparseBlock();
                for (int r = 0; r < this.nRow; ++r) {
                    if (sb.isEmpty(r)) continue;
                    int apos = sb.pos(r);
                    int alen = sb.size(r) + apos;
                    int[] aix = sb.indexes(r);
                    int idx = Arrays.binarySearch(aix, apos, alen, col);
                    if (idx < 0) continue;
                    map.set(offs.size(), cMap.getId(sb.values(r)[idx]));
                    offs.appendValue(r);
                }
            } else {
                SparseBlock sb = this.in.getSparseBlock();
                for (int r = 0; r < this.nRow; ++r) {
                    if (sb.isEmpty(r)) {
                        map.set(offs.size(), cMap.getId(0.0));
                        offs.appendValue(r);
                        continue;
                    }
                    int apos = sb.pos(r);
                    int alen = sb.size(r) + apos;
                    int[] aix = sb.indexes(r);
                    int idx = Arrays.binarySearch(aix, apos, alen, col);
                    if (idx < 0) {
                        map.set(offs.size(), cMap.getId(0.0));
                        offs.appendValue(r);
                        continue;
                    }
                    double v = sb.values(r)[idx];
                    if (Util.eq(sb.values(r)[idx], def)) continue;
                    map.set(offs.size(), cMap.getId(v));
                    offs.appendValue(r);
                }
            }
        } else if (this.in.getDenseBlock().isContiguous()) {
            double[] dv = this.in.getDenseBlockValues();
            int off = col;
            int r = 0;
            while (r < this.nRow) {
                if (!Util.eq(dv[off], def)) {
                    map.set(offs.size(), cMap.getId(dv[off]));
                    offs.appendValue(r);
                }
                ++r;
                off += this.nCol;
            }
        } else {
            DenseBlock db = this.in.getDenseBlock();
            for (int r = 0; r < this.nRow; ++r) {
                int off;
                double[] dv = db.values(r);
                if (Util.eq(dv[off = db.pos(r) + col], def)) continue;
                map.set(offs.size(), cMap.getId(dv[off]));
                offs.appendValue(r);
            }
        }
    }

    private void countElements(DoubleCountHashMap map, int col) {
        if (this.in.isInSparseFormat()) {
            this.countElementsSparse(map, col);
        } else if (this.in.getDenseBlock().isContiguous()) {
            this.countElementsDenseContiguous(map, col);
        } else {
            this.countElementsDenseGeneric(map, col);
        }
    }

    private void countElementsSparse(DoubleCountHashMap map, int col) {
        SparseBlock sb = this.in.getSparseBlock();
        for (int r = 0; r < this.nRow; ++r) {
            if (sb.isEmpty(r)) {
                map.increment(0.0);
                continue;
            }
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            int idx = Arrays.binarySearch(aix, apos, alen, col);
            if (idx < 0) {
                map.increment(0.0);
                continue;
            }
            map.increment(sb.values(r)[idx]);
        }
    }

    private void countElementsDenseContiguous(DoubleCountHashMap map, int col) {
        double[] dv = this.in.getDenseBlockValues();
        int off = col;
        int r = 0;
        while (r < this.nRow) {
            map.increment(dv[off]);
            ++r;
            off += this.nCol;
        }
    }

    private void countElementsDenseGeneric(DoubleCountHashMap map, int col) {
        DenseBlock db = this.in.getDenseBlock();
        for (int r = 0; r < this.nRow; ++r) {
            double[] dv = db.values(r);
            int off = db.pos(r) + col;
            map.increment(dv[off]);
        }
    }

    private AColGroup directCompressDDC(IColIndex colIndexes, CompressedSizeInfoColGroup cg) throws Exception {
        if (colIndexes.size() > 1) {
            return this.directCompressDDCMultiCol(colIndexes, cg);
        }
        return this.directCompressDDCSingleCol(colIndexes, cg);
    }

    private AColGroup directCompressDDCSingleCol(IColIndex colIndexes, CompressedSizeInfoColGroup cg) {
        int col = colIndexes.get(0);
        AMapToData d = MapToFactory.create(this.nRow, Math.max(Math.min(cg.getNumOffs() + 1, this.nRow), 126));
        DoubleCountHashMap map = new DoubleCountHashMap(cg.getNumVals());
        if (this.cs.transposed) {
            this.readToMapDDCTransposed(col, map, d);
        } else {
            this.readToMapDDC(col, map, d);
        }
        if (map.size() == 0) {
            return new ColGroupEmpty(colIndexes);
        }
        IDictionary dict = DictionaryFactory.create(map);
        int nUnique = map.size();
        AMapToData resData = d.resize(nUnique);
        return ColGroupDDC.create(colIndexes, dict, resData, null);
    }

    private AColGroup directCompressDDCMultiCol(IColIndex colIndexes, CompressedSizeInfoColGroup cg) throws Exception {
        AMapToData d = MapToFactory.create(this.nRow, Math.max(Math.min(cg.getNumOffs() + 1, this.nRow), 126));
        int fill = d.getUpperBoundValue();
        d.fill(fill);
        DblArrayCountHashMap map = new DblArrayCountHashMap(Math.max(cg.getNumVals(), 64));
        boolean extra = this.nRow < CompressionSettings.PAR_DDC_THRESHOLD || this.k < this.csi.getNumberColGroups() || this.pool == null ? this.readToMapDDC(colIndexes, map, d, 0, this.nRow, fill) : this.parallelReadToMapDDC(colIndexes, map, d, this.nRow, fill, this.k);
        if (map.size() == 0) {
            return new ColGroupEmpty(colIndexes);
        }
        IDictionary dict = DictionaryFactory.create(map, colIndexes.size(), extra, cg.getTupleSparsity());
        if (extra) {
            d.replace(fill, map.size());
        }
        int nUnique = map.size() + (extra ? 1 : 0);
        AMapToData resData = d.resize(nUnique);
        return ColGroupDDC.create(colIndexes, dict, resData, null);
    }

    private boolean readToMapDDC(IColIndex colIndexes, DblArrayCountHashMap map, AMapToData data, int rl, int ru, int fill) {
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(this.in, colIndexes, this.cs.transposed, rl, ru);
        DblArray cellVals = reader.nextRow();
        boolean extra = false;
        int r = rl;
        while (r < ru && cellVals != null) {
            int row = reader.getCurrentRowIndex();
            if (row == r) {
                int id = map.increment(cellVals);
                data.set(row, id);
                cellVals = reader.nextRow();
                ++r;
                continue;
            }
            r = row;
            extra = true;
        }
        if (r < ru) {
            extra = true;
        }
        return extra;
    }

    private void readToMapDDC(int col, DoubleCountHashMap map, AMapToData data) {
        if (this.in.isInSparseFormat()) {
            SparseBlock sb = this.in.getSparseBlock();
            for (int r = 0; r < this.nRow; ++r) {
                if (sb.isEmpty(r)) {
                    data.set(r, map.increment(0.0));
                    continue;
                }
                int apos = sb.pos(r);
                int alen = sb.size(r) + apos;
                int[] aix = sb.indexes(r);
                int idx = Arrays.binarySearch(aix, apos, alen, col);
                if (idx < 0) {
                    data.set(r, map.increment(0.0));
                    continue;
                }
                data.set(r, map.increment(sb.values(r)[idx]));
            }
        } else if (this.in.getDenseBlock().isContiguous()) {
            double[] dv = this.in.getDenseBlockValues();
            int off = col;
            int r = 0;
            while (r < this.nRow) {
                int id = map.increment(dv[off]);
                data.set(r, id);
                ++r;
                off += this.nCol;
            }
        } else {
            DenseBlock db = this.in.getDenseBlock();
            for (int r = 0; r < this.nRow; ++r) {
                double[] dv = db.values(r);
                int off = db.pos(r) + col;
                data.set(r, map.increment(dv[off]));
            }
        }
    }

    private void readToMapDDCTransposed(int col, DoubleCountHashMap map, AMapToData data) {
        if (this.in.isInSparseFormat()) {
            SparseBlock sb = this.in.getSparseBlock();
            if (sb.isEmpty(col)) {
                throw new DMLCompressionException("Empty column in DDC compression");
            }
            int apos = sb.pos(col);
            int alen = sb.size(col) + apos;
            int[] aix = sb.indexes(col);
            double[] aval = sb.values(col);
            if (this.nRow > alen - apos) {
                map.increment(0.0, this.nRow - apos - alen);
            }
            for (int j = apos; j < alen; ++j) {
                int id = map.increment(aval[j]);
                data.set(aix[j], id);
            }
        } else {
            DenseBlock db = this.in.getDenseBlock();
            double[] dv = db.values(col);
            int off = db.pos(col);
            int r = 0;
            while (r < this.nRow) {
                data.set(r, map.increment(dv[off]));
                ++r;
                ++off;
            }
        }
    }

    private boolean parallelReadToMapDDC(IColIndex colIndexes, DblArrayCountHashMap map, AMapToData data, int rlen, int fill, int k) throws Exception {
        int blk = Math.max(rlen / colIndexes.size() / k, 64000 / colIndexes.size());
        ArrayList<readToMapDDCTask> tasks = new ArrayList<readToMapDDCTask>();
        for (int i = 0; i < rlen; i += blk) {
            int end = Math.min(rlen, i + blk);
            tasks.add(new readToMapDDCTask(colIndexes, map, data, i, end, fill));
        }
        boolean extra = false;
        for (Future t : this.pool.invokeAll(tasks)) {
            extra |= ((Boolean)t.get()).booleanValue();
        }
        return extra;
    }

    private static AColGroup compressSDC(IColIndex colIndexes, int rlen, ABitmap ubm, CompressionSettings cs, double tupleSparsity) {
        IDictionary dict;
        int nVal;
        int numZeros = ubm.getNumZeros();
        IntArrayList[] offs = ubm.getOffsetList();
        int largestOffset = offs[0].size();
        int largestIndex = 0;
        if (!cs.sortTuplesByFrequency) {
            int index = 0;
            for (IntArrayList a : ubm.getOffsetList()) {
                if (a.size() > largestOffset) {
                    largestOffset = a.size();
                    largestIndex = index;
                }
                ++index;
            }
        }
        if ((nVal = ubm.getNumValues()) == 1 && numZeros >= largestOffset) {
            dict = DictionaryFactory.create(ubm, tupleSparsity);
            AOffset off = OffsetFactory.createOffset(ubm.getOffsetList()[0].extractValues(true));
            return ColGroupSDCSingleZeros.create(colIndexes, rlen, dict, off, null);
        }
        if (nVal == 2 && numZeros == 0 || nVal == 1 && numZeros < largestOffset) {
            double[] defaultTuple = new double[colIndexes.size()];
            IDictionary dict2 = DictionaryFactory.create(ubm, largestIndex, defaultTuple, tupleSparsity, numZeros > 0);
            return ColGroupFactory.compressSDCSingle(colIndexes, rlen, ubm, largestIndex, dict2, defaultTuple);
        }
        if (numZeros >= largestOffset) {
            dict = DictionaryFactory.create(ubm, tupleSparsity);
            return ColGroupFactory.compressSDCZero(colIndexes, rlen, ubm, dict, cs);
        }
        return ColGroupFactory.compressSDCNormal(colIndexes, numZeros, rlen, ubm, largestIndex, tupleSparsity, cs);
    }

    private static AColGroup compressSDCZero(IColIndex colIndexes, int rlen, ABitmap ubm, IDictionary dict, CompressionSettings cs) {
        IntArrayList[] offsets = ubm.getOffsetList();
        AInsertionSorter s = InsertionSorterFactory.create(rlen, offsets, cs.sdcSortType);
        AOffset indexes = OffsetFactory.createOffset(s.getIndexes());
        AMapToData data = s.getData();
        data = data.resize(dict.getNumberOfValues(colIndexes.size()));
        return ColGroupSDCZeros.create(colIndexes, rlen, dict, indexes, data, null);
    }

    private static AColGroup compressSDCNormal(IColIndex colIndexes, int numZeros, int rlen, ABitmap ubm, int largestIndex, double tupleSparsity, CompressionSettings cs) {
        double[] defaultTuple = new double[colIndexes.size()];
        IDictionary dict = DictionaryFactory.create(ubm, largestIndex, defaultTuple, tupleSparsity, numZeros > 0);
        AInsertionSorter s = InsertionSorterFactory.createNegative(rlen, ubm.getOffsetList(), largestIndex, cs.sdcSortType);
        AOffset indexes = OffsetFactory.createOffset(s.getIndexes());
        AMapToData _data = s.getData();
        _data = _data.resize(dict.getNumberOfValues(colIndexes.size()));
        return ColGroupSDC.create(colIndexes, rlen, dict, defaultTuple, indexes, _data, null);
    }

    private static AColGroup compressSDCSingle(IColIndex colIndexes, int rlen, ABitmap ubm, int largestIndex, IDictionary dict, double[] defaultTuple) {
        if (ubm.getOffsetList().length > 1) {
            AOffset off = OffsetFactory.createOffset(ubm.getOffsetsList(largestIndex ^ 1));
            return ColGroupSDCSingle.create(colIndexes, rlen, dict, defaultTuple, off, null);
        }
        IntArrayList inv = ubm.getOffsetsList(0);
        int[] indexes = new int[rlen - inv.size()];
        int p = 0;
        int v = 0;
        for (int i = 0; i < inv.size(); ++i) {
            int j = inv.get(i);
            while (v < j) {
                indexes[p++] = v++;
            }
            ++v;
        }
        while (v < rlen) {
            indexes[p++] = v++;
        }
        AOffset off = OffsetFactory.createOffset(indexes);
        return ColGroupSDCSingle.create(colIndexes, rlen, dict, defaultTuple, off, null);
    }

    private static AColGroup compressLinearFunctional(IColIndex colIndexes, MatrixBlock in, CompressionSettings cs) {
        double[] coefficients = LinearRegression.regressMatrixBlock(in, colIndexes, cs.transposed);
        int numRows = cs.transposed ? in.getNumColumns() : in.getNumRows();
        return ColGroupLinearFunctional.create(colIndexes, coefficients, numRows);
    }

    private AColGroup compressSDCFromSparseTransposedBlock(IColIndex cols, int nrUniqueEstimate, double tupleSparsity) {
        if (cols.size() > 1) {
            return this.compressMultiColSDCFromSparseTransposedBlock(cols, nrUniqueEstimate, tupleSparsity);
        }
        return this.compressSingleColSDCFromSparseTransposedBlock(cols, nrUniqueEstimate);
    }

    private AColGroup compressMultiColSDCFromSparseTransposedBlock(IColIndex cols, int nrUniqueEstimate, double tupleSparsity) {
        HashSet<Integer> offsetsSet = new HashSet<Integer>();
        SparseBlock sb = this.in.getSparseBlock();
        for (int i = 0; i < cols.size(); ++i) {
            int idx = cols.get(i);
            if (sb.isEmpty(idx)) continue;
            int apos = sb.pos(idx);
            int alen = sb.size(idx) + apos;
            int[] aix = sb.indexes(idx);
            for (int j = apos; j < alen; ++j) {
                offsetsSet.add(aix[j]);
            }
        }
        if (offsetsSet.isEmpty()) {
            return new ColGroupEmpty(cols);
        }
        int[] offsetsInt = offsetsSet.stream().mapToInt(Number::intValue).toArray();
        Arrays.sort(offsetsInt);
        MatrixBlock sub = new MatrixBlock(offsetsInt.length, cols.size(), false);
        sub.allocateDenseBlock();
        sub.setNonZeros(offsetsInt.length * cols.size());
        double[] subV = sub.getDenseBlockValues();
        for (int i = 0; i < cols.size(); ++i) {
            int idx = cols.get(i);
            if (sb.isEmpty(idx)) continue;
            int apos = sb.pos(idx);
            int alen = sb.size(idx) + apos;
            int[] aix = sb.indexes(idx);
            double[] aval = sb.values(idx);
            int offsetsPos = 0;
            for (int j = apos; j < alen; ++j) {
                while (offsetsInt[offsetsPos] < aix[j]) {
                    ++offsetsPos;
                }
                if (offsetsInt[offsetsPos] != aix[j]) continue;
                subV[offsetsPos * cols.size() + i] = aval[j];
            }
        }
        IColIndex subCols = ColIndexFactory.create(cols.size());
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(sub, subCols, false);
        int mapStartSize = Math.min(nrUniqueEstimate, offsetsInt.length / 2);
        DblArrayCountHashMap map = new DblArrayCountHashMap(mapStartSize);
        DblArray cellVals = null;
        AMapToData data = MapToFactory.create(offsetsInt.length, 257);
        while ((cellVals = reader.nextRow()) != null) {
            int row = reader.getCurrentRowIndex();
            data.set(row, map.increment(cellVals));
        }
        IDictionary dict = DictionaryFactory.create(map, cols.size(), false, tupleSparsity);
        data = data.resize(map.size());
        AOffset offs = OffsetFactory.createOffset(offsetsInt);
        return ColGroupSDCZeros.create(cols, this.in.getNumColumns(), dict, offs, data, null);
    }

    private AColGroup compressSingleColSDCFromSparseTransposedBlock(IColIndex cols, int nrUniqueEstimate) {
        SparseBlock sb = this.in.getSparseBlock();
        if (sb.isEmpty(cols.get(0))) {
            return new ColGroupEmpty(cols);
        }
        int sbRow = cols.get(0);
        int apos = sb.pos(sbRow);
        int alen = sb.size(sbRow) + apos;
        double[] vals = sb.values(sbRow);
        DoubleCountHashMap map = new DoubleCountHashMap(nrUniqueEstimate);
        for (int j = apos; j < alen; ++j) {
            map.increment(vals[j]);
        }
        ACount<T>[] entries = map.extractValues();
        Arrays.sort(entries, Comparator.comparing(x -> -x.count));
        if (entries[0].count < this.nRow - sb.size(sbRow)) {
            int[] counts = new int[entries.length];
            double[] dict = new double[entries.length];
            int i = 0;
            while (i < entries.length) {
                ACount x2 = entries[i];
                counts[i] = x2.count;
                dict[i] = (Double)x2.key();
                x2.count = i++;
            }
            AOffset offsets = OffsetFactory.createOffset(sb.indexes(sbRow), apos, alen);
            if (entries.length <= 1) {
                return ColGroupSDCSingleZeros.create(cols, this.nRow, Dictionary.create(dict), offsets, counts);
            }
            AMapToData mapToData = MapToFactory.create(alen - apos, entries.length);
            for (int j = apos; j < alen; ++j) {
                mapToData.set(j - apos, map.get(vals[j]));
            }
            return ColGroupSDCZeros.create(cols, this.nRow, Dictionary.create(dict), offsets, mapToData, counts);
        }
        if (entries.length == 1) {
            int r;
            int nonZeros = this.nRow - entries[0].count;
            double x3 = (Double)entries[0].key();
            double[] defaultTuple = new double[]{x3};
            int[] counts = new int[]{nonZeros};
            int[] notZeroOffsets = new int[nonZeros];
            int[] aix = sb.indexes(sbRow);
            int i = 0;
            int j = apos;
            for (r = 0; r < aix[alen - 1]; ++r) {
                if (r == aix[j]) {
                    ++j;
                    continue;
                }
                notZeroOffsets[i++] = r;
            }
            ++r;
            while (r < this.nRow) {
                notZeroOffsets[i] = r++;
                ++i;
            }
            AOffset offsets = OffsetFactory.createOffset(notZeroOffsets);
            return ColGroupSDCSingle.create(cols, this.nRow, null, defaultTuple, offsets, counts);
        }
        ABitmap ubm = BitmapEncoder.extractBitmap(cols, this.in, true, entries.length, true);
        return ColGroupFactory.compressSDC(cols, this.nRow, ubm, this.cs, 1.0);
    }

    private class readToMapDDCTask
    implements Callable<Boolean> {
        private final IColIndex _colIndexes;
        private final DblArrayCountHashMap _map;
        private final AMapToData _data;
        private final int _rl;
        private final int _ru;
        private final int _fill;

        protected readToMapDDCTask(IColIndex colIndexes, DblArrayCountHashMap map, AMapToData data, int rl, int ru, int fill) {
            this._colIndexes = colIndexes;
            this._map = map;
            this._data = data;
            this._rl = rl;
            this._ru = ru;
            this._fill = fill;
        }

        @Override
        public Boolean call() {
            return ColGroupFactory.this.readToMapDDC(this._colIndexes, this._map, this._data, this._rl, this._ru, this._fill);
        }
    }

    private class CompressTask
    implements Callable<Object> {
        private final List<CompressedSizeInfoColGroup> _groups;
        private final AColGroup[] _ret;
        private final int _off;
        private final int _step;

        protected CompressTask(List<CompressedSizeInfoColGroup> groups, AColGroup[] ret, int off, int step) {
            this._groups = groups;
            this._ret = ret;
            this._off = off;
            this._step = step;
        }

        @Override
        public Object call() throws Exception {
            for (int i = this._off; i < this._groups.size(); i += this._step) {
                this._ret[i] = ColGroupFactory.this.compressColGroup(this._groups.get(i));
            }
            return null;
        }
    }
}

