/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import javax.portlet.PortletMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.ServletUrlRenderer;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.portlet.util.PortletUrlHelper;
import org.apache.struts2.portlet.util.PortletUrlHelperJSR286;
import org.apache.struts2.url.QueryStringParser;
import org.apache.struts2.views.util.UrlHelper;

public class PortletUrlRenderer
implements UrlRenderer {
    private ServletUrlRenderer servletRenderer = new ServletUrlRenderer();
    private PortletUrlHelper portletUrlHelper = PortletActionContext.isJSR268Supported() ? new PortletUrlHelperJSR286() : new PortletUrlHelper();

    @Inject
    public void setActionMapper(ActionMapper actionMapper) {
        this.servletRenderer.setActionMapper(actionMapper);
    }

    @Inject
    public void setUrlHelper(UrlHelper urlHelper) {
        this.servletRenderer.setUrlHelper(urlHelper);
    }

    @Inject
    public void setQueryStringParser(QueryStringParser queryStringParser) {
        this.servletRenderer.setQueryStringParser(queryStringParser);
    }

    public void renderUrl(Writer writer, UrlProvider urlComponent) {
        String var;
        String result;
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.renderUrl(writer, urlComponent);
            return;
        }
        if (this.isPortletModeChange(urlComponent, PortletActionContext.getRequest().getPortletMode()) && StringUtils.isEmpty((CharSequence)urlComponent.getNamespace())) {
            String mode = urlComponent.getPortletMode();
            PortletMode portletMode = new PortletMode(mode);
            String action = urlComponent.getAction();
            if (StringUtils.isEmpty((CharSequence)action)) {
                action = PortletActionContext.getModeActionMap().get(portletMode).getName();
            }
            String modeNamespace = PortletActionContext.getModeNamespaceMap().get(portletMode);
            result = this.portletUrlHelper.buildUrl(action, modeNamespace, urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), mode, urlComponent.getWindowState());
        } else {
            String namespace = urlComponent.determineNamespace(urlComponent.getNamespace(), urlComponent.getStack(), urlComponent.getHttpServletRequest());
            urlComponent.setNamespace(namespace);
            if (this.onlyActionSpecified(urlComponent)) {
                if (StringUtils.isNotEmpty((CharSequence)urlComponent.getAction())) {
                    String action = urlComponent.findString(urlComponent.getAction());
                    result = this.portletUrlHelper.buildUrl(action, urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState());
                } else {
                    result = this.portletUrlHelper.buildUrl(urlComponent.getAction(), urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState());
                }
            } else {
                result = this.onlyValueSpecified(urlComponent) ? this.portletUrlHelper.buildResourceUrl(urlComponent.getValue(), urlComponent.getParameters()) : this.createDefaultUrl(urlComponent);
            }
        }
        String anchor = urlComponent.getAnchor();
        if (StringUtils.isNotEmpty((CharSequence)anchor)) {
            result = result + '#' + urlComponent.findString(anchor);
        }
        if ((var = urlComponent.getVar()) != null) {
            urlComponent.putInContext(result);
            urlComponent.getHttpServletRequest().setAttribute(var, (Object)result);
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                throw new StrutsException("IOError: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    boolean isPortletModeChange(UrlProvider urlComponent, PortletMode currentMode) {
        if (StringUtils.isNotEmpty((CharSequence)urlComponent.getPortletMode())) {
            PortletMode newPortletMode = new PortletMode(urlComponent.getPortletMode());
            return !newPortletMode.equals((Object)currentMode);
        }
        return false;
    }

    private String createDefaultUrl(UrlProvider urlComponent) {
        ActionInvocation ai = urlComponent.getStack().getActionContext().getActionInvocation();
        String action = ai.getProxy().getActionName();
        return this.portletUrlHelper.buildUrl(action, urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getParameters(), urlComponent.getPortletUrlType(), urlComponent.getPortletMode(), urlComponent.getWindowState());
    }

    private boolean onlyValueSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() != null && urlComponent.getAction() == null;
    }

    private boolean onlyActionSpecified(UrlProvider urlComponent) {
        return urlComponent.getValue() == null && urlComponent.getAction() != null;
    }

    public void renderFormUrl(Form formComponent) {
        String action;
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.renderFormUrl(formComponent);
            return;
        }
        String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
        if (formComponent.action != null) {
            action = formComponent.findString(formComponent.action);
        } else {
            ActionInvocation ai = formComponent.getStack().getActionContext().getActionInvocation();
            action = ai.getProxy().getActionName();
        }
        String type = "action";
        if (StringUtils.isNotEmpty((CharSequence)formComponent.method) && "GET".equalsIgnoreCase(formComponent.method.trim())) {
            type = "render";
        }
        if (action != null) {
            String result = this.portletUrlHelper.buildUrl(action, namespace, null, formComponent.getAttributes(), type, formComponent.portletMode, formComponent.windowState);
            formComponent.addParameter("action", (Object)result);
            String id = formComponent.getId();
            if (id == null) {
                int slash = action.lastIndexOf(47);
                int dot = action.indexOf(46, slash);
                id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                String escapedId = formComponent.escape(id);
                formComponent.addParameter("id", (Object)escapedId);
                formComponent.addParameter("escapedId", (Object)escapedId);
            }
        }
    }

    public void beforeRenderUrl(UrlProvider urlComponent) {
        if (PortletActionContext.getPortletContext() == null) {
            this.servletRenderer.beforeRenderUrl(urlComponent);
        }
    }
}

