/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class JsopDiff
implements NodeStateDiff {
    private final JsopBuilder jsop;
    private final BlobSerializer blobs;
    private final String path;
    private final int depth;

    private JsopDiff(JsopBuilder jsop, BlobSerializer blobs, String path, int depth) {
        this.jsop = jsop;
        this.blobs = blobs;
        this.path = path != null ? path : "/";
        this.depth = depth >= 0 ? depth : Integer.MAX_VALUE;
    }

    public JsopDiff(BlobSerializer blobs, String path) {
        this(new JsopBuilder(), blobs, path, Integer.MAX_VALUE);
    }

    public JsopDiff(BlobSerializer blobs) {
        this(blobs, "/");
    }

    public JsopDiff(String path, int depth) {
        this(new JsopBuilder(), new BlobSerializer(), path, depth);
    }

    public JsopDiff() {
        this("/", Integer.MAX_VALUE);
    }

    public static String diffToJsop(NodeState before, NodeState after) {
        JsopDiff diff = new JsopDiff();
        after.compareAgainstBaseState(before, diff);
        return diff.toString();
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        this.jsop.tag('^').key(this.buildPath(after.getName()));
        new JsonSerializer(this.jsop, this.blobs).serialize(after);
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.jsop.tag('^').key(this.buildPath(after.getName()));
        new JsonSerializer(this.jsop, this.blobs).serialize(after);
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        this.jsop.tag('^').key(this.buildPath(before.getName())).value(null);
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        this.jsop.tag('+').key(this.buildPath(name));
        new JsonSerializer(this.jsop, this.blobs).serialize(after);
        return true;
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        this.jsop.tag('-').value(this.buildPath(name));
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (this.depth > 0) {
            after.compareAgainstBaseState(before, new JsopDiff(this.jsop, this.blobs, this.buildPath(name), this.depth - 1));
        } else {
            this.jsop.tag('^');
            this.jsop.key(this.buildPath(name));
            this.jsop.object();
            this.jsop.endObject();
        }
        return true;
    }

    public String toString() {
        return this.jsop.toString();
    }

    protected String buildPath(String name) {
        return PathUtils.concat(this.path, name);
    }
}

