/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.settings.impl.SlingIdUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
@ServiceDescription(value="Apache Sling Settings Service")
public class SlingSettingsServiceImpl
implements SlingSettingsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String slingId;
    private String slingHome;
    private URL slingHomeUrl;
    private Set<String> runModes;
    private Configuration configuration;
    private static final String ID_FILE = "sling.id.file";
    private static final String OPTIONS_FILE = "sling.options.file";

    @Activate
    public SlingSettingsServiceImpl(Configuration configuration, BundleContext context) {
        this.configuration = configuration;
        this.setupSlingHome(context);
        this.setupSlingId(context);
        this.setupRunModes(context);
    }

    public SlingSettingsServiceImpl(String runModes) {
        this.runModes = this.parseRunModes(runModes);
    }

    private void setupSlingHome(BundleContext context) {
        this.slingHome = context.getProperty("sling.home");
        String url = context.getProperty("sling.home.url");
        if (url != null) {
            try {
                this.slingHomeUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.logger.error("Sling home url is not a url: {}", (Object)url);
            }
        }
    }

    private void setupSlingId(BundleContext context) {
        File idFile = context.getDataFile(ID_FILE);
        if (idFile == null) {
            throw new RuntimeException("Unable to read from bundle data file.");
        }
        try {
            this.slingId = SlingIdUtil.readSlingId(idFile);
            this.logger.info("Read Sling ID {} from file {}", (Object)this.slingId, (Object)idFile);
        }
        catch (Throwable t) {
            this.logger.error("Failed reading Sling ID from file " + String.valueOf(idFile), t);
        }
        if (this.slingId == null) {
            this.slingId = SlingIdUtil.createSlingId();
            this.logger.info("Created new Sling ID {}", (Object)this.slingId);
            try {
                SlingIdUtil.writeSlingId(idFile, this.slingId);
            }
            catch (Throwable t) {
                this.logger.error("Failed writing Sling ID to file " + String.valueOf(idFile), t);
            }
        }
    }

    private List<Options> handleOptions(Set<String> modesSet, String propOptions) {
        ArrayList<Options> optionsList = new ArrayList<Options>();
        if (propOptions != null && propOptions.trim().length() > 0) {
            String[] options;
            for (String opt : options = propOptions.trim().split("\\|")) {
                String selected = null;
                String[] modes = opt.trim().split(",");
                for (int i = 0; i < modes.length; ++i) {
                    modes[i] = modes[i].trim();
                    if (selected != null) {
                        modesSet.remove(modes[i]);
                        continue;
                    }
                    if (!modesSet.contains(modes[i])) continue;
                    selected = modes[i];
                }
                if (selected == null) {
                    selected = modes[0];
                    modesSet.add(modes[0]);
                }
                Options o = new Options();
                o.selected = selected;
                o.modes = modes;
                optionsList.add(o);
            }
        }
        return optionsList;
    }

    private Set<String> parseRunModes(String runModes) {
        HashSet<String> modesSet = new HashSet<String>();
        String[] modes = runModes.split(",");
        for (int i = 0; i < modes.length; ++i) {
            modesSet.add(modes[i].trim());
        }
        return modesSet;
    }

    private void setupRunModes(BundleContext context) {
        String prop = context.getProperty("sling.run.modes");
        Set<String> modesSet = prop != null && prop.trim().length() > 0 ? this.parseRunModes(prop) : new HashSet<String>();
        this.handleOptions(modesSet, context.getProperty("sling.run.mode.options"));
        List<Options> storedOptions = this.readOptions(context);
        if (storedOptions != null) {
            for (Options o : storedOptions) {
                for (String m : o.modes) {
                    modesSet.remove(m);
                }
                modesSet.add(o.selected);
            }
        }
        List<Options> optionsList = this.handleOptions(modesSet, context.getProperty("sling.run.mode.install.options"));
        this.writeOptions(context, optionsList);
        this.runModes = Collections.unmodifiableSet(modesSet);
        if (this.runModes.size() > 0) {
            this.logger.info("Active run modes: {}", this.runModes);
        } else {
            this.logger.info("No run modes active");
        }
    }

    private List<Options> readOptions(BundleContext context) {
        List optionsList = null;
        File file = context.getDataFile(OPTIONS_FILE);
        if (file.exists()) {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                optionsList = (List)ois.readObject();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read from options data file.", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to read from options data file.", cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return optionsList;
    }

    void writeOptions(BundleContext context, List<Options> optionsList) {
        File file = context.getDataFile(OPTIONS_FILE);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(optionsList);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write to options data file.", ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getAbsolutePathWithinSlingHome(String relativePath) {
        return new File(this.slingHome, relativePath).getAbsolutePath();
    }

    @Override
    public String getSlingId() {
        return this.slingId;
    }

    @Override
    public URL getSlingHome() {
        return this.slingHomeUrl;
    }

    @Override
    public String getSlingHomePath() {
        return this.slingHome;
    }

    @Override
    public Set<String> getRunModes() {
        return this.runModes;
    }

    @Override
    public int getBestRunModeMatchCountFromSpec(String spec) {
        return SlingSettingsServiceImpl.getBestRunModeMatchCountFromSpec(spec, this.runModes);
    }

    static int getBestRunModeMatchCountFromSpec(String spec, Collection<String> activeRunModes) {
        int numMatchingRunModes = 0;
        for (String discjunctivePart : spec.split(Pattern.quote(","))) {
            int newNumMatchingRunModes = SlingSettingsServiceImpl.getBestRunModeMatchCountFromConjunctions(discjunctivePart, activeRunModes);
            if (newNumMatchingRunModes <= numMatchingRunModes) continue;
            numMatchingRunModes = newNumMatchingRunModes;
        }
        return numMatchingRunModes;
    }

    static int getBestRunModeMatchCountFromConjunctions(String conjunctions, Collection<String> activeRunModes) {
        int numMatchingRunModes = 0;
        for (String conjunctivePart : conjunctions.split(Pattern.quote("."))) {
            if (conjunctivePart.startsWith("-") ? activeRunModes.contains(conjunctivePart.substring("-".length())) : !activeRunModes.contains(conjunctivePart)) {
                return 0;
            }
            ++numMatchingRunModes;
        }
        return numMatchingRunModes;
    }

    @Override
    public String getSlingName() {
        Object name = this.configuration.sling_name();
        if (name == null) {
            name = "Instance " + this.slingId;
        }
        return name;
    }

    @Override
    public String getSlingDescription() {
        Object desc = this.configuration.sling_description();
        if (desc == null) {
            desc = "Instance with id " + this.slingId + " and run modes " + String.valueOf(this.getRunModes());
        }
        return desc;
    }

    @Modified
    public void update(Configuration configuration) {
        this.configuration = configuration;
    }

    @ObjectClassDefinition(id="org.apache.sling.settings.impl.SlingSettingsServiceImpl", name="Apache Sling Settings Service", description="The settings service manages some basic settings of Sling like run modes or information about the current instance.")
    static @interface Configuration {
        @AttributeDefinition(name="Instance Name", description="A human readable name for the current instance.")
        public String sling_name();

        @AttributeDefinition(name="Instance Description", description="A human readable description for the current instance.")
        public String sling_description();
    }

    static final class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String[] modes;
        String selected;

        Options() {
        }
    }
}

