/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.netflix.spectator.api.Registry;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.metrics.core.meter.ConsumerMeters;
import org.apache.servicecomb.metrics.core.meter.EdgeMeters;
import org.apache.servicecomb.metrics.core.meter.ProducerMeters;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeters;

public class InvocationMetersInitializer
implements MetricsInitializer {
    private ConsumerMeters consumerMeters;
    private ProducerMeters producerMeters;
    private EdgeMeters edgeMeters;

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        Registry registry = globalRegistry.getDefaultRegistry();
        this.consumerMeters = new ConsumerMeters(registry);
        this.producerMeters = new ProducerMeters(registry);
        this.edgeMeters = new EdgeMeters(registry);
        eventBus.register((Object)this);
    }

    protected AbstractInvocationMeters findInvocationMeters(Invocation invocation) {
        if (invocation.isConsumer()) {
            if (invocation.isEdge()) {
                return this.edgeMeters.getInvocationMeters();
            }
            return this.consumerMeters.getInvocationMeters();
        }
        return this.producerMeters.getInvocationMeters();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onInvocationStart(InvocationStartEvent event) {
        AbstractInvocationMeters invocationMeters = this.findInvocationMeters(event.getInvocation());
        invocationMeters.onInvocationStart(event);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onInvocationFinish(InvocationFinishEvent event) {
        AbstractInvocationMeters invocationMeters = this.findInvocationMeters(event.getInvocation());
        invocationMeters.onInvocationFinish(event);
    }
}

