/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.ManyPullRequest;
import org.apache.rocketmq.broker.longpolling.PullRequestHoldService;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class LmqPullRequestHoldService
extends PullRequestHoldService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");

    public LmqPullRequestHoldService(BrokerController brokerController) {
        super(brokerController);
    }

    @Override
    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + LmqPullRequestHoldService.class.getSimpleName();
        }
        return LmqPullRequestHoldService.class.getSimpleName();
    }

    @Override
    public void checkHoldRequest() {
        for (String key : this.pullRequestTable.keySet()) {
            ManyPullRequest mpr;
            int idx = key.lastIndexOf("@");
            if (idx <= 0 || idx >= key.length() - 1) {
                this.pullRequestTable.remove(key);
                continue;
            }
            String topic = key.substring(0, idx);
            int queueId = Integer.parseInt(key.substring(idx + 1));
            try {
                long offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                this.notifyMessageArriving(topic, queueId, offset);
            }
            catch (Throwable e) {
                LOGGER.error("check hold request failed. topic={}, queueId={}", new Object[]{topic, queueId, e});
            }
            if (!MixAll.isLmq((String)topic) || (mpr = (ManyPullRequest)this.pullRequestTable.get(key)) != null && mpr.getPullRequestList() != null && !mpr.getPullRequestList().isEmpty()) continue;
            this.pullRequestTable.remove(key);
        }
    }
}

