/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.io.File;
import java.util.Properties;
import org.apache.nifi.minifi.properties.MultiSourceMinifiProperties;
import org.apache.nifi.minifi.properties.PropertiesLoader;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;

public class MiNiFiPropertiesLoader {
    private static final String DEFAULT_APPLICATION_PROPERTIES_FILE_PATH = NiFiBootstrapUtils.getDefaultApplicationPropertiesFilePath();
    private NiFiProperties instance;

    public NiFiProperties load(File file) {
        Properties properties = PropertiesLoader.load(file, "Application");
        return new MultiSourceMinifiProperties(properties);
    }

    public NiFiProperties load(String path) {
        if (path != null && !path.isBlank()) {
            return this.load(new File(path));
        }
        return this.loadDefault();
    }

    public NiFiProperties get() {
        if (this.instance == null) {
            this.instance = this.loadDefault();
        }
        return this.instance;
    }

    private NiFiProperties loadDefault() {
        return this.load(DEFAULT_APPLICATION_PROPERTIES_FILE_PATH);
    }
}

