/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.pregen.variant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.share.nls.NullLocaleContext;
import org.apache.myfaces.trinidadinternal.skin.pregen.config.PregenConfig;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.AccessibilityVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.AgentVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.ApplicationAndVersion;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.DirectionFilteringVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.FixedVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.LocaleVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.PlatformVariantExtractor;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariant;
import org.apache.myfaces.trinidadinternal.skin.pregen.variant.SkinVariantExtractor;
import org.apache.myfaces.trinidadinternal.style.util.StyleSheetVisitUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

public final class SkinVariants
implements Iterable<SkinVariant> {
    private final List<LocaleContext> _localeContexts;
    private final List<Integer> _platforms;
    private final List<ApplicationAndVersion> _appAndVersions;
    private final List<AccessibilityProfile> _accProfiles;
    private final List<PregenConfig.ContainerType> _containerTypes;
    private final List<PregenConfig.RequestType> _requestTypes;
    private final List<PregenConfig.StyleClassType> _styleClassTypes;

    public SkinVariants(StyleSheetDocument document, PregenConfig config) {
        SkinVariantExtractor<Integer> platformExtractor = this._getPlatformExtractor(config);
        SkinVariantExtractor<ApplicationAndVersion> agentExtractor = this._getAgentExtractor(config);
        SkinVariantExtractor<LocaleContext> localeExtractor = this._getLocaleExtractor(config);
        SkinVariantExtractor<AccessibilityProfile> accExtractor = this._getAccessibilityExtractor(config);
        this._extractVariants(document, localeExtractor, platformExtractor, agentExtractor, accExtractor);
        this._localeContexts = localeExtractor.getVariants();
        this._platforms = platformExtractor.getVariants();
        this._appAndVersions = agentExtractor.getVariants();
        this._accProfiles = accExtractor.getVariants();
        this._containerTypes = new ArrayList<PregenConfig.ContainerType>(config.getContainerTypes());
        this._requestTypes = new ArrayList<PregenConfig.RequestType>(config.getRequestTypes());
        this._styleClassTypes = new ArrayList<PregenConfig.StyleClassType>(config.getStyleClassTypes());
    }

    @Override
    public Iterator<SkinVariant> iterator() {
        return new VariantsIterator();
    }

    private SkinVariantExtractor<Integer> _getPlatformExtractor(PregenConfig config) {
        Collection<Integer> platforms = config.getPlatformVariants();
        if (platforms == PregenConfig.ALL_VARIANTS) {
            return new PlatformVariantExtractor();
        }
        return platforms.isEmpty() ? FixedVariantExtractor.extractor(0) : FixedVariantExtractor.extractor(platforms);
    }

    private SkinVariantExtractor<ApplicationAndVersion> _getAgentExtractor(PregenConfig config) {
        Collection<TrinidadAgent.Application> agentApplications = config.getAgentApplicationVariants();
        if (agentApplications.isEmpty()) {
            return FixedVariantExtractor.extractor(ApplicationAndVersion.UNKNOWN);
        }
        if (agentApplications == PregenConfig.ALL_VARIANTS) {
            agentApplications = null;
        }
        return new AgentVariantExtractor(agentApplications);
    }

    private SkinVariantExtractor<LocaleContext> _getLocaleExtractor(PregenConfig config) {
        SkinVariantExtractor<LocaleContext> localeExtractor;
        Collection<LocaleContext> locales = config.getLocaleVariants();
        if (locales == PregenConfig.ALL_VARIANTS) {
            localeExtractor = new LocaleVariantExtractor();
        } else {
            if (locales.isEmpty()) {
                locales = Arrays.asList(NullLocaleContext.getLeftToRightContext(), NullLocaleContext.getRightToLeftContext());
            }
            localeExtractor = FixedVariantExtractor.extractor(locales);
        }
        return this._filterDirections(localeExtractor, config);
    }

    private SkinVariantExtractor<LocaleContext> _filterDirections(SkinVariantExtractor<LocaleContext> localeExtractor, PregenConfig config) {
        Collection<Integer> directions = config.getReadingDirectionVariants();
        if (directions == PregenConfig.ALL_VARIANTS || directions.size() > 1) {
            return localeExtractor;
        }
        boolean rtlOnly = directions.contains(2);
        return new DirectionFilteringVariantExtractor(localeExtractor, rtlOnly);
    }

    private SkinVariantExtractor<AccessibilityProfile> _getAccessibilityExtractor(PregenConfig config) {
        Collection<AccessibilityProfile> accessibilityProfiles = config.getAccessibilityVariants();
        if (accessibilityProfiles == PregenConfig.ALL_VARIANTS) {
            return new AccessibilityVariantExtractor();
        }
        return accessibilityProfiles.isEmpty() ? FixedVariantExtractor.extractor(AccessibilityProfile.getDefaultInstance()) : FixedVariantExtractor.extractor(accessibilityProfiles);
    }

    private void _extractVariants(StyleSheetDocument document, StyleSheetVisitUtils.StyleSheetVisitor ... visitors) {
        Collection<StyleSheetNode> styleSheets = document.getStyleSheetsAsCollection();
        StyleSheetVisitUtils.StyleSheetVisitor compoundVisitor = StyleSheetVisitUtils.compoundStyleSheetVisitor(Arrays.asList(visitors));
        StyleSheetVisitUtils.visitStyleSheets(styleSheets, compoundVisitor);
    }

    private class VariantsIterator
    implements Iterator<SkinVariant> {
        private int _localeIndex = 0;
        private int _platformIndex = 0;
        private int _appAndVersionIndex = 0;
        private int _accProfileIndex = 0;
        private int _containerTypeIndex = 0;
        private int _requestTypeIndex = 0;
        private int _styleClassTypeIndex = 0;

        private VariantsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._localeIndex < SkinVariants.this._localeContexts.size() && this._platformIndex < SkinVariants.this._platforms.size() && this._appAndVersionIndex < SkinVariants.this._appAndVersions.size() && this._accProfileIndex < SkinVariants.this._accProfiles.size() && this._containerTypeIndex < SkinVariants.this._containerTypes.size() && this._requestTypeIndex < SkinVariants.this._requestTypes.size() && this._styleClassTypeIndex < SkinVariants.this._styleClassTypes.size();
        }

        @Override
        public SkinVariant next() {
            SkinVariant variant = this._getNextVariant();
            this._nextIndex();
            return variant;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private SkinVariant _getNextVariant() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new SkinVariant((LocaleContext)SkinVariants.this._localeContexts.get(this._localeIndex), (Integer)SkinVariants.this._platforms.get(this._platformIndex), (ApplicationAndVersion)SkinVariants.this._appAndVersions.get(this._appAndVersionIndex), (AccessibilityProfile)SkinVariants.this._accProfiles.get(this._accProfileIndex), (PregenConfig.ContainerType)((Object)SkinVariants.this._containerTypes.get(this._containerTypeIndex)), (PregenConfig.RequestType)((Object)SkinVariants.this._requestTypes.get(this._requestTypeIndex)), (PregenConfig.StyleClassType)((Object)SkinVariants.this._styleClassTypes.get(this._styleClassTypeIndex)));
        }

        private void _nextIndex() {
            ++this._localeIndex;
            if (this._localeIndex == SkinVariants.this._localeContexts.size()) {
                this._localeIndex = 0;
                ++this._accProfileIndex;
            }
            if (this._accProfileIndex == SkinVariants.this._accProfiles.size()) {
                this._accProfileIndex = 0;
                ++this._containerTypeIndex;
            }
            if (this._containerTypeIndex == SkinVariants.this._containerTypes.size()) {
                this._containerTypeIndex = 0;
                ++this._requestTypeIndex;
            }
            if (this._requestTypeIndex == SkinVariants.this._requestTypes.size()) {
                this._requestTypeIndex = 0;
                ++this._styleClassTypeIndex;
            }
            if (this._styleClassTypeIndex == SkinVariants.this._styleClassTypes.size()) {
                this._styleClassTypeIndex = 0;
                ++this._appAndVersionIndex;
            }
            if (this._appAndVersionIndex == SkinVariants.this._appAndVersions.size()) {
                this._appAndVersionIndex = 0;
                ++this._platformIndex;
            }
        }
    }
}

