/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.spi.ModelParser;
import org.apache.maven.api.spi.ModelParserException;

@Named
@Singleton
public class DefaultModelProcessor
implements ModelProcessor {
    private final ModelXmlFactory modelXmlFactory;
    private final List<ModelParser> modelParsers;

    @Inject
    public DefaultModelProcessor(ModelXmlFactory modelXmlFactory, @Nullable List<ModelParser> modelParsers) {
        this.modelXmlFactory = modelXmlFactory;
        this.modelParsers = modelParsers;
    }

    @Override
    public Path locateExistingPom(Path projectDirectory) {
        Path pom = this.modelParsers.stream().map(m -> m.locate(projectDirectory).map(Source::getPath).orElse(null)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.doLocateExistingPom(projectDirectory));
        if (pom != null && !pom.equals(projectDirectory) && !pom.getParent().equals(projectDirectory)) {
            throw new IllegalArgumentException("The POM found does not belong to the given directory: " + String.valueOf(pom));
        }
        return pom;
    }

    @Override
    public Model read(XmlReaderRequest request) throws IOException {
        Objects.requireNonNull(request, "source cannot be null");
        Path pomFile = request.getPath();
        if (pomFile != null) {
            Path projectDirectory = pomFile.getParent();
            ArrayList<ModelParserException> exceptions = new ArrayList<ModelParserException>();
            for (ModelParser parser : this.modelParsers) {
                try {
                    Optional model = parser.locateAndParse(projectDirectory, Map.of("strict", request.isStrict()));
                    if (!model.isPresent()) continue;
                    return ((Model)model.get()).withPomFile(pomFile);
                }
                catch (ModelParserException e) {
                    exceptions.add(e);
                }
            }
            try {
                return this.doRead(request);
            }
            catch (IOException e) {
                exceptions.forEach(e::addSuppressed);
                throw e;
            }
        }
        return this.doRead(request);
    }

    private Path doLocateExistingPom(Path project) {
        if (project == null) {
            project = Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        if (Files.isDirectory(project, new LinkOption[0])) {
            Path pom = project.resolve("pom.xml");
            return Files.isRegularFile(pom, new LinkOption[0]) ? pom : null;
        }
        if (Files.isRegularFile(project, new LinkOption[0])) {
            return project;
        }
        return null;
    }

    private Model doRead(XmlReaderRequest request) throws IOException {
        return (Model)this.modelXmlFactory.read(request);
    }
}

