/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import thredds.catalog2.Metadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.MetadataBuilder;

class MetadataImpl
implements Metadata,
MetadataBuilder {
    private boolean isContainedContent;
    private String title;
    private URI externalReference;
    private String content;
    private boolean isBuilt;

    MetadataImpl() {
        this.isContainedContent = true;
        this.isBuilt = false;
    }

    MetadataImpl(boolean isContainedContent) {
        this.isContainedContent = isContainedContent;
        this.isBuilt = false;
    }

    MetadataImpl(String title, URI externalReference) {
        if (title == null) {
            throw new IllegalArgumentException("Title may not be null.");
        }
        if (externalReference == null) {
            throw new IllegalArgumentException("External reference URI may not be null.");
        }
        this.isContainedContent = false;
        this.title = title;
        this.externalReference = externalReference;
        this.content = null;
        this.isBuilt = false;
    }

    MetadataImpl(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content string may not be null.");
        }
        this.isContainedContent = true;
        this.title = null;
        this.externalReference = null;
        this.content = content;
        this.isBuilt = false;
    }

    @Override
    public void setContainedContent(boolean isContainedContent) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        this.isContainedContent = isContainedContent;
    }

    @Override
    public boolean isContainedContent() {
        return this.isContainedContent;
    }

    @Override
    public void setTitle(String title) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder contains content, cannot set title.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Title may not be null.");
        }
        this.title = title;
    }

    @Override
    public String getTitle() {
        if (this.isContainedContent) {
            throw new IllegalStateException("Metadata with contained content has no title.");
        }
        return this.title;
    }

    @Override
    public void setExternalReference(URI externalReference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder contains content, cannot set external reference.");
        }
        if (externalReference == null) {
            throw new IllegalArgumentException("External reference may not be null.");
        }
        this.externalReference = externalReference;
    }

    @Override
    public URI getExternalReference() {
        if (this.isContainedContent) {
            throw new IllegalStateException("Metadata with contained content has no external reference.");
        }
        return this.externalReference;
    }

    @Override
    public void setContent(String content) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has already been built.");
        }
        if (!this.isContainedContent) {
            throw new IllegalStateException("This MetadataBuilder has external reference, cannot set content.");
        }
        this.content = content;
    }

    @Override
    public String getContent() {
        if (!this.isContainedContent) {
            throw new IllegalStateException("Metadata with external reference has no content, dereference external reference to obtain metadata content.");
        }
        return this.content;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        if (this.isContainedContent) {
            if (this.content == null) {
                return new BuilderIssues(BuilderIssue.Severity.WARNING, "MetadataBuilder contains null content.", this, null);
            }
        } else if (this.title == null || this.externalReference == null) {
            return new BuilderIssues(BuilderIssue.Severity.WARNING, "MetadataBuilder with link has null title and/or link URI.", this, null);
        }
        return new BuilderIssues();
    }

    @Override
    public Metadata build() throws BuilderException {
        this.isBuilt = true;
        return this;
    }
}

