/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.Example;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.marshaller.Json5;

public class Parameter
extends OpenApiElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "path", "cookie"};
    private static final String[] VALID_STYLES = new String[]{"matrix", "label", "form", "simple", "spaceDelimited", "pipeDelimited", "deepObject"};
    private String name;
    private String in;
    private String description;
    private String style;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Boolean explode;
    private Boolean allowReserved;
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples;

    public Parameter() {
    }

    public Parameter(Parameter copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.description = copyFrom.description;
        this.style = copyFrom.style;
        this.required = copyFrom.required;
        this.deprecated = copyFrom.deprecated;
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.explode = copyFrom.explode;
        this.allowReserved = copyFrom.allowReserved;
        this.schema = copyFrom.schema;
        this.example = copyFrom.example;
        this.examples = CollectionUtils.copyOf(copyFrom.examples);
    }

    public Parameter copy() {
        return new Parameter(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "in" -> ConverterUtils.toType(this.getIn(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "required" -> ConverterUtils.toType(this.getRequired(), type);
            case "deprecated" -> ConverterUtils.toType(this.getDeprecated(), type);
            case "allowEmptyValue" -> ConverterUtils.toType(this.getAllowEmptyValue(), type);
            case "style" -> ConverterUtils.toType(this.getStyle(), type);
            case "explode" -> ConverterUtils.toType(this.getExplode(), type);
            case "allowReserved" -> ConverterUtils.toType(this.getAllowReserved(), type);
            case "schema" -> ConverterUtils.toType(this.getSchema(), type);
            case "example" -> ConverterUtils.toType(this.getExample(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            default -> super.get(property, type);
        };
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getExample() {
        return this.example;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public String getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public String getStyle() {
        return this.style;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.allowEmptyValue), "allowEmptyValue").addIf(Utils.nn(this.allowReserved), "allowReserved").addIf(Utils.nn(this.deprecated), "deprecated").addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.example), "example").addIf(Utils.nn(this.examples), "examples").addIf(Utils.nn(this.explode), "explode").addIf(Utils.nn(this.in), "in").addIf(Utils.nn(this.name), "name").addIf(Utils.nn(this.required), "required").addIf(Utils.nn(this.schema), "schema").addIf(Utils.nn(this.style), "style").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Parameter set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "allowEmptyValue" -> this.setAllowEmptyValue(ConverterUtils.toType(value, Boolean.class));
            case "allowReserved" -> this.setAllowReserved(ConverterUtils.toType(value, Boolean.class));
            case "description" -> this.setDescription(Utils.s(value));
            case "deprecated" -> this.setDeprecated(ConverterUtils.toType(value, Boolean.class));
            case "example" -> this.setExample(value);
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder(value, String.class, Example.class).sparse().build());
            case "explode" -> this.setExplode(ConverterUtils.toType(value, Boolean.class));
            case "in" -> this.setIn(Utils.s(value));
            case "name" -> this.setName(Utils.s(value));
            case "required" -> this.setRequired(ConverterUtils.toType(value, Boolean.class));
            case "schema" -> this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            case "style" -> this.setStyle(Utils.s(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Parameter setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public Parameter setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    public Parameter setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Parameter setDescription(String value) {
        this.description = value;
        return this;
    }

    public Parameter setExample(Object value) {
        this.example = value;
        return this;
    }

    public Parameter setExamples(Map<String, Example> value) {
        this.examples = value;
        return this;
    }

    public Parameter setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    public Parameter setIn(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_IN)) {
            throw ThrowableUtils.rex("Invalid value passed in to setIn(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_IN));
        }
        this.in = value;
        return this;
    }

    public Parameter setName(String value) {
        this.name = value;
        return this;
    }

    public Parameter setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public Parameter setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    public Parameter setStyle(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_STYLES)) {
            throw ThrowableUtils.rex("Invalid value passed in to setStyle(String).  Value=''{0}'', valid values={1}", value, Json5.of(VALID_STYLES));
        }
        this.style = value;
        return this;
    }

    @Override
    public Parameter strict() {
        super.strict();
        return this;
    }

    @Override
    public Parameter strict(Object value) {
        super.strict(value);
        return this;
    }
}

