/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.juneau.BeanSession;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Args
extends JsonMap {
    private static final long serialVersionUID = 1L;

    public Args(String args) {
        this(StringUtils.splitQuoted(args));
    }

    public Args(String[] args) {
        String s;
        List argList = Arrays.stream(args).collect(Collectors.toCollection(LinkedList::new));
        int i = 0;
        while (!argList.isEmpty() && !StringUtils.startsWith(s = (String)argList.get(0), '-')) {
            this.put(Integer.toString(i), argList.remove(0));
            ++i;
        }
        String key = null;
        while (!argList.isEmpty()) {
            String s2 = (String)argList.remove(0);
            if (StringUtils.startsWith(s2, '-')) {
                key = s2.substring(1);
                if (key.matches("\\d*")) {
                    throw ThrowableUtils.rex("Invalid optional key name ''{0}''", key);
                }
                if (this.containsKey(key)) continue;
                this.put(key, (Object)new JsonList());
                continue;
            }
            ((JsonList)this.get(key)).add(s2);
        }
    }

    @Override
    public Args append(Map<String, Object> values) {
        super.append(values);
        return this;
    }

    @Override
    public Args append(String key, Object value) {
        super.append(key, value);
        return this;
    }

    @Override
    public Args appendIf(boolean flag, String key, Object value) {
        super.appendIf(flag, key, value);
        return this;
    }

    @Override
    public Args filtered(Predicate<Object> value) {
        super.filtered(value);
        return this;
    }

    public <T> T getArg(Class<T> c, String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(0, c);
    }

    public String getArg(int i) {
        return this.getString(Integer.toString(i));
    }

    public String getArg(String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return l.get(0).toString();
        }
        return Arrays.toString(l.toArray()).replaceAll("[\\[\\]]", "");
    }

    public List<String> getArgs(String name) {
        JsonList l = (JsonList)this.get(name);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    public boolean hasArg(int i) {
        return this.containsKey(Integer.toString(i));
    }

    public boolean hasArg(String name) {
        return Utils.nn(this.get(name));
    }

    @Override
    public Args inner(Map<String, Object> inner) {
        super.inner(inner);
        return this;
    }

    @Override
    public Args keepAll(String ... keys) {
        super.keepAll(keys);
        return this;
    }

    @Override
    public Args modifiable() {
        return this;
    }

    @Override
    public Args session(BeanSession session) {
        super.session(session);
        return this;
    }

    @Override
    public Args setBeanSession(BeanSession value) {
        super.setBeanSession(value);
        return this;
    }

    @Override
    public Args unmodifiable() {
        return this;
    }
}

