/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.csv.CsvBeanPropertyMeta;
import org.apache.juneau.csv.CsvClassMeta;
import org.apache.juneau.csv.CsvCommon;
import org.apache.juneau.csv.CsvMetaProvider;
import org.apache.juneau.csv.CsvSerializerBuilder;
import org.apache.juneau.csv.CsvSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;

@ConfigurableContext
public final class CsvSerializer
extends WriterSerializer
implements CsvMetaProvider,
CsvCommon {
    static final String PREFIX = "CsvSerializer";
    public static final CsvSerializer DEFAULT = new CsvSerializer(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, CsvClassMeta> csvClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, CsvBeanPropertyMeta> csvBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, CsvBeanPropertyMeta>();

    public CsvSerializer(PropertyStore ps) {
        super(ps, "text/csv", null);
    }

    @Override
    public CsvSerializerBuilder builder() {
        return new CsvSerializerBuilder(this.getPropertyStore());
    }

    public static CsvSerializerBuilder create() {
        return new CsvSerializerBuilder();
    }

    @Override
    public CsvSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public CsvSerializerSession createSession(SerializerSessionArgs args) {
        return new CsvSerializerSession(this, args);
    }

    @Override
    public CsvClassMeta getCsvClassMeta(ClassMeta<?> cm) {
        CsvClassMeta m = this.csvClassMetas.get(cm);
        if (m == null) {
            m = new CsvClassMeta(cm, this);
            this.csvClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public CsvBeanPropertyMeta getCsvBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return CsvBeanPropertyMeta.DEFAULT;
        }
        CsvBeanPropertyMeta m = this.csvBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new CsvBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.csvBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

