/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.Position;
import org.apache.juneau.parser.Positionable;

public final class XmlReader
implements XMLStreamReader,
Positionable {
    private final ParserPipe pipe;
    private final XMLStreamReader sr;

    protected XmlReader(ParserPipe pipe, boolean validating, XMLReporter reporter, XMLResolver resolver, XMLEventAllocator eventAllocator) throws IOException, XMLStreamException {
        this.pipe = pipe;
        try {
            Reader r = pipe.getBufferedReader();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isValidating", validating);
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            if (factory.isPropertySupported("javax.xml.stream.reporter") && reporter != null) {
                factory.setProperty("javax.xml.stream.reporter", reporter);
            }
            if (factory.isPropertySupported("javax.xml.stream.resolver") && resolver != null) {
                factory.setProperty("javax.xml.stream.resolver", resolver);
            }
            if (factory.isPropertySupported("javax.xml.stream.allocator") && eventAllocator != null) {
                factory.setProperty("javax.xml.stream.allocator", eventAllocator);
            }
            this.sr = factory.createXMLStreamReader(r);
            this.sr.nextTag();
            pipe.setPositionable(this);
        }
        catch (Error e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public ParserPipe getPipe() {
        return this.pipe;
    }

    @Override
    public void close() throws XMLStreamException {
        this.sr.close();
    }

    @Override
    public int getAttributeCount() {
        return this.sr.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.sr.getAttributeLocalName(index);
    }

    @Override
    public QName getAttributeName(int index) {
        return this.sr.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.sr.getAttributeNamespace(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.sr.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.sr.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.sr.getAttributeValue(index);
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.sr.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.sr.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.sr.getElementText();
    }

    @Override
    public String getEncoding() {
        return this.sr.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.sr.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.sr.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.sr.getLocation();
    }

    @Override
    public QName getName() {
        return this.sr.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.sr.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.sr.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.sr.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI() {
        return this.sr.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.sr.getNamespaceURI(prefix);
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.sr.getNamespaceURI(index);
    }

    @Override
    public String getPIData() {
        return this.sr.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.sr.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.sr.getPrefix();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.sr.getProperty(name);
    }

    @Override
    public String getText() {
        return this.sr.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.sr.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.sr.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        return this.sr.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.sr.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.sr.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.sr.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.sr.hasNext();
    }

    @Override
    public boolean hasText() {
        return this.sr.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.sr.isAttributeSpecified(index);
    }

    @Override
    public boolean isCharacters() {
        return this.sr.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.sr.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.sr.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.sr.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.sr.isWhiteSpace();
    }

    @Override
    public int next() throws XMLStreamException {
        return this.sr.next();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.sr.nextTag();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.sr.require(type, namespaceURI, localName);
    }

    @Override
    public boolean standaloneSet() {
        return this.sr.standaloneSet();
    }

    @Override
    public Position getPosition() {
        Location l = this.getLocation();
        return new Position(l.getLineNumber(), l.getColumnNumber());
    }
}

