/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class TaskType {
    private final String typeName;

    public static TaskType of(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("Task type should be defined");
        }
        return new TaskType(typeName);
    }

    private TaskType(String typeName) {
        this.typeName = typeName;
    }

    public String asString() {
        return this.typeName;
    }

    public final boolean equals(Object o) {
        if (o instanceof TaskType) {
            TaskType taskId = (TaskType)o;
            return Objects.equals(this.typeName, taskId.typeName);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.typeName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeName", (Object)this.typeName).toString();
    }
}

