/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Flags;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.ReplaceRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.streams.Iterators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReplaceProcessor
extends AbstractMailboxProcessor<ReplaceRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplaceProcessor.class);
    private static final ImmutableList<Capability> CAPABILITIES = ImmutableList.of((Object)Capability.of("REPLACE"));
    private final PathConverter.Factory pathConverterFactory;

    public ReplaceProcessor(MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(ReplaceRequest.class, mailboxManager, statusResponseFactory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected Mono<Void> processRequestReactive(ReplaceRequest request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = request.getMailboxName();
        Content messageIn = request.getMessage().asMailboxContent();
        Date datetime = request.getDatetime();
        Flags flags = request.getFlags();
        MailboxPath mailboxPath = this.pathConverterFactory.forSession(session).buildFullPath(mailboxName);
        MailboxManager mailboxManager = this.getMailboxManager();
        session.stopDetectingCommandInjection();
        return this.append(session, responder, messageIn, datetime, flags, mailboxPath, mailboxManager).then(this.deleteBaseMessage(request, session)).then(Mono.defer(() -> this.unsolicitedResponses(session, responder, request.isUseUid()))).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).then().doOnEach(ReactorUtils.logOnError(MailboxNotFoundException.class, e -> LOGGER.debug("Append failed for mailbox {}", (Object)mailboxPath, e))).onErrorResume(MailboxNotFoundException.class, e -> {
            this.no(request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(OverQuotaException.class, e -> LOGGER.info("Append failed for mailbox {} because overquota", (Object)mailboxPath))).onErrorResume(OverQuotaException.class, e -> {
            this.no(request, responder, HumanReadableText.FAILURE_OVERQUOTA, StatusResponse.ResponseCode.overQuota());
            return Mono.empty();
        }).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("Append failed for mailbox {}", (Object)mailboxPath, e))).onErrorResume(MailboxException.class, e -> {
            this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return Mono.empty();
        });
    }

    private Mono<Void> append(ImapSession session, ImapProcessor.Responder responder, Content messageIn, Date datetime, Flags flags, MailboxPath mailboxPath, MailboxManager mailboxManager) {
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, session.getMailboxSession())).flatMap(mailbox -> this.appendToMailbox(messageIn, datetime, flags, session, (MessageManager)mailbox, responder));
    }

    private Mono<Void> deleteBaseMessage(ReplaceRequest request, ImapSession session) {
        try {
            ImmutableList uids = (ImmutableList)Iterators.toStream((Iterator)this.messageRange(session.getSelected(), new IdRange(request.getId()), request.isUseUid()).orElseThrow(() -> new MessageRangeException(request.getId() + " is an invalid range")).iterator()).collect(ImmutableList.toImmutableList());
            return this.getSelectedMailboxReactive(session).flatMap(messageManager -> messageManager.deleteReactive((List)uids, session.getMailboxSession())).then(Mono.fromRunnable(() -> uids.forEach(session.getSelected()::removeRecent)));
        }
        catch (MessageRangeException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Mono<Void> appendToMailbox(Content message, Date datetime, Flags flagsToBeSet, ImapSession session, MessageManager mailbox, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = session.getMailboxSession();
        SelectedMailbox selectedMailbox = session.getSelected();
        boolean isSelectedMailbox = selectedMailbox.getMailboxId().equals((Object)mailbox.getId());
        return Mono.from((Publisher)mailbox.appendMessageReactive(MessageManager.AppendCommand.builder().withInternalDate(datetime).withFlags(flagsToBeSet).isRecent(!isSelectedMailbox).build(message), mailboxSession)).map(MessageManager.AppendResult::getId).map(Throwing.function(messageId -> {
            if (isSelectedMailbox) {
                selectedMailbox.addRecent(messageId.getUid());
            }
            return messageId;
        }).sneakyThrow()).flatMap(messageId -> Mono.fromCallable(() -> {
            UidValidity uidValidity = mailbox.getMailboxEntity().getUidValidity();
            StatusResponse.ResponseCode responseCode = StatusResponse.ResponseCode.appendUid(uidValidity, new UidRange[]{new UidRange(messageId.getUid())});
            responder.respond(this.getStatusResponseFactory().untaggedOk(HumanReadableText.REPLACE_READY, responseCode));
            return null;
        })).then();
    }

    @Override
    protected MDCBuilder mdc(ReplaceRequest request) {
        return MDCBuilder.create().addToContext("action", "REPLACE").addToContext("mailbox", request.getMailboxName()).addToContext("id", Long.toString(request.getId()));
    }
}

