/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordUpdateBehaviorRequestControlProperties;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordUpdateBehaviorRequestControl
extends Control {
    @NotNull
    public static final String PASSWORD_UPDATE_BEHAVIOR_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.51";
    private static final byte TYPE_IS_SELF_CHANGE = -128;
    private static final byte TYPE_ALLOW_PRE_ENCODED_PASSWORD = -127;
    private static final byte TYPE_SKIP_PASSWORD_VALIDATION = -126;
    private static final byte TYPE_IGNORE_PASSWORD_HISTORY = -125;
    private static final byte TYPE_IGNORE_MINIMUM_PASSWORD_AGE = -124;
    private static final byte TYPE_PASSWORD_STORAGE_SCHEME = -123;
    private static final byte TYPE_MUST_CHANGE_PASSWORD = -122;
    @NotNull
    private static final String JSON_FIELD_ALLOW_PRE_ENCODED_PASSWORD = "allow-pre-encoded-password";
    @NotNull
    private static final String JSON_FIELD_IGNORE_MINIMUM_PASSWORD_AGE = "ignore-minimum-password-age";
    @NotNull
    private static final String JSON_FIELD_IGNORE_PASSWORD_HISTORY = "ignore-password-history";
    @NotNull
    private static final String JSON_FIELD_IS_SELF_CHANGE = "is-self-change";
    @NotNull
    private static final String JSON_FIELD_MUST_CHANGE_PASSWORD = "must-change-password";
    @NotNull
    private static final String JSON_FIELD_PASSWORD_STORAGE_SCHEME = "password-storage-scheme";
    @NotNull
    private static final String JSON_FIELD_SKIP_PASSWORD_VALIDATION = "skip-password-validation";
    private static final long serialVersionUID = -1915608505128236450L;
    @Nullable
    private final Boolean allowPreEncodedPassword;
    @Nullable
    private final Boolean ignoreMinimumPasswordAge;
    @Nullable
    private final Boolean ignorePasswordHistory;
    @Nullable
    private final Boolean isSelfChange;
    @Nullable
    private final Boolean mustChangePassword;
    @Nullable
    private final Boolean skipPasswordValidation;
    @Nullable
    private final String passwordStorageScheme;

    public PasswordUpdateBehaviorRequestControl(@NotNull PasswordUpdateBehaviorRequestControlProperties properties, boolean isCritical) {
        super(PASSWORD_UPDATE_BEHAVIOR_REQUEST_OID, isCritical, PasswordUpdateBehaviorRequestControl.encodeValue(properties));
        this.isSelfChange = properties.getIsSelfChange();
        this.allowPreEncodedPassword = properties.getAllowPreEncodedPassword();
        this.skipPasswordValidation = properties.getSkipPasswordValidation();
        this.ignorePasswordHistory = properties.getIgnorePasswordHistory();
        this.ignoreMinimumPasswordAge = properties.getIgnoreMinimumPasswordAge();
        this.passwordStorageScheme = properties.getPasswordStorageScheme();
        this.mustChangePassword = properties.getMustChangePassword();
    }

    public PasswordUpdateBehaviorRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_UPDATE_BEHAVIOR_REQ_DECODE_NO_VALUE.get());
        }
        try {
            Boolean allowPreEncoded = null;
            Boolean ignoreAge = null;
            Boolean ignoreHistory = null;
            Boolean mustChange = null;
            Boolean selfChange = null;
            Boolean skipValidation = null;
            String scheme = null;
            block11: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        selfChange = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -127: {
                        allowPreEncoded = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -126: {
                        skipValidation = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -125: {
                        ignoreHistory = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -124: {
                        ignoreAge = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    case -123: {
                        scheme = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block11;
                    }
                    case -122: {
                        mustChange = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block11;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_UPDATE_BEHAVIOR_REQ_DECODE_UNRECOGNIZED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.isSelfChange = selfChange;
            this.allowPreEncodedPassword = allowPreEncoded;
            this.skipPasswordValidation = skipValidation;
            this.ignorePasswordHistory = ignoreHistory;
            this.ignoreMinimumPasswordAge = ignoreAge;
            this.passwordStorageScheme = scheme;
            this.mustChangePassword = mustChange;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_UPDATE_BEHAVIOR_REQ_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull PasswordUpdateBehaviorRequestControlProperties properties) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(6);
        if (properties.getIsSelfChange() != null) {
            elements.add(new ASN1Boolean(-128, properties.getIsSelfChange()));
        }
        if (properties.getAllowPreEncodedPassword() != null) {
            elements.add(new ASN1Boolean(-127, properties.getAllowPreEncodedPassword()));
        }
        if (properties.getSkipPasswordValidation() != null) {
            elements.add(new ASN1Boolean(-126, properties.getSkipPasswordValidation()));
        }
        if (properties.getIgnorePasswordHistory() != null) {
            elements.add(new ASN1Boolean(-125, properties.getIgnorePasswordHistory()));
        }
        if (properties.getIgnoreMinimumPasswordAge() != null) {
            elements.add(new ASN1Boolean(-124, properties.getIgnoreMinimumPasswordAge()));
        }
        if (properties.getPasswordStorageScheme() != null) {
            elements.add(new ASN1OctetString(-123, properties.getPasswordStorageScheme()));
        }
        if (properties.getMustChangePassword() != null) {
            elements.add(new ASN1Boolean(-122, properties.getMustChangePassword()));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public Boolean getIsSelfChange() {
        return this.isSelfChange;
    }

    @Nullable
    public Boolean getAllowPreEncodedPassword() {
        return this.allowPreEncodedPassword;
    }

    @Nullable
    public Boolean getSkipPasswordValidation() {
        return this.skipPasswordValidation;
    }

    @Nullable
    public Boolean getIgnorePasswordHistory() {
        return this.ignorePasswordHistory;
    }

    @Nullable
    public Boolean getIgnoreMinimumPasswordAge() {
        return this.ignoreMinimumPasswordAge;
    }

    @Nullable
    public String getPasswordStorageScheme() {
        return this.passwordStorageScheme;
    }

    @Nullable
    public Boolean getMustChangePassword() {
        return this.mustChangePassword;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_PW_UPDATE_BEHAVIOR_REQ_CONTROL_NAME.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.isSelfChange != null) {
            valueFields.put(JSON_FIELD_IS_SELF_CHANGE, new JSONBoolean(this.isSelfChange));
        }
        if (this.allowPreEncodedPassword != null) {
            valueFields.put(JSON_FIELD_ALLOW_PRE_ENCODED_PASSWORD, new JSONBoolean(this.allowPreEncodedPassword));
        }
        if (this.skipPasswordValidation != null) {
            valueFields.put(JSON_FIELD_SKIP_PASSWORD_VALIDATION, new JSONBoolean(this.skipPasswordValidation));
        }
        if (this.ignorePasswordHistory != null) {
            valueFields.put(JSON_FIELD_IGNORE_PASSWORD_HISTORY, new JSONBoolean(this.ignorePasswordHistory));
        }
        if (this.ignoreMinimumPasswordAge != null) {
            valueFields.put(JSON_FIELD_IGNORE_MINIMUM_PASSWORD_AGE, new JSONBoolean(this.ignoreMinimumPasswordAge));
        }
        if (this.passwordStorageScheme != null) {
            valueFields.put(JSON_FIELD_PASSWORD_STORAGE_SCHEME, new JSONString(this.passwordStorageScheme));
        }
        if (this.mustChangePassword != null) {
            valueFields.put(JSON_FIELD_MUST_CHANGE_PASSWORD, new JSONBoolean(this.mustChangePassword));
        }
        return new JSONObject(new JSONField("oid", PASSWORD_UPDATE_BEHAVIOR_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_PW_UPDATE_BEHAVIOR_REQ_CONTROL_NAME.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static PasswordUpdateBehaviorRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        Boolean mustChangePassword;
        String passwordStorageScheme;
        Boolean ignoreMinimumPasswordAge;
        Boolean ignorePasswordHistory;
        Boolean skipPasswordValidation;
        Boolean allowPreEncodedPassword;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new PasswordUpdateBehaviorRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        PasswordUpdateBehaviorRequestControlProperties properties = new PasswordUpdateBehaviorRequestControlProperties();
        JSONObject valueObject = jsonControl.getValueObject();
        Boolean isSelfChange = valueObject.getFieldAsBoolean(JSON_FIELD_IS_SELF_CHANGE);
        if (isSelfChange != null) {
            properties.setIsSelfChange(isSelfChange);
        }
        if ((allowPreEncodedPassword = valueObject.getFieldAsBoolean(JSON_FIELD_ALLOW_PRE_ENCODED_PASSWORD)) != null) {
            properties.setAllowPreEncodedPassword(allowPreEncodedPassword);
        }
        if ((skipPasswordValidation = valueObject.getFieldAsBoolean(JSON_FIELD_SKIP_PASSWORD_VALIDATION)) != null) {
            properties.setSkipPasswordValidation(skipPasswordValidation);
        }
        if ((ignorePasswordHistory = valueObject.getFieldAsBoolean(JSON_FIELD_IGNORE_PASSWORD_HISTORY)) != null) {
            properties.setIgnorePasswordHistory(ignorePasswordHistory);
        }
        if ((ignoreMinimumPasswordAge = valueObject.getFieldAsBoolean(JSON_FIELD_IGNORE_MINIMUM_PASSWORD_AGE)) != null) {
            properties.setIgnoreMinimumPasswordAge(ignoreMinimumPasswordAge);
        }
        if ((passwordStorageScheme = valueObject.getFieldAsString(JSON_FIELD_PASSWORD_STORAGE_SCHEME)) != null) {
            properties.setPasswordStorageScheme(passwordStorageScheme);
        }
        if ((mustChangePassword = valueObject.getFieldAsBoolean(JSON_FIELD_MUST_CHANGE_PASSWORD)) != null) {
            properties.setMustChangePassword(mustChangePassword);
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_IS_SELF_CHANGE, JSON_FIELD_ALLOW_PRE_ENCODED_PASSWORD, JSON_FIELD_SKIP_PASSWORD_VALIDATION, JSON_FIELD_IGNORE_PASSWORD_HISTORY, JSON_FIELD_IGNORE_MINIMUM_PASSWORD_AGE, JSON_FIELD_PASSWORD_STORAGE_SCHEME, JSON_FIELD_MUST_CHANGE_PASSWORD)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PW_UPDATE_BEHAVIOR_REQ_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new PasswordUpdateBehaviorRequestControl(properties, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordUpdateBehaviorRequestControl(oid='");
        buffer.append(PASSWORD_UPDATE_BEHAVIOR_REQUEST_OID);
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", properties=");
        new PasswordUpdateBehaviorRequestControlProperties(this).toString(buffer);
        buffer.append(')');
    }
}

