/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TLoadSample;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.AbstractStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;

public class AINodeHeartbeatCache
extends BaseNodeCache {
    private final AtomicReference<TLoadSample> latestLoadSample = new AtomicReference<TLoadSample>(new TLoadSample());

    public AINodeHeartbeatCache(int aiNodeId) {
        super(aiNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentStatistics(boolean forceUpdate) {
        NodeStatus status = null;
        String statusReason = null;
        long currentNanoTime = System.nanoTime();
        List list = this.slidingWindow;
        synchronized (list) {
            NodeHeartbeatSample lastSample = (NodeHeartbeatSample)this.getLastSample();
            List<AbstractHeartbeatSample> heartbeatHistory = Collections.unmodifiableList(this.slidingWindow);
            if (lastSample != null && lastSample.isSetLoadSample()) {
                this.latestLoadSample.set(lastSample.getLoadSample());
            }
            if (lastSample != null && NodeStatus.Removing.equals((Object)lastSample.getStatus())) {
                status = NodeStatus.Removing;
            } else if (!this.failureDetector.isAvailable(this.nodeId, heartbeatHistory)) {
                status = NodeStatus.Unknown;
            } else if (lastSample != null) {
                status = lastSample.getStatus();
                statusReason = lastSample.getStatusReason();
            }
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(currentNanoTime, status, statusReason, loadScore);
        if (!((AbstractStatistics)this.currentStatistics.get()).equals(newStatistics)) {
            this.currentStatistics.set(newStatistics);
        }
    }
}

