/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.storage.blob.implementation.models.FilterBlobItem;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FilterBlobSegment
implements XmlSerializable<FilterBlobSegment> {
    private String serviceEndpoint;
    private String where;
    private List<FilterBlobItem> blobs;
    private String nextMarker;

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public FilterBlobSegment setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public FilterBlobSegment setWhere(String where) {
        this.where = where;
        return this;
    }

    public List<FilterBlobItem> getBlobs() {
        if (this.blobs == null) {
            this.blobs = new ArrayList<FilterBlobItem>();
        }
        return this.blobs;
    }

    public FilterBlobSegment setBlobs(List<FilterBlobItem> blobs) {
        this.blobs = blobs;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public FilterBlobSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringElement("Where", this.where);
        if (this.blobs != null) {
            xmlWriter.writeStartElement("Blobs");
            for (FilterBlobItem element : this.blobs) {
                xmlWriter.writeXml((XmlSerializable)element, "Blob");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static FilterBlobSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FilterBlobSegment.fromXml(xmlReader, null);
    }

    public static FilterBlobSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        return (FilterBlobSegment)xmlReader.readObject(finalRootElementName, reader -> {
            FilterBlobSegment deserializedFilterBlobSegment = new FilterBlobSegment();
            deserializedFilterBlobSegment.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Where".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobSegment.where = reader.getStringElement();
                    continue;
                }
                if ("Blobs".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Blob".equals(elementName.getLocalPart())) {
                            if (deserializedFilterBlobSegment.blobs == null) {
                                deserializedFilterBlobSegment.blobs = new ArrayList<FilterBlobItem>();
                            }
                            deserializedFilterBlobSegment.blobs.add(FilterBlobItem.fromXml(reader, "Blob"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobSegment.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFilterBlobSegment;
        });
    }
}

