/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.ratelimiter;

import java.time.InstantSource;

public class TokenBucket {
    private final double tokensPerMilli;
    private final long maxTokens;
    private final InstantSource instantSource;
    private long tokens;
    private long lastTokenGenerationMillis;

    public TokenBucket(long tokensPerSecond, long maxTokens, InstantSource instantSource) {
        this.tokensPerMilli = (double)tokensPerSecond / 1000.0;
        this.maxTokens = maxTokens;
        this.instantSource = instantSource;
        this.tokens = maxTokens;
        this.lastTokenGenerationMillis = instantSource.millis();
    }

    public synchronized boolean tryAcquire() {
        long t = this.instantSource.millis();
        long millisPassed = Math.subtractExact(t, this.lastTokenGenerationMillis);
        this.lastTokenGenerationMillis = t;
        this.tokens = Math.min(this.maxTokens, this.tokens + (long)((double)millisPassed * this.tokensPerMilli));
        if (this.tokens >= 1L) {
            --this.tokens;
            return true;
        }
        return false;
    }
}

