/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.SIL;
import com.github.benmanes.caffeine.cache.Ticker;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class SILR<K, V>
extends SIL<K, V> {
    static final LocalCacheFactory FACTORY = SILR::new;
    private static final VarHandle REFRESH_AFTER_WRITE_NANOS;
    final Ticker ticker;
    volatile long refreshAfterWriteNanos;

    SILR(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.setRefreshAfterWriteNanos(caffeine.getRefreshAfterWriteNanos());
    }

    @Override
    public Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected boolean refreshAfterWrite() {
        return true;
    }

    @Override
    protected long refreshAfterWriteNanos() {
        return REFRESH_AFTER_WRITE_NANOS.getAcquire(this);
    }

    @Override
    protected void setRefreshAfterWriteNanos(long l) {
        REFRESH_AFTER_WRITE_NANOS.setRelease(this, l);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            REFRESH_AFTER_WRITE_NANOS = lookup.findVarHandle(SILR.class, "refreshAfterWriteNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

