/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultValue {
    protected final Type type;

    public static DefaultValue functionCall(String name) {
        return new FunctionCall(Objects.requireNonNull(name, "name"));
    }

    public static DefaultValue constant(@Nullable Object value) {
        return new ConstantValue(value);
    }

    private DefaultValue(Type type) {
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public static void writeTo(@Nullable DefaultValue val, IgniteDataOutput out) throws IOException {
        if (val == null) {
            out.writeByte(-1);
        } else {
            out.writeByte(val.type.typeId);
            if (val instanceof ConstantValue) {
                ConstantValue constantValue = (ConstantValue)val;
                DefaultValue.writeValue(constantValue.columnType, constantValue.value, out);
            } else if (val instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)val;
                String functionName = functionCall.functionName();
                out.writeUTF(functionName);
            } else {
                throw new IllegalArgumentException("Unknown or unexpected type: " + String.valueOf(val));
            }
        }
    }

    @Nullable
    public static DefaultValue readFrom(IgniteDataInput in) throws IOException {
        byte typeId = in.readByte();
        if (typeId == -1) {
            return null;
        }
        if (typeId == Type.CONSTANT.typeId) {
            Object val = DefaultValue.readValue(in);
            return new ConstantValue(val);
        }
        if (typeId == Type.FUNCTION_CALL.typeId) {
            String functionName = in.readUTF();
            return new FunctionCall(functionName);
        }
        throw new IllegalArgumentException("Unexpected type: " + typeId);
    }

    private static void writeValue(ColumnType columnType, @Nullable Object value, IgniteDataOutput out) throws IOException {
        out.writeByte(columnType.id());
        if (value == null) {
            return;
        }
        switch (columnType) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                out.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case INT8: {
                out.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case INT16: {
                out.writeShort((int)((Short)value).shortValue());
                break;
            }
            case INT32: {
                out.writeInt(((Integer)value).intValue());
                break;
            }
            case INT64: {
                out.writeLong(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble(((Double)value).doubleValue());
                break;
            }
            case DECIMAL: {
                out.writeBigDecimal((BigDecimal)value);
                break;
            }
            case DATE: {
                out.writeLocalDate((LocalDate)value);
                break;
            }
            case TIME: {
                out.writeLocalTime((LocalTime)value);
                break;
            }
            case DATETIME: {
                out.writeLocalDateTime((LocalDateTime)value);
                break;
            }
            case TIMESTAMP: {
                out.writeInstant((Instant)value);
                break;
            }
            case UUID: {
                out.writeUuid((UUID)value);
                break;
            }
            case STRING: {
                out.writeUTF((String)value);
                break;
            }
            case BYTE_ARRAY: {
                byte[] bytes = (byte[])value;
                out.writeInt(bytes.length);
                out.writeByteArray((byte[])value);
                break;
            }
            case PERIOD: {
                out.writePeriod((Period)value);
                break;
            }
            case DURATION: {
                out.writeDuration((Duration)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected column type: " + String.valueOf(columnType));
            }
        }
    }

    @Nullable
    private static Object readValue(IgniteDataInput in) throws IOException {
        byte typeId = in.readByte();
        ColumnType columnType = ColumnType.getById((int)typeId);
        switch (columnType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return in.readBoolean();
            }
            case INT8: {
                return in.readByte();
            }
            case INT16: {
                return in.readShort();
            }
            case INT32: {
                return in.readInt();
            }
            case INT64: {
                return in.readLong();
            }
            case FLOAT: {
                return Float.valueOf(in.readFloat());
            }
            case DOUBLE: {
                return in.readDouble();
            }
            case DECIMAL: {
                return in.readBigDecimal();
            }
            case DATE: {
                return in.readLocalDate();
            }
            case TIME: {
                return in.readLocalTime();
            }
            case DATETIME: {
                return in.readLocalDateTime();
            }
            case TIMESTAMP: {
                return in.readInstant();
            }
            case UUID: {
                return in.readUuid();
            }
            case STRING: {
                return in.readUTF();
            }
            case BYTE_ARRAY: {
                int bytesLength = in.readInt();
                return in.readByteArray(bytesLength);
            }
            case PERIOD: {
                return in.readPeriod();
            }
            case DURATION: {
                return in.readDuration();
            }
        }
        throw new IllegalArgumentException("Unexpected column type: " + String.valueOf(columnType));
    }

    public static class FunctionCall
    extends DefaultValue {
        private final String functionName;

        private FunctionCall(String functionName) {
            super(Type.FUNCTION_CALL);
            this.functionName = functionName;
        }

        public String functionName() {
            return this.functionName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionCall that = (FunctionCall)o;
            return Objects.equals(this.functionName, that.functionName);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.functionName});
        }
    }

    public static class ConstantValue
    extends DefaultValue {
        private final ColumnType columnType;
        @Nullable
        private final Object value;

        private ConstantValue(@Nullable Object value) {
            super(Type.CONSTANT);
            NativeType type0 = NativeTypes.fromObject((Object)value);
            this.columnType = type0 == null ? ColumnType.NULL : type0.spec();
            this.value = value;
        }

        @Nullable
        public Object value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantValue that = (ConstantValue)o;
            return Objects.deepEquals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }

    public static enum Type {
        CONSTANT(0),
        FUNCTION_CALL(1);

        private static final int NULL_VALUE = -1;
        private final int typeId;

        private Type(int typeId) {
            this.typeId = typeId;
        }
    }
}

