/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.network.MulticastNodeFinder;
import org.apache.ignite.internal.network.NodeFinder;
import org.apache.ignite.internal.network.StaticNodeFinder;
import org.apache.ignite.internal.network.configuration.MulticastNodeFinderView;
import org.apache.ignite.internal.network.configuration.NodeFinderView;
import org.apache.ignite.internal.network.configuration.StaticNodeFinderView;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.NetworkAddress;

public class NodeFinderFactory {
    public static NodeFinder createNodeFinder(NodeFinderView nodeFinderConfiguration, String nodeName, InetSocketAddress localBindAddress) {
        switch (nodeFinderConfiguration.type()) {
            case "STATIC": {
                StaticNodeFinderView staticConfig = (StaticNodeFinderView)nodeFinderConfiguration;
                return Arrays.stream(staticConfig.netClusterNodes()).map(NetworkAddress::from).collect(Collectors.collectingAndThen(Collectors.toUnmodifiableList(), StaticNodeFinder::new));
            }
            case "MULTICAST": {
                MulticastNodeFinderView multicastConfig = (MulticastNodeFinderView)nodeFinderConfiguration;
                return new MulticastNodeFinder(multicastConfig.group(), multicastConfig.port(), multicastConfig.resultWaitTimeMillis(), multicastConfig.ttl(), nodeName, NodeFinderFactory.addressesToAdvertise(localBindAddress));
            }
        }
        throw new IllegalArgumentException("Unsupported NodeFinder type " + nodeFinderConfiguration.type());
    }

    private static Set<NetworkAddress> addressesToAdvertise(InetSocketAddress localBindAddress) {
        if (!localBindAddress.getAddress().isAnyLocalAddress()) {
            return Set.of(NetworkAddress.from((InetSocketAddress)localBindAddress));
        }
        try {
            return NetworkInterface.networkInterfaces().flatMap(NetworkInterface::inetAddresses).map(address -> new NetworkAddress(address.getHostName(), localBindAddress.getPort())).collect(Collectors.toUnmodifiableSet());
        }
        catch (SocketException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Cannot get local addresses", (Throwable)e);
        }
    }
}

