/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.cli;

public class EscapeCRLFHelper {
    private static final char CARRIAGE_RETURN = '\r';
    private static final char LINE_FEED = '\n';

    public static String escapeCRLF(String line) {
        StringBuilder sb = null;
        int lastNonCRLFIndex = 0;
        int index = 0;
        int length = line.length();
        while (index < length) {
            char ch = line.charAt(index);
            if (ch == '\r' || ch == '\n') {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (lastNonCRLFIndex < index) {
                    sb.append(line.substring(lastNonCRLFIndex, index));
                }
                lastNonCRLFIndex = ++index;
                if (ch == '\r') {
                    sb.append("\\r");
                    continue;
                }
                sb.append("\\n");
                continue;
            }
            ++index;
        }
        if (sb == null) {
            return line;
        }
        if (lastNonCRLFIndex < index) {
            sb.append(line.substring(lastNonCRLFIndex, index));
        }
        return sb.toString();
    }
}

