/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ClosedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClosedReaderTest {
    ClosedReaderTest() {
    }

    private void assertEof(Reader reader) throws IOException {
        Assertions.assertEquals((int)-1, (int)reader.read(), (String)"read()");
    }

    @Test
    void testRead() throws IOException {
        try (ClosedReader reader = new ClosedReader();){
            this.assertEof((Reader)reader);
        }
    }

    @Test
    void testReadArray() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((int)-1, (int)reader.read(new char[4096]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)0, (int)reader.read(new char[0]));
            Assertions.assertThrows(NullPointerException.class, () -> ClosedReaderTest.lambda$testReadArray$0((Reader)reader));
        }
    }

    @Test
    void testReadArrayIndex() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            char[] cbuf = new char[4096];
            Assertions.assertEquals((int)-1, (int)reader.read(cbuf, 0, 2048));
            Assertions.assertEquals((int)-1, (int)reader.read(cbuf, 2048, 2048));
            Assertions.assertEquals((int)0, (int)reader.read(cbuf, 4096, 0));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ClosedReaderTest.lambda$testReadArrayIndex$1((Reader)reader, cbuf));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ClosedReaderTest.lambda$testReadArrayIndex$2((Reader)reader, cbuf));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ClosedReaderTest.lambda$testReadArrayIndex$3((Reader)reader, cbuf));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)0, (int)reader.read(new char[0]));
            Assertions.assertThrows(NullPointerException.class, () -> ClosedReaderTest.lambda$testReadArrayIndex$4((Reader)reader));
        }
    }

    @Test
    void testReadCharBuffer() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            CharBuffer charBuffer = CharBuffer.wrap(new char[4096]);
            Assertions.assertEquals((int)-1, (int)reader.read(charBuffer));
            charBuffer.position(4096);
            Assertions.assertEquals((int)0, (int)reader.read(charBuffer));
            Assertions.assertEquals((int)-1, (int)reader.read(CharBuffer.wrap(new char[1])));
            Assertions.assertEquals((int)0, (int)reader.read(CharBuffer.wrap(new char[0])));
            Assertions.assertThrows(NullPointerException.class, () -> ClosedReaderTest.lambda$testReadCharBuffer$5((Reader)reader));
        }
    }

    @Test
    void testSingleton() throws Exception {
        try (ClosedReader reader = ClosedReader.CLOSED_READER;){
            this.assertEof((Reader)reader);
        }
        reader = ClosedReader.INSTANCE;
        try {
            this.assertEof((Reader)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    void testSkip() throws Exception {
        try (ClosedReader reader = new ClosedReader();){
            Assertions.assertEquals((long)0L, (long)reader.skip(4096L));
            Assertions.assertEquals((long)0L, (long)reader.skip(1L));
            Assertions.assertEquals((long)0L, (long)reader.skip(0L));
        }
    }

    private static /* synthetic */ void lambda$testReadCharBuffer$5(Reader reader) throws Throwable {
        reader.read((CharBuffer)null);
    }

    private static /* synthetic */ void lambda$testReadArrayIndex$4(Reader reader) throws Throwable {
        reader.read(null, 0, 0);
    }

    private static /* synthetic */ void lambda$testReadArrayIndex$3(Reader reader, char[] cbuf) throws Throwable {
        reader.read(cbuf, 1, -1);
    }

    private static /* synthetic */ void lambda$testReadArrayIndex$2(Reader reader, char[] cbuf) throws Throwable {
        reader.read(cbuf, 0, 4097);
    }

    private static /* synthetic */ void lambda$testReadArrayIndex$1(Reader reader, char[] cbuf) throws Throwable {
        reader.read(cbuf, -1, 1);
    }

    private static /* synthetic */ void lambda$testReadArray$0(Reader reader) throws Throwable {
        reader.read((char[])null);
    }
}

