/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.exp.path.CayennePath;

public class CayennePathSegment
implements CharSequence,
Serializable {
    private final String segment;
    private final boolean outer;

    CayennePathSegment(String segment, boolean outer) {
        this.segment = Objects.requireNonNull(segment, "Path segment can't be null");
        this.outer = outer;
    }

    public String value() {
        return this.segment;
    }

    public boolean isOuterJoin() {
        return this.outer;
    }

    public CayennePathSegment outer() {
        if (this.outer) {
            return this;
        }
        return CayennePath.segmentOf(this.segment, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CayennePathSegment that = (CayennePathSegment)o;
        if (this.outer != that.outer) {
            return false;
        }
        return this.segment.equals(that.segment);
    }

    public int hashCode() {
        int result = this.segment.hashCode();
        result = 31 * result + Boolean.hashCode(this.outer);
        return result;
    }

    @Override
    public String toString() {
        if (!this.outer) {
            return this.segment;
        }
        return this.segment + "+";
    }

    @Override
    public int length() {
        return this.segment.length();
    }

    @Override
    public char charAt(int index) {
        return this.segment.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CayennePathSegment(this.segment.substring(start, end), this.outer);
    }
}

