/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.client.kroviz.snapshots.demo2_0_0

import org.apache.causeway.client.kroviz.snapshots.Response

object HTTP_ERROR_500 : Response() {
    val invoke = "\$invoke"
    val invokeOnTarget = "\$invokeOnTarget"
    val preprocess = "\$preprocess"
    val doFilter = "\$doFilter"
    val ConnectionHandler = "\$ConnectionHandler"
    val SocketProcessor = "\$SocketProcessor"
    val Worker = "\$Worker"
    val WrappingRunnable = "\$WrappingRunnable"
    val Simple = "\$Simple"
    val CompositeTransducedAccessorImpl = "\$CompositeTransducedAccessorImpl"
    val DomainEventMemberExecutor = "\$DomainEventMemberExecutor"
    val BlobAdapter = "\$BlobAdapter"

    override val url = ""
    override val str = """{
    "httpStatusCode": 500,
    "message": "Error marshalling domain object to XML; domain object class is 'demoapp.dom.types.blob.BlobDemo'",
    "detail": {
        "className": "org.apache.causeway.applib.NonRecoverableException",
        "message": "Error marshalling domain object to XML; domain object class is 'demoapp.dom.types.blob.BlobDemo'",
        "element": [
            "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:212)",
            "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:157)",
            "org.apache.causeway.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation.clone(RecreatableObjectFacetForXmlRootElementAnnotation.java:67)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelElse(ActionInvocationFacetForDomainEventAbstract.java:300)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelCloneable(ActionInvocationFacetForDomainEventAbstract.java:286)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.access${'$'}500(ActionInvocationFacetForDomainEventAbstract.java:74)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:461)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:413)",
            "org.apache.causeway.applib.services.iactn.Interaction.executeInternal(Interaction.java:175)",
            "org.apache.causeway.applib.services.iactn.Interaction.execute(Interaction.java:141)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.doInvoke(ActionInvocationFacetForDomainEventAbstract.java:204)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.lambda$invoke${'$'}0(ActionInvocationFacetForDomainEventAbstract.java:125)",
            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:149)",
            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.invoke(ActionInvocationFacetForDomainEventAbstract.java:124)",
            "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.executeInternal(ObjectActionDefault.java:424)",
            "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.execute(ObjectActionDefault.java:410)",
            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeActionUsingAdapters(DomainResourceHelper.java:230)",
            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeAction(DomainResourceHelper.java:209)",
            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainObjectResourceServerside.invokeAction(DomainObjectResourceServerside.java:732)",
            "sun.reflect.GeneratedMethodAccessor366.invoke(Unknown Source)",
            "sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)",
            "java.lang.reflect.Method.invoke(Method.java:498)",
            "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:151)",
            "org.jboss.resteasy.core.MethodInjectorImpl.lambda$invoke${'$'}3(MethodInjectorImpl.java:122)",
            "java.util.concurrent.CompletableFuture.uniApply(CompletableFuture.java:602)",
            "java.util.concurrent.CompletableFuture.uniApplyStage(CompletableFuture.java:614)",
            "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:1983)",
            "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:110)",
            "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:122)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.internalInvokeOnTarget(ResourceMethodInvoker.java:594)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTargetAfterFilter(ResourceMethodInvoker.java:468)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invokeOnTarget${'$'}2(ResourceMethodInvoker.java:421)",
            "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTarget(ResourceMethodInvoker.java:423)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:391)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invoke${'$'}1(ResourceMethodInvoker.java:365)",
            "java.util.concurrent.CompletableFuture.uniComposeStage(CompletableFuture.java:981)",
            "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:2124)",
            "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:110)",
            "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:365)",
            "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:477)",
            "org.jboss.resteasy.core.SynchronousDispatcher.lambda$invoke${'$'}4(SynchronousDispatcher.java:252)",
            "org.jboss.resteasy.core.SynchronousDispatcher.lambda$preprocess${'$'}0(SynchronousDispatcher.java:153)",
            "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
            "org.jboss.resteasy.core.SynchronousDispatcher.preprocess(SynchronousDispatcher.java:156)",
            "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:238)",
            "org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher.service(ServletContainerDispatcher.java:249)",
            "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:60)",
            "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:55)",
            "javax.servlet.http.HttpServlet.service(HttpServlet.java:741)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:53)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.lambda$doFilter${'$'}0(CausewayTransactionFilterForRestfulObjects.java:48)",
            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring${'$'}1.doInTransactionWithoutResult(TransactionServiceSpring.java:113)",
            "org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:36)",
            "org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:140)",
            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinNewTransaction(TransactionServiceSpring.java:109)",
            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:140)",
            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.doFilter(CausewayTransactionFilterForRestfulObjects.java:45)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsSessionFilter.doFilter(CausewayRestfulObjectsSessionFilter.java:379)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.causeway.core.webapp.diagnostics.CausewayLogOnExceptionFilter.doFilter(CausewayLogOnExceptionFilter.java:59)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)",
            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)",
            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)",
            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.ebaysf.web.cors.CORSFilter.handleSimpleCORS(CORSFilter.java:302)",
            "org.ebaysf.web.cors.CORSFilter.doFilter(CORSFilter.java:164)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)",
            "org.apache.shiro.web.servlet.AbstractShiroFilter${'$'}1.call(AbstractShiroFilter.java:365)",
            "org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)",
            "org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)",
            "org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:387)",
            "org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)",
            "org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)",
            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
            "org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:202)",
            "org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)",
            "org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:526)",
            "org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:139)",
            "org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:92)",
            "org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:74)",
            "org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)",
            "org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:367)",
            "org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)",
            "org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:860)",
            "org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1591)",
            "org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)",
            "java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)",
            "java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)",
            "org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)",
            "java.lang.Thread.run(Thread.java:748)"
        ],
        "causedBy": {
            "className": "javax.xml.bind.MarshalException",
            "message": null,
            "element": [
                "com.sun.xml.bind.v2.runtime.MarshallerImpl.write(MarshallerImpl.java:301)",
                "com.sun.xml.bind.v2.runtime.MarshallerImpl.marshal(MarshallerImpl.java:226)",
                "javax.xml.bind.helpers.AbstractMarshallerImpl.marshal(AbstractMarshallerImpl.java:116)",
                "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:176)",
                "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:157)",
                "org.apache.causeway.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation.clone(RecreatableObjectFacetForXmlRootElementAnnotation.java:67)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelElse(ActionInvocationFacetForDomainEventAbstract.java:300)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelCloneable(ActionInvocationFacetForDomainEventAbstract.java:286)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.access${'$'}500(ActionInvocationFacetForDomainEventAbstract.java:74)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:461)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:413)",
                "org.apache.causeway.applib.services.iactn.Interaction.executeInternal(Interaction.java:175)",
                "org.apache.causeway.applib.services.iactn.Interaction.execute(Interaction.java:141)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.doInvoke(ActionInvocationFacetForDomainEventAbstract.java:204)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.lambda$invoke${'$'}0(ActionInvocationFacetForDomainEventAbstract.java:125)",
                "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:149)",
                "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.invoke(ActionInvocationFacetForDomainEventAbstract.java:124)",
                "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.executeInternal(ObjectActionDefault.java:424)",
                "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.execute(ObjectActionDefault.java:410)",
                "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeActionUsingAdapters(DomainResourceHelper.java:230)",
                "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeAction(DomainResourceHelper.java:209)",
                "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainObjectResourceServerside.invokeAction(DomainObjectResourceServerside.java:732)",
                "sun.reflect.GeneratedMethodAccessor366.invoke(Unknown Source)",
                "sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)",
                "java.lang.reflect.Method.invoke(Method.java:498)",
                "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:151)",
                "org.jboss.resteasy.core.MethodInjectorImpl.lambda$invoke${'$'}3(MethodInjectorImpl.java:122)",
                "java.util.concurrent.CompletableFuture.uniApply(CompletableFuture.java:602)",
                "java.util.concurrent.CompletableFuture.uniApplyStage(CompletableFuture.java:614)",
                "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:1983)",
                "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:110)",
                "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:122)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.internalInvokeOnTarget(ResourceMethodInvoker.java:594)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTargetAfterFilter(ResourceMethodInvoker.java:468)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invokeOnTarget${'$'}2(ResourceMethodInvoker.java:421)",
                "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTarget(ResourceMethodInvoker.java:423)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:391)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invoke${'$'}1(ResourceMethodInvoker.java:365)",
                "java.util.concurrent.CompletableFuture.uniComposeStage(CompletableFuture.java:981)",
                "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:2124)",
                "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:110)",
                "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:365)",
                "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:477)",
                "org.jboss.resteasy.core.SynchronousDispatcher.lambda$invoke${'$'}4(SynchronousDispatcher.java:252)",
                "org.jboss.resteasy.core.SynchronousDispatcher.lambda$preprocess${'$'}0(SynchronousDispatcher.java:153)",
                "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                "org.jboss.resteasy.core.SynchronousDispatcher.preprocess(SynchronousDispatcher.java:156)",
                "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:238)",
                "org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher.service(ServletContainerDispatcher.java:249)",
                "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:60)",
                "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:55)",
                "javax.servlet.http.HttpServlet.service(HttpServlet.java:741)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:53)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.lambda$doFilter${'$'}0(CausewayTransactionFilterForRestfulObjects.java:48)",
                "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring${'$'}1.doInTransactionWithoutResult(TransactionServiceSpring.java:113)",
                "org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:36)",
                "org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:140)",
                "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinNewTransaction(TransactionServiceSpring.java:109)",
                "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:140)",
                "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.doFilter(CausewayTransactionFilterForRestfulObjects.java:45)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsSessionFilter.doFilter(CausewayRestfulObjectsSessionFilter.java:379)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.causeway.core.webapp.diagnostics.CausewayLogOnExceptionFilter.doFilter(CausewayLogOnExceptionFilter.java:59)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)",
                "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)",
                "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)",
                "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.ebaysf.web.cors.CORSFilter.handleSimpleCORS(CORSFilter.java:302)",
                "org.ebaysf.web.cors.CORSFilter.doFilter(CORSFilter.java:164)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)",
                "org.apache.shiro.web.servlet.AbstractShiroFilter${'$'}1.call(AbstractShiroFilter.java:365)",
                "org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)",
                "org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)",
                "org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:387)",
                "org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)",
                "org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)",
                "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                "org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:202)",
                "org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)",
                "org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:526)",
                "org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:139)",
                "org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:92)",
                "org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:74)",
                "org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)",
                "org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:367)",
                "org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)",
                "org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:860)",
                "org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1591)",
                "org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)",
                "java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)",
                "java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)",
                "org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)",
                "java.lang.Thread.run(Thread.java:748)"
            ],
            "causedBy": {
                "className": "com.sun.istack.SAXException2",
                "message": "java.lang.NullPointerException",
                "element": [
                    "com.sun.xml.bind.v2.runtime.XMLSerializer.reportError(XMLSerializer.java:217)",
                    "com.sun.xml.bind.v2.runtime.XMLSerializer.reportError(XMLSerializer.java:232)",
                    "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeBody(ClassBeanInfoImpl.java:340)",
                    "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsSoleContent(XMLSerializer.java:563)",
                    "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeRoot(ClassBeanInfoImpl.java:311)",
                    "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsRoot(XMLSerializer.java:464)",
                    "com.sun.xml.bind.v2.runtime.MarshallerImpl.write(MarshallerImpl.java:298)",
                    "com.sun.xml.bind.v2.runtime.MarshallerImpl.marshal(MarshallerImpl.java:226)",
                    "javax.xml.bind.helpers.AbstractMarshallerImpl.marshal(AbstractMarshallerImpl.java:116)",
                    "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:176)",
                    "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:157)",
                    "org.apache.causeway.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation.clone(RecreatableObjectFacetForXmlRootElementAnnotation.java:67)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelElse(ActionInvocationFacetForDomainEventAbstract.java:300)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelCloneable(ActionInvocationFacetForDomainEventAbstract.java:286)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.access${'$'}500(ActionInvocationFacetForDomainEventAbstract.java:74)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:461)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:413)",
                    "org.apache.causeway.applib.services.iactn.Interaction.executeInternal(Interaction.java:175)",
                    "org.apache.causeway.applib.services.iactn.Interaction.execute(Interaction.java:141)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.doInvoke(ActionInvocationFacetForDomainEventAbstract.java:204)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.lambda$invoke${'$'}0(ActionInvocationFacetForDomainEventAbstract.java:125)",
                    "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:149)",
                    "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.invoke(ActionInvocationFacetForDomainEventAbstract.java:124)",
                    "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.executeInternal(ObjectActionDefault.java:424)",
                    "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.execute(ObjectActionDefault.java:410)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeActionUsingAdapters(DomainResourceHelper.java:230)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeAction(DomainResourceHelper.java:209)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainObjectResourceServerside.invokeAction(DomainObjectResourceServerside.java:732)",
                    "sun.reflect.GeneratedMethodAccessor366.invoke(Unknown Source)",
                    "sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)",
                    "java.lang.reflect.Method.invoke(Method.java:498)",
                    "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:151)",
                    "org.jboss.resteasy.core.MethodInjectorImpl.lambda$invoke${'$'}3(MethodInjectorImpl.java:122)",
                    "java.util.concurrent.CompletableFuture.uniApply(CompletableFuture.java:602)",
                    "java.util.concurrent.CompletableFuture.uniApplyStage(CompletableFuture.java:614)",
                    "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:1983)",
                    "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:110)",
                    "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:122)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.internalInvokeOnTarget(ResourceMethodInvoker.java:594)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTargetAfterFilter(ResourceMethodInvoker.java:468)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invokeOnTarget${'$'}2(ResourceMethodInvoker.java:421)",
                    "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTarget(ResourceMethodInvoker.java:423)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:391)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invoke${'$'}1(ResourceMethodInvoker.java:365)",
                    "java.util.concurrent.CompletableFuture.uniComposeStage(CompletableFuture.java:981)",
                    "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:2124)",
                    "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:110)",
                    "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:365)",
                    "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:477)",
                    "org.jboss.resteasy.core.SynchronousDispatcher.lambda$invoke${'$'}4(SynchronousDispatcher.java:252)",
                    "org.jboss.resteasy.core.SynchronousDispatcher.lambda$preprocess${'$'}0(SynchronousDispatcher.java:153)",
                    "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                    "org.jboss.resteasy.core.SynchronousDispatcher.preprocess(SynchronousDispatcher.java:156)",
                    "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:238)",
                    "org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher.service(ServletContainerDispatcher.java:249)",
                    "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:60)",
                    "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:55)",
                    "javax.servlet.http.HttpServlet.service(HttpServlet.java:741)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:53)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.lambda$doFilter${'$'}0(CausewayTransactionFilterForRestfulObjects.java:48)",
                    "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring${'$'}1.doInTransactionWithoutResult(TransactionServiceSpring.java:113)",
                    "org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:36)",
                    "org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:140)",
                    "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinNewTransaction(TransactionServiceSpring.java:109)",
                    "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:140)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.doFilter(CausewayTransactionFilterForRestfulObjects.java:45)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsSessionFilter.doFilter(CausewayRestfulObjectsSessionFilter.java:379)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.causeway.core.webapp.diagnostics.CausewayLogOnExceptionFilter.doFilter(CausewayLogOnExceptionFilter.java:59)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)",
                    "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)",
                    "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)",
                    "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.ebaysf.web.cors.CORSFilter.handleSimpleCORS(CORSFilter.java:302)",
                    "org.ebaysf.web.cors.CORSFilter.doFilter(CORSFilter.java:164)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)",
                    "org.apache.shiro.web.servlet.AbstractShiroFilter${'$'}1.call(AbstractShiroFilter.java:365)",
                    "org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)",
                    "org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)",
                    "org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:387)",
                    "org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)",
                    "org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)",
                    "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                    "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                    "org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:202)",
                    "org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)",
                    "org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:526)",
                    "org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:139)",
                    "org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:92)",
                    "org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:74)",
                    "org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)",
                    "org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:367)",
                    "org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)",
                    "org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:860)",
                    "org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1591)",
                    "org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)",
                    "java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)",
                    "java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)",
                    "org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)",
                    "java.lang.Thread.run(Thread.java:748)"
                ],
                "causedBy": {
                    "className": "com.sun.xml.bind.api.AccessorException",
                    "message": "java.lang.NullPointerException",
                    "element": [
                        "com.sun.xml.bind.v2.runtime.reflect.AdaptedAccessor.get(AdaptedAccessor.java:48)",
                        "com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor$CompositeTransducedAccessorImpl.writeLeafElement(TransducedAccessor.java:218)",
                        "com.sun.xml.bind.v2.runtime.property.SingleElementLeafProperty.serializeBody(SingleElementLeafProperty.java:100)",
                        "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeBody(ClassBeanInfoImpl.java:330)",
                        "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsSoleContent(XMLSerializer.java:563)",
                        "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeRoot(ClassBeanInfoImpl.java:311)",
                        "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsRoot(XMLSerializer.java:464)",
                        "com.sun.xml.bind.v2.runtime.MarshallerImpl.write(MarshallerImpl.java:298)",
                        "com.sun.xml.bind.v2.runtime.MarshallerImpl.marshal(MarshallerImpl.java:226)",
                        "javax.xml.bind.helpers.AbstractMarshallerImpl.marshal(AbstractMarshallerImpl.java:116)",
                        "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:176)",
                        "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:157)",
                        "org.apache.causeway.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation.clone(RecreatableObjectFacetForXmlRootElementAnnotation.java:67)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelElse(ActionInvocationFacetForDomainEventAbstract.java:300)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelCloneable(ActionInvocationFacetForDomainEventAbstract.java:286)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.access${'$'}500(ActionInvocationFacetForDomainEventAbstract.java:74)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:461)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:413)",
                        "org.apache.causeway.applib.services.iactn.Interaction.executeInternal(Interaction.java:175)",
                        "org.apache.causeway.applib.services.iactn.Interaction.execute(Interaction.java:141)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.doInvoke(ActionInvocationFacetForDomainEventAbstract.java:204)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.lambda$invoke${'$'}0(ActionInvocationFacetForDomainEventAbstract.java:125)",
                        "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:149)",
                        "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.invoke(ActionInvocationFacetForDomainEventAbstract.java:124)",
                        "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.executeInternal(ObjectActionDefault.java:424)",
                        "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.execute(ObjectActionDefault.java:410)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeActionUsingAdapters(DomainResourceHelper.java:230)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeAction(DomainResourceHelper.java:209)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainObjectResourceServerside.invokeAction(DomainObjectResourceServerside.java:732)",
                        "sun.reflect.GeneratedMethodAccessor366.invoke(Unknown Source)",
                        "sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)",
                        "java.lang.reflect.Method.invoke(Method.java:498)",
                        "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:151)",
                        "org.jboss.resteasy.core.MethodInjectorImpl.lambda$invoke${'$'}3(MethodInjectorImpl.java:122)",
                        "java.util.concurrent.CompletableFuture.uniApply(CompletableFuture.java:602)",
                        "java.util.concurrent.CompletableFuture.uniApplyStage(CompletableFuture.java:614)",
                        "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:1983)",
                        "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:110)",
                        "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:122)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.internalInvokeOnTarget(ResourceMethodInvoker.java:594)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTargetAfterFilter(ResourceMethodInvoker.java:468)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invokeOnTarget${'$'}2(ResourceMethodInvoker.java:421)",
                        "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTarget(ResourceMethodInvoker.java:423)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:391)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invoke${'$'}1(ResourceMethodInvoker.java:365)",
                        "java.util.concurrent.CompletableFuture.uniComposeStage(CompletableFuture.java:981)",
                        "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:2124)",
                        "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:110)",
                        "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:365)",
                        "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:477)",
                        "org.jboss.resteasy.core.SynchronousDispatcher.lambda$invoke${'$'}4(SynchronousDispatcher.java:252)",
                        "org.jboss.resteasy.core.SynchronousDispatcher.lambda$preprocess${'$'}0(SynchronousDispatcher.java:153)",
                        "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                        "org.jboss.resteasy.core.SynchronousDispatcher.preprocess(SynchronousDispatcher.java:156)",
                        "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:238)",
                        "org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher.service(ServletContainerDispatcher.java:249)",
                        "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:60)",
                        "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:55)",
                        "javax.servlet.http.HttpServlet.service(HttpServlet.java:741)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:53)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.lambda$doFilter${'$'}0(CausewayTransactionFilterForRestfulObjects.java:48)",
                        "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring${'$'}1.doInTransactionWithoutResult(TransactionServiceSpring.java:113)",
                        "org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:36)",
                        "org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:140)",
                        "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinNewTransaction(TransactionServiceSpring.java:109)",
                        "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:140)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.doFilter(CausewayTransactionFilterForRestfulObjects.java:45)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsSessionFilter.doFilter(CausewayRestfulObjectsSessionFilter.java:379)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.causeway.core.webapp.diagnostics.CausewayLogOnExceptionFilter.doFilter(CausewayLogOnExceptionFilter.java:59)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)",
                        "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)",
                        "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)",
                        "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.ebaysf.web.cors.CORSFilter.handleSimpleCORS(CORSFilter.java:302)",
                        "org.ebaysf.web.cors.CORSFilter.doFilter(CORSFilter.java:164)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)",
                        "org.apache.shiro.web.servlet.AbstractShiroFilter${'$'}1.call(AbstractShiroFilter.java:365)",
                        "org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)",
                        "org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)",
                        "org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:387)",
                        "org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)",
                        "org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)",
                        "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                        "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                        "org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:202)",
                        "org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)",
                        "org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:526)",
                        "org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:139)",
                        "org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:92)",
                        "org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:74)",
                        "org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)",
                        "org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:367)",
                        "org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)",
                        "org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:860)",
                        "org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1591)",
                        "org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)",
                        "java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)",
                        "java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)",
                        "org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)",
                        "java.lang.Thread.run(Thread.java:748)"
                    ],
                    "causedBy": {
                        "className": "java.lang.NullPointerException",
                        "message": null,
                        "element": [
                            "demoapp.dom.types.blob.DemoBlobStore$BlobAdapter.put(DemoBlobStore.java:62)",
                            "demoapp.dom.types.blob.DemoBlobStore$BlobAdapter.marshal(DemoBlobStore.java:54)",
                            "demoapp.dom.types.blob.DemoBlobStore$BlobAdapter.marshal(DemoBlobStore.java:37)",
                            "com.sun.xml.bind.v2.runtime.reflect.AdaptedAccessor.get(AdaptedAccessor.java:46)",
                            "com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor$CompositeTransducedAccessorImpl.writeLeafElement(TransducedAccessor.java:218)",
                            "com.sun.xml.bind.v2.runtime.property.SingleElementLeafProperty.serializeBody(SingleElementLeafProperty.java:100)",
                            "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeBody(ClassBeanInfoImpl.java:330)",
                            "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsSoleContent(XMLSerializer.java:563)",
                            "com.sun.xml.bind.v2.runtime.ClassBeanInfoImpl.serializeRoot(ClassBeanInfoImpl.java:311)",
                            "com.sun.xml.bind.v2.runtime.XMLSerializer.childAsRoot(XMLSerializer.java:464)",
                            "com.sun.xml.bind.v2.runtime.MarshallerImpl.write(MarshallerImpl.java:298)",
                            "com.sun.xml.bind.v2.runtime.MarshallerImpl.marshal(MarshallerImpl.java:226)",
                            "javax.xml.bind.helpers.AbstractMarshallerImpl.marshal(AbstractMarshallerImpl.java:116)",
                            "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:176)",
                            "org.apache.causeway.applib.services.jaxb.JaxbService$Simple.toXml(JaxbService.java:157)",
                            "org.apache.causeway.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation.clone(RecreatableObjectFacetForXmlRootElementAnnotation.java:67)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelElse(ActionInvocationFacetForDomainEventAbstract.java:300)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.cloneIfViewModelCloneable(ActionInvocationFacetForDomainEventAbstract.java:286)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.access${'$'}500(ActionInvocationFacetForDomainEventAbstract.java:74)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:461)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract$DomainEventMemberExecutor.execute(ActionInvocationFacetForDomainEventAbstract.java:413)",
                            "org.apache.causeway.applib.services.iactn.Interaction.executeInternal(Interaction.java:175)",
                            "org.apache.causeway.applib.services.iactn.Interaction.execute(Interaction.java:141)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.doInvoke(ActionInvocationFacetForDomainEventAbstract.java:204)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.lambda$invoke${'$'}0(ActionInvocationFacetForDomainEventAbstract.java:125)",
                            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:149)",
                            "org.apache.causeway.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract.invoke(ActionInvocationFacetForDomainEventAbstract.java:124)",
                            "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.executeInternal(ObjectActionDefault.java:424)",
                            "org.apache.causeway.core.metamodel.specloader.specimpl.ObjectActionDefault.execute(ObjectActionDefault.java:410)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeActionUsingAdapters(DomainResourceHelper.java:230)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainResourceHelper.invokeAction(DomainResourceHelper.java:209)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.resources.DomainObjectResourceServerside.invokeAction(DomainObjectResourceServerside.java:732)",
                            "sun.reflect.GeneratedMethodAccessor366.invoke(Unknown Source)",
                            "sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)",
                            "java.lang.reflect.Method.invoke(Method.java:498)",
                            "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:151)",
                            "org.jboss.resteasy.core.MethodInjectorImpl.lambda$invoke${'$'}3(MethodInjectorImpl.java:122)",
                            "java.util.concurrent.CompletableFuture.uniApply(CompletableFuture.java:602)",
                            "java.util.concurrent.CompletableFuture.uniApplyStage(CompletableFuture.java:614)",
                            "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:1983)",
                            "java.util.concurrent.CompletableFuture.thenApply(CompletableFuture.java:110)",
                            "org.jboss.resteasy.core.MethodInjectorImpl.invoke(MethodInjectorImpl.java:122)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.internalInvokeOnTarget(ResourceMethodInvoker.java:594)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTargetAfterFilter(ResourceMethodInvoker.java:468)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invokeOnTarget${'$'}2(ResourceMethodInvoker.java:421)",
                            "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.invokeOnTarget(ResourceMethodInvoker.java:423)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:391)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.lambda$invoke${'$'}1(ResourceMethodInvoker.java:365)",
                            "java.util.concurrent.CompletableFuture.uniComposeStage(CompletableFuture.java:981)",
                            "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:2124)",
                            "java.util.concurrent.CompletableFuture.thenCompose(CompletableFuture.java:110)",
                            "org.jboss.resteasy.core.ResourceMethodInvoker.invoke(ResourceMethodInvoker.java:365)",
                            "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:477)",
                            "org.jboss.resteasy.core.SynchronousDispatcher.lambda$invoke${'$'}4(SynchronousDispatcher.java:252)",
                            "org.jboss.resteasy.core.SynchronousDispatcher.lambda$preprocess${'$'}0(SynchronousDispatcher.java:153)",
                            "org.jboss.resteasy.core.interception.jaxrs.PreMatchContainerRequestContext.filter(PreMatchContainerRequestContext.java:363)",
                            "org.jboss.resteasy.core.SynchronousDispatcher.preprocess(SynchronousDispatcher.java:156)",
                            "org.jboss.resteasy.core.SynchronousDispatcher.invoke(SynchronousDispatcher.java:238)",
                            "org.jboss.resteasy.plugins.server.servlet.ServletContainerDispatcher.service(ServletContainerDispatcher.java:249)",
                            "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:60)",
                            "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher.service(HttpServletDispatcher.java:55)",
                            "javax.servlet.http.HttpServlet.service(HttpServlet.java:741)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:53)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.lambda$doFilter${'$'}0(CausewayTransactionFilterForRestfulObjects.java:48)",
                            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring${'$'}1.doInTransactionWithoutResult(TransactionServiceSpring.java:113)",
                            "org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:36)",
                            "org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:140)",
                            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinNewTransaction(TransactionServiceSpring.java:109)",
                            "org.apache.causeway.core.runtimeservices.xactn.TransactionServiceSpring.executeWithinTransaction(TransactionServiceSpring.java:140)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayTransactionFilterForRestfulObjects.doFilter(CausewayTransactionFilterForRestfulObjects.java:45)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.causeway.viewer.restfulobjects.viewer.webmodule.CausewayRestfulObjectsSessionFilter.doFilter(CausewayRestfulObjectsSessionFilter.java:379)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.causeway.core.webapp.diagnostics.CausewayLogOnExceptionFilter.doFilter(CausewayLogOnExceptionFilter.java:59)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.springframework.web.filter.RequestContextFilter.doFilterInternal(RequestContextFilter.java:100)",
                            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.springframework.web.filter.FormContentFilter.doFilterInternal(FormContentFilter.java:93)",
                            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:201)",
                            "org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:119)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.ebaysf.web.cors.CORSFilter.handleSimpleCORS(CORSFilter.java:302)",
                            "org.ebaysf.web.cors.CORSFilter.doFilter(CORSFilter.java:164)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)",
                            "org.apache.shiro.web.servlet.AbstractShiroFilter${'$'}1.call(AbstractShiroFilter.java:365)",
                            "org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)",
                            "org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)",
                            "org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:387)",
                            "org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)",
                            "org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)",
                            "org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)",
                            "org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)",
                            "org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:202)",
                            "org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:96)",
                            "org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:526)",
                            "org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:139)",
                            "org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:92)",
                            "org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:74)",
                            "org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)",
                            "org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:367)",
                            "org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)",
                            "org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:860)",
                            "org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1591)",
                            "org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)",
                            "java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)",
                            "java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)",
                            "org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)",
                            "java.lang.Thread.run(Thread.java:748)"
                        ],
                        "causedBy": null
                    }
                }
            }
        }
    }
}
"""
}
