/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.Serializable;
import java.util.Map;

public class UIViewAction
extends UIComponentBase
implements ActionSource2 {
    public static final String COMPONENT_TYPE = "jakarta.faces.ViewAction";
    public static final String COMPONENT_FAMILY = "jakarta.faces.ViewAction";
    private static final String UIVIEWACTION_BROADCAST = "jakarta.faces.ViewAction.broadcast";
    private static final String UIVIEWACTION_EVENT_COUNT = "jakarta.faces.ViewAction.eventCount";

    public UIViewAction() {
        this.setRendererType(null);
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.ViewAction";
    }

    private void incrementEventCount(FacesContext context) {
        Map<Object, Object> attrs = context.getAttributes();
        Integer count = (Integer)attrs.get(UIVIEWACTION_EVENT_COUNT);
        if (null == count) {
            attrs.put(UIVIEWACTION_EVENT_COUNT, 1);
        } else {
            attrs.put(UIVIEWACTION_EVENT_COUNT, count + 1);
        }
    }

    private boolean decrementEventCountAndReturnTrueIfZero(FacesContext context) {
        boolean result = true;
        Map<Object, Object> attrs = context.getAttributes();
        Integer count = (Integer)attrs.get(UIVIEWACTION_EVENT_COUNT);
        if (null != count) {
            if ((count = Integer.valueOf(count - 1)) < 1) {
                attrs.remove(UIVIEWACTION_EVENT_COUNT);
                result = true;
            } else {
                attrs.put(UIVIEWACTION_EVENT_COUNT, count);
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    public String getPhase() {
        PhaseId myPhaseId = this.getPhaseId();
        String result = null;
        if (null != myPhaseId) {
            result = myPhaseId.getName();
        }
        return result;
    }

    public void setPhase(String phase) {
        PhaseId myPhaseId = PhaseId.phaseIdValueOf(phase);
        if (PhaseId.ANY_PHASE.equals(myPhaseId) || PhaseId.RESTORE_VIEW.equals(myPhaseId) || PhaseId.RENDER_RESPONSE.equals(myPhaseId)) {
            throw new FacesException("View actions cannot be executed in specified phase: [" + myPhaseId.toString() + "]");
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.phase), myPhaseId.getName());
    }

    private void setIsProcessingUIViewActionBroadcast(FacesContext context, boolean value) {
        Map<Object, Object> attrs = context.getAttributes();
        if (value) {
            attrs.put(UIVIEWACTION_BROADCAST, Boolean.TRUE);
        } else {
            attrs.remove(UIVIEWACTION_BROADCAST);
        }
    }

    public static boolean isProcessingBroadcast(FacesContext context) {
        boolean result = context.getAttributes().containsKey(UIVIEWACTION_BROADCAST);
        return result;
    }

    private PhaseId getPhaseId() {
        PhaseId myPhaseId = null;
        String phaseIdString = (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.phase));
        if (phaseIdString != null) {
            myPhaseId = PhaseId.phaseIdValueOf(phaseIdString);
        }
        return myPhaseId;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        ActionListener[] al = (ActionListener[])this.getFacesListeners(ActionListener.class);
        return al;
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public MethodExpression getActionExpression() {
        return (MethodExpression)this.getStateHelper().get((Serializable)((Object)PropertyKeys.actionExpression));
    }

    @Override
    public void setActionExpression(MethodExpression actionExpression) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionExpression), actionExpression);
    }

    public boolean isOnPostback() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onPostback), false);
    }

    public void setOnPostback(boolean onPostback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onPostback), onPostback);
    }

    @Override
    public boolean isRendered() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.renderedAttr), true);
    }

    @Override
    public void setRendered(boolean condition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.renderedAttr), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        ActionListener listener;
        super.broadcast(event);
        FacesContext context = event.getFacesContext();
        if (!(event instanceof ActionEvent)) {
            throw new IllegalArgumentException();
        }
        if (!context.getResponseComplete() && context.getViewRoot() == this.getViewRootOf(event) && (listener = context.getApplication().getActionListener()) != null) {
            boolean hasMoreViewActionEvents = false;
            UIViewRoot viewRootBefore = context.getViewRoot();
            assert (null != viewRootBefore);
            InstrumentedFacesContext instrumentedContext = null;
            try {
                instrumentedContext = new InstrumentedFacesContext(context);
                this.setIsProcessingUIViewActionBroadcast(context, true);
                instrumentedContext.disableRenderResponseControl().set();
                listener.processAction((ActionEvent)event);
                hasMoreViewActionEvents = !this.decrementEventCountAndReturnTrueIfZero(context);
            }
            finally {
                this.setIsProcessingUIViewActionBroadcast(context, false);
                if (null != instrumentedContext) {
                    instrumentedContext.restore();
                }
            }
            if (!context.getResponseComplete()) {
                UIViewRoot viewRootAfter = context.getViewRoot();
                assert (null != viewRootAfter);
                String viewIdBefore = viewRootBefore.getViewId();
                String viewIdAfter = viewRootAfter.getViewId();
                assert (null != viewIdBefore && null != viewIdAfter);
                boolean viewIdsSame = viewIdBefore.equals(viewIdAfter);
                if (viewIdsSame && !hasMoreViewActionEvents) {
                    context.renderResponse();
                }
            }
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (context.isPostback() && !this.isOnPostback() || !this.isRendered()) {
            return;
        }
        ActionEvent e = new ActionEvent(context, this);
        PhaseId phaseId = this.getPhaseId();
        if (phaseId != null) {
            e.setPhaseId(phaseId);
        } else if (this.isImmediate()) {
            e.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            e.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
        this.incrementEventCount(context);
        this.queueEvent(e);
    }

    private UIViewRoot getViewRootOf(FacesEvent e) {
        UIComponent c = e.getComponent();
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        return null;
    }

    private class InstrumentedFacesContext
    extends FacesContextWrapper {
        private boolean viewRootCleared;
        private boolean renderedResponseControlDisabled;
        private Boolean postback;

        public InstrumentedFacesContext(FacesContext wrapped) {
            super(wrapped);
            this.viewRootCleared = false;
            this.renderedResponseControlDisabled = false;
            this.postback = null;
        }

        @Override
        public UIViewRoot getViewRoot() {
            if (this.viewRootCleared) {
                return null;
            }
            return super.getViewRoot();
        }

        @Override
        public void setViewRoot(UIViewRoot viewRoot) {
            this.viewRootCleared = false;
            super.setViewRoot(viewRoot);
        }

        @Override
        public boolean isPostback() {
            return this.postback == null ? super.isPostback() : this.postback.booleanValue();
        }

        @Override
        public void renderResponse() {
            if (!this.renderedResponseControlDisabled) {
                super.renderResponse();
            }
        }

        public InstrumentedFacesContext pushViewIntoRequestMap() {
            this.getExternalContext().getRequestMap().put("jakarta.servlet.include.servlet_path", super.getViewRoot().getViewId());
            return this;
        }

        public InstrumentedFacesContext clearPostback() {
            this.postback = false;
            return this;
        }

        public InstrumentedFacesContext clearViewRoot() {
            this.viewRootCleared = true;
            return this;
        }

        public InstrumentedFacesContext disableRenderResponseControl() {
            this.renderedResponseControlDisabled = true;
            return this;
        }

        public void set() {
            InstrumentedFacesContext.setCurrentInstance(this);
        }

        public void restore() {
            InstrumentedFacesContext.setCurrentInstance(this.getWrapped());
        }
    }

    static enum PropertyKeys {
        onPostback,
        actionExpression,
        immediate,
        phase,
        renderedAttr("if");

        private String name;

        private PropertyKeys() {
        }

        private PropertyKeys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name != null ? this.name : super.toString();
        }
    }
}

