/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class CLALibUnary {
    private static final Log LOG = LogFactory.getLog((String)CLALibUnary.class.getName());

    public static MatrixBlock unaryOperations(CompressedMatrixBlock m, UnaryOperator op, MatrixValue result) {
        boolean overlapping = m.isOverlapping();
        int r = m.getNumRows();
        int c = m.getNumColumns();
        if (m.isEmpty()) {
            return new MatrixBlock(r, c, 0L).unaryOperations(op, result);
        }
        if (overlapping ? Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISINF, Builtin.BuiltinCode.ISNA, Builtin.BuiltinCode.ISNAN) : Builtin.isBuiltinCode(op.fn, Builtin.BuiltinCode.ISINF, Builtin.BuiltinCode.ISNAN, Builtin.BuiltinCode.ISNA) && !m.containsValue(op.getPattern())) {
            return new MatrixBlock(r, c, 0L);
        }
        if (op.isInplace()) {
            LOG.warn((Object)"Compressed ops forcing unaryOperator not to be inplace.");
            op = new UnaryOperator(op.fn, op.getNumThreads(), false);
        }
        MatrixBlock ret = m.getUncompressed("unaryOperations " + op.fn.toString()).unaryOperations(op, result);
        return ret;
    }
}

