/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.transport.passthru.util.RelayConstants;
import org.apache.synapse.transport.passthru.util.StreamingOnRequestDataSource;

public class BinaryRelayBuilder
implements Builder {
    public static byte[] readAllFromInputSteam(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read = in.read(buf);
        while (read != -1) {
            out.write(buf, 0, read);
            read = in.read(buf);
        }
        return out.toByteArray();
    }

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        try {
            messageContext.setProperty("ContentType", (Object)contentType);
            SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
            SOAPEnvelope env = factory.getDefaultEnvelope();
            if (inputStream != null) {
                OMNamespace ns = factory.createOMNamespace(RelayConstants.BINARY_CONTENT_QNAME.getNamespaceURI(), "ns");
                OMElement omEle = factory.createOMElement(RelayConstants.BINARY_CONTENT_QNAME.getLocalPart(), ns);
                StreamingOnRequestDataSource ds = new StreamingOnRequestDataSource(inputStream);
                DataHandler dataHandler = new DataHandler((DataSource)ds);
                OMText textData = factory.createOMText((Object)dataHandler, true);
                omEle.addChild((OMNode)textData);
                env.getBody().addChild((OMNode)omEle);
            }
            return env;
        }
        catch (SOAPProcessingException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (OMException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

