/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.jcr.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.UpdateResult;
import org.apache.sling.installer.api.serializer.ConfigurationSerializer;
import org.apache.sling.installer.api.serializer.ConfigurationSerializerFactory;
import org.apache.sling.installer.provider.jcr.impl.InstallerConfig;
import org.apache.sling.installer.provider.jcr.impl.JcrUtil;
import org.apache.sling.installer.provider.jcr.impl.RescanTimer;
import org.apache.sling.installer.provider.jcr.impl.RootFolderListener;
import org.apache.sling.installer.provider.jcr.impl.RootFolderMoveListener;
import org.apache.sling.installer.provider.jcr.impl.WatchedFolder;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={UpdateHandler.class}, property={"service.ranking:Integer=100"})
@Designate(ocd=Configuration.class)
public class JcrInstaller
implements UpdateHandler {
    public static final long RUN_LOOP_DELAY_MSEC = 500L;
    public static final String URL_SCHEME = "jcrinstall";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicLongArray counters = new AtomicLongArray(3);
    public static final int SCAN_FOLDERS_COUNTER = 0;
    public static final int UPDATE_FOLDERS_LIST_COUNTER = 1;
    public static final int RUN_LOOP_COUNTER = 2;
    public static final int COUNTERS_COUNT = 3;
    private static final String NT_FILE = "nt:file";
    private static final String NT_RESOURCE = "nt:resource";
    private static final String PROP_DATA = "jcr:data";
    private static final String PROP_MODIFIED = "jcr:lastModified";
    private static final String PROP_ENC = "jcr:encoding";
    private static final String PROP_MIME = "jcr:mimeType";
    private static final String MIME_TXT = "text/plain";
    private static final String ENCODING = "UTF-8";
    private static final String CONFIG_FILE_EXTENSION = ".cfg.json";
    private volatile boolean pauseMessageLogged = false;
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settings;
    @Reference
    private OsgiInstaller installer;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    private final RescanTimer updateFoldersListTimer = new RescanTimer();
    private static final AtomicInteger bgThreadCounter = new AtomicInteger();
    private volatile StoppableThread backgroundThread;

    @Activate
    protected void activate(Configuration configuration) throws RepositoryException {
        this.logger.info("Activating Apache Sling JCR Installer");
        InstallerConfig cfg = new InstallerConfig(this.logger, configuration, this.settings);
        this.backgroundThread = new StoppableThread(cfg);
        this.backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        this.logger.info("Deactivating Apache Sling JCR Installer");
        if (this.backgroundThread != null) {
            Object object = this.backgroundThread.lock;
            synchronized (object) {
                this.backgroundThread.active.set(false);
                this.backgroundThread.lock.notify();
            }
            this.logger.debug("Waiting for " + this.backgroundThread.getName() + " Thread to end...");
            this.backgroundThread.shutdown();
            this.backgroundThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPathsToWatch(InstallerConfig cfg, Session session, String rootPath) throws RepositoryException {
        Session s = null;
        try {
            s = this.repository.loginService(null, this.repository.getDefaultWorkspace());
            if (!s.itemExists(rootPath) || !s.getItem(rootPath).isNode()) {
                this.logger.info("Bundles root node {} not found, ignored", (Object)rootPath);
            } else {
                this.logger.debug("Bundles root node {} found, looking for bundle folders inside it", (Object)rootPath);
                Node n = (Node)s.getItem(rootPath);
                this.findPathsUnderNode(cfg, session, n);
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    void findPathsUnderNode(InstallerConfig cfg, Session session, Node n) throws RepositoryException {
        int depth;
        String path = n.getPath();
        int priority = cfg.getFolderNameFilter().getPriority(path);
        if (priority > 0) {
            cfg.addWatchedFolder(new WatchedFolder(session, path, priority, cfg.getConverters()));
        }
        if ((depth = path.split("/").length) > cfg.getMaxWatchedFolderDepth()) {
            this.logger.debug("Not recursing into {} due to maxWatchedFolderDepth={}", (Object)path, (Object)cfg.getMaxWatchedFolderDepth());
            return;
        }
        NodeIterator it = n.getNodes();
        while (it.hasNext()) {
            this.findPathsUnderNode(cfg, session, it.nextNode());
        }
    }

    private List<String> updateFoldersList(InstallerConfig cfg, Session session) throws Exception {
        this.logger.debug("Updating folder list.");
        for (String root : cfg.getRoots()) {
            this.findPathsToWatch(cfg, session, root);
        }
        List<String> removedResources = cfg.checkForRemovedWatchedFolders(session);
        return removedResources;
    }

    InstallerConfig getConfiguration() {
        InstallerConfig cfg = null;
        StoppableThread st = this.backgroundThread;
        if (st != null) {
            cfg = st.getConfiguration();
        }
        return cfg;
    }

    Session getSession() {
        return this.backgroundThread.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOneCycle(InstallerConfig cfg, Session session) {
        this.logger.debug("Running watch cycle.");
        try {
            boolean didRefresh = false;
            if (cfg.anyWatchFolderNeedsScan()) {
                session.refresh(false);
                didRefresh = true;
                if (this.scanningIsPaused(cfg, session)) {
                    if (!this.pauseMessageLogged) {
                        this.logger.info("Detected signal for pausing the JCR Provider i.e. child nodes found under path {}. JCR Provider scanning would not be performed", (Object)cfg.getPauseScanNodePath());
                        this.pauseMessageLogged = true;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ignored) {
                        this.logger.debug("InterruptedException in scanningIsPaused block");
                    }
                    return;
                }
                if (this.pauseMessageLogged) {
                    this.pauseMessageLogged = false;
                }
            }
            boolean scanWf = false;
            for (WatchedFolder wf : cfg.cloneWatchedFolders()) {
                if (!wf.needsScan()) continue;
                scanWf = true;
                if (!didRefresh) {
                    session.refresh(false);
                    didRefresh = true;
                }
                this.counters.incrementAndGet(0);
                WatchedFolder.ScanResult sr = wf.scan();
                boolean toDo = false;
                if (sr.toAdd.size() > 0) {
                    this.logger.info("Registering resource with OSGi installer: {}", sr.toAdd);
                    toDo = true;
                }
                if (sr.toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer: {}", sr.toRemove);
                    toDo = true;
                }
                if (!toDo) continue;
                this.installer.updateResources(URL_SCHEME, sr.toAdd.toArray(new InstallableResource[sr.toAdd.size()]), sr.toRemove.toArray(new String[sr.toRemove.size()]));
            }
            if (scanWf || this.updateFoldersListTimer.expired()) {
                if (!didRefresh) {
                    session.refresh(false);
                    didRefresh = true;
                }
                this.updateFoldersListTimer.reset();
                this.counters.incrementAndGet(1);
                List<String> toRemove = this.updateFoldersList(cfg, session);
                if (toRemove.size() > 0) {
                    this.logger.info("Removing resource from OSGi installer (folder deleted): {}", toRemove);
                    this.installer.updateResources(URL_SCHEME, null, toRemove.toArray(new String[toRemove.size()]));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception in runOneCycle()", (Throwable)e);
        }
        if (this.backgroundThread.active.get()) {
            Object object = this.backgroundThread.lock;
            synchronized (object) {
                try {
                    this.backgroundThread.lock.wait(500L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.counters.incrementAndGet(2);
    }

    boolean scanningIsPaused(InstallerConfig cfg, Session session) throws RepositoryException {
        if (session.nodeExists(cfg.getPauseScanNodePath())) {
            Node node = session.getNode(cfg.getPauseScanNodePath());
            boolean result = node.hasNodes();
            if (result && this.logger.isDebugEnabled()) {
                ArrayList<String> nodeNames = new ArrayList<String>();
                NodeIterator childItr = node.getNodes();
                while (childItr.hasNext()) {
                    nodeNames.add(childItr.nextNode().getName());
                }
                this.logger.debug("Found child nodes {} at path {}. Scanning will be paused", nodeNames, (Object)cfg.getPauseScanNodePath());
            }
            return result;
        }
        return false;
    }

    long getCounterValue(int key) {
        return this.counters.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult handleRemoval(String resourceType, String id, String url) {
        InstallerConfig cfg = this.getConfiguration();
        if (cfg == null || !cfg.isWriteBack()) {
            return null;
        }
        int pos = url.indexOf(58);
        String path = url.substring(pos + 1);
        if (!url.startsWith(URL_SCHEME)) {
            this.logger.debug("Not removing unmanaged artifact from repository: {}", (Object)url);
            return null;
        }
        String[] rootPaths = cfg.getFolderNameFilter().getRootPaths();
        String systemConfigRootPath = rootPaths[rootPaths.length - 1];
        if (path.startsWith(systemConfigRootPath)) {
            this.logger.debug("Not removing system artifact from repository at {}", (Object)path);
            return null;
        }
        boolean found = false;
        int lastSlash = path.lastIndexOf(47);
        while (!found && lastSlash > 1) {
            String prefix = path.substring(0, lastSlash);
            if (cfg.getFolderNameFilter().getPriority(prefix) != -1) {
                found = true;
                continue;
            }
            lastSlash = prefix.lastIndexOf(47);
        }
        if (found) {
            this.logger.debug("Removing artifact at {}", (Object)path);
            Session session = null;
            try {
                session = this.repository.loginService(null, this.repository.getDefaultWorkspace());
                if (session.itemExists(path)) {
                    session.getItem(path).remove();
                    session.save();
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to remove resource from " + path, (Throwable)re);
                UpdateResult updateResult = null;
                return updateResult;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            return new UpdateResult(url);
        }
        this.logger.debug("Not removing unmanaged artifact from repository at {}", (Object)path);
        return null;
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, null, dict, attributes);
    }

    public UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Map<String, Object> attributes) {
        return this.handleUpdate(resourceType, id, url, is, null, attributes);
    }

    private String getPathWithHighestPrio(InstallerConfig cfg, String oldPath) {
        String path;
        String rootPath = cfg.getFolderNameFilter().getRootPaths()[0] + '/';
        if (!oldPath.startsWith(rootPath)) {
            int slashPos = oldPath.indexOf(47, 1);
            path = rootPath + oldPath.substring(slashPos + 1);
        } else {
            path = oldPath;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateResult handleUpdate(String resourceType, String id, String url, InputStream is, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        InstallerConfig cfg = this.getConfiguration();
        if (cfg == null || !cfg.isWriteBack()) {
            return null;
        }
        if (!resourceType.equals("config")) {
            return null;
        }
        Session session = null;
        try {
            String path;
            session = this.repository.loginService(null, this.repository.getDefaultWorkspace());
            boolean resourceIsMoved = true;
            if (url != null) {
                String nodePath;
                int pos = url.indexOf(58);
                String oldPath = url.substring(pos + 1);
                if (url.startsWith("jcrinstall:")) {
                    nodePath = this.getPathWithHighestPrio(cfg, oldPath);
                } else {
                    int lastSlash = url.lastIndexOf(47);
                    int lastPos = url.lastIndexOf(46);
                    String name = lastSlash == -1 || lastPos < lastSlash ? id : url.substring(lastSlash + 1, lastPos);
                    nodePath = this.getPathWithHighestPrio(cfg, cfg.getNewConfigPath() + name + CONFIG_FILE_EXTENSION);
                }
                if (!nodePath.endsWith(CONFIG_FILE_EXTENSION)) {
                    if (session.itemExists(nodePath)) {
                        session.getItem(nodePath).remove();
                    }
                    path = nodePath + CONFIG_FILE_EXTENSION;
                } else {
                    path = nodePath;
                }
                resourceIsMoved = nodePath.equals(oldPath);
                this.logger.debug("Update of {} at {}", (Object)resourceType, (Object)path);
            } else {
                String name = attributes != null && attributes.get("resource.uri.hint") != null ? (String)attributes.get("resource.uri.hint") : id;
                path = cfg.getNewConfigPath() + name + CONFIG_FILE_EXTENSION;
                this.logger.debug("Add of {} at {}", (Object)resourceType, (Object)path);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("// Configuration created by Apache Sling JCR Installer\n".getBytes(ENCODING));
            ConfigurationSerializer serializer = ConfigurationSerializerFactory.create((ConfigurationSerializerFactory.Format)ConfigurationSerializerFactory.Format.JSON);
            serializer.serialize(dict, (OutputStream)baos);
            baos.close();
            JcrUtil.createPath(session, path, NT_FILE);
            Node dataNode = JcrUtil.createPath(session, path + "/jcr:content", NT_RESOURCE);
            dataNode.setProperty(PROP_DATA, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            dataNode.setProperty(PROP_MODIFIED, Calendar.getInstance());
            dataNode.setProperty(PROP_ENC, ENCODING);
            dataNode.setProperty(PROP_MIME, MIME_TXT);
            session.save();
            UpdateResult result = new UpdateResult("jcrinstall:" + path);
            int lastSlash = path.lastIndexOf(47);
            String parentPath = path.substring(0, lastSlash);
            result.setPriority(Integer.valueOf(cfg.getFolderNameFilter().getPriority(parentPath)));
            result.setResourceIsMoved(resourceIsMoved);
            UpdateResult updateResult = result;
            return updateResult;
        }
        catch (RepositoryException re) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)re);
            UpdateResult updateResult = null;
            return updateResult;
        }
        catch (IOException e) {
            this.logger.error("Unable to add/update resource " + resourceType + ':' + id, (Throwable)e);
            UpdateResult updateResult = null;
            return updateResult;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    class StoppableThread
    extends Thread
    implements EventListener {
        final Object lock = new Object();
        final AtomicBoolean active = new AtomicBoolean(false);
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final InstallerConfig cfg;
        private final List<RootFolderListener> listeners = new LinkedList<RootFolderListener>();
        private volatile RootFolderMoveListener moveEventListener;
        private volatile Session session;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoppableThread(InstallerConfig cfg) throws RepositoryException {
            this.cfg = cfg;
            this.setName("JcrInstaller." + String.valueOf(bgThreadCounter.incrementAndGet()));
            this.setDaemon(true);
            try {
                this.session = JcrInstaller.this.repository.loginService(null, JcrInstaller.this.repository.getDefaultWorkspace());
                for (String path : cfg.getRoots()) {
                    this.listeners.add(new RootFolderListener(this.session, path, JcrInstaller.this.updateFoldersListTimer, cfg));
                    JcrInstaller.this.logger.debug("Configured root folder: {}", (Object)path);
                }
                this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 3, "/", false, null, null, true);
                if (cfg.getRoots() != null && cfg.getRoots().length > 0) {
                    this.moveEventListener = new RootFolderMoveListener(this.session, cfg.getRoots(), JcrInstaller.this.updateFoldersListTimer);
                }
                JcrInstaller.this.logger.debug("Watching for node events on / to detect removal/add of our root folders");
                for (String root : cfg.getRoots()) {
                    JcrInstaller.this.findPathsToWatch(cfg, this.session, root);
                }
                List<InstallableResource> resources = cfg.scanWatchedFolders();
                JcrInstaller.this.logger.debug("Registering {} resources with OSGi installer: {}", (Object)resources.size(), resources);
                JcrInstaller.this.installer.registerResources(JcrInstaller.URL_SCHEME, resources.toArray(new InstallableResource[resources.size()]));
                this.active.set(true);
            }
            finally {
                if (!this.active.get()) {
                    this.shutdown();
                }
            }
        }

        public void shutdown() {
            while (this.running.get()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                if (this.session != null) {
                    for (RootFolderListener wfc : this.listeners) {
                        wfc.cleanup(this.session);
                    }
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                    if (this.moveEventListener != null) {
                        this.moveEventListener.cleanup(this.session);
                        this.moveEventListener = null;
                    }
                }
            }
            catch (RepositoryException e) {
                JcrInstaller.this.logger.warn("Exception in stop()", (Throwable)e);
            }
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
            this.listeners.clear();
        }

        public void onEvent(EventIterator it) {
            try {
                while (it.hasNext()) {
                    Event e = it.nextEvent();
                    JcrInstaller.this.logger.debug("Got event {}", (Object)e);
                    this.checkChanges(e.getPath());
                }
            }
            catch (RepositoryException re) {
                JcrInstaller.this.logger.warn("RepositoryException in onEvent", (Throwable)re);
            }
        }

        private void checkChanges(String path) {
            for (String root : this.cfg.getRoots()) {
                if (!path.startsWith(root)) continue;
                JcrInstaller.this.logger.info("Got event for root {}, scheduling scanning of new folders", (Object)root);
                JcrInstaller.this.updateFoldersListTimer.scheduleScan();
            }
        }

        @Override
        public final void run() {
            JcrInstaller.this.logger.info("Background thread {} starting", (Object)Thread.currentThread().getName());
            while (this.active.get()) {
                this.running.set(true);
                try {
                    JcrInstaller.this.runOneCycle(this.cfg, this.session);
                }
                finally {
                    this.running.set(false);
                }
            }
            JcrInstaller.this.logger.info("Background thread {} done", (Object)Thread.currentThread().getName());
            JcrInstaller.this.counters.set(2, -1L);
        }

        public InstallerConfig getConfiguration() {
            return this.cfg;
        }
    }

    static interface NodeConverter {
        public InstallableResource convertNode(Node var1, int var2) throws RepositoryException;
    }

    @ObjectClassDefinition(id="org.apache.sling.installer.provider.jcr.impl.JcrInstaller", name="Apache Sling JCR Installer", description="Installs OSGi bundles and configurations found in the JCR Repository.")
    static @interface Configuration {
        @AttributeDefinition(name="Schemes", description="For these schemes this installer writes back configurations.")
        public String[] handler_schemes() default {"jcrinstall"};

        @AttributeDefinition(name="Installation folders name regexp", description="JCRInstall looks in repository folders having a name that match this regular expression (under the root paths, which are defined by the ResourceResolver search path) for resources to install. Folders having names that match this expression, followed by dotted run mode selectors (like \"install.author.production\") are also included.")
        public String sling_jcrinstall_folder_name_regexp() default ".*/(install|config)$";

        @AttributeDefinition(name="Max hierarchy depth of install folders", description="Folders that are nested deeper than this value under the repository root are ignored")
        public int sling_jcrinstall_folder_max_depth() default 4;

        @AttributeDefinition(name="New Config Path", description="New configurations are stored at this location. If this path is relative, the resource resolver search path with highest priority is prepended. Otherwise this path is used as is.")
        public String sling_jcrinstall_new_config_path() default "sling/install";

        @AttributeDefinition(name="Search Path", description="List of paths under which jcrinstall looks for installable resources. Combined with the installations folders name regexp to select folders for scanning. Each path is followed by a colon and the priority of resources found under that path, resources with higher values override resources with lower values which represent the same OSGi entity (configuration, bundle, etc).")
        public String[] sling_jcrinstall_search_path() default {"/libs:100", "/apps:200"};

        @AttributeDefinition(name="Signal Node Path", description="Path of the node in repository whose children would be watched for determining if the watch folder scanning has to be performed or not. If any child node is found at this path then scanning would be paused.")
        public String sling_jcrinstall_signal_path() default "/system/sling/installer/jcr/pauseInstallation";

        @AttributeDefinition(name="Enable Write Back", description="Enable writing back of changes done through other tools like writing back configurations changed in the web console etc.")
        public boolean sling_jcrinstall_enable_writeback() default true;
    }
}

