/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class MimeTypes {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final HashMap<String, MimeType> byMimeType = new HashMap();
    private static final HashMap<String, MimeType> byExtension = new HashMap();

    private static void addMapping(boolean binary, String mimeType, String ... ext) {
        if (byMimeType.containsKey(mimeType)) {
            throw new IllegalArgumentException("MimeType already registered:" + mimeType);
        }
        MimeType mt = new MimeType(mimeType, binary, ext);
        byMimeType.put(mimeType, mt);
        for (String e : ext) {
            if (byExtension.containsKey(e)) continue;
            byExtension.put(e, mt);
        }
    }

    public static String getMimeType(String name) {
        return MimeTypes.getMimeType(name, null);
    }

    public static String getMimeType(String name, String defaultType) {
        MimeType mt = byExtension.get(name = name.substring(name.lastIndexOf(46) + 1));
        if (mt == null) {
            return defaultType;
        }
        return mt.mimeType;
    }

    public static String getExtension(String mimeType) {
        MimeType mt = byMimeType.get(mimeType);
        if (mt == null) {
            return null;
        }
        return mt.defaultExt;
    }

    public static boolean isBinary(String mimeType) {
        if (mimeType == null) {
            return true;
        }
        if (mimeType.startsWith("text/")) {
            return false;
        }
        MimeType mt = byMimeType.get(mimeType);
        return mt == null || mt.isBinary();
    }

    public static boolean hasExtension(String mimeType, String ext) {
        MimeType mt = byMimeType.get(mimeType);
        return mt != null && mt.extensions.contains(ext);
    }

    public static boolean matches(String name, String mimeType, String defaultType) {
        MimeType mt = byExtension.get(name = name.substring(name.lastIndexOf(46) + 1));
        if (mt != null && mt.mimeType.equals(mimeType)) {
            return true;
        }
        mt = byMimeType.get(mimeType);
        if (mt != null && mt.extensions.contains(name)) {
            return true;
        }
        return mimeType.equals(defaultType);
    }

    static {
        MimeTypes.addMapping(false, "text/plain", "txt", "jsp", "jspx", "jspf", "ecma", "esp", "xsl", "xslt", "dtd", "properties", "tld", "php", "rb", "bnd");
        MimeTypes.addMapping(false, "text/cnd", "cnd");
        MimeTypes.addMapping(false, "text/x-java-source", "java");
        MimeTypes.addMapping(true, "application/java-vm", "class");
        MimeTypes.addMapping(false, "text/html", "html", "htm");
        MimeTypes.addMapping(false, "text/xml", "xml");
        MimeTypes.addMapping(false, "text/css", "css", "less");
        MimeTypes.addMapping(false, "text/calendar", "ics");
        MimeTypes.addMapping(false, "image/svg+xml", "svg");
        MimeTypes.addMapping(false, "application/xliff+xml", "xliff");
        MimeTypes.addMapping(true, "image/gif", "gif");
        MimeTypes.addMapping(true, "image/png", "png");
        MimeTypes.addMapping(true, "image/jpeg", "jpg", "jpeg");
        MimeTypes.addMapping(true, "image/jpg", "jpg", "jpeg");
        MimeTypes.addMapping(false, "application/json", "json");
        MimeTypes.addMapping(true, "application/java-archive", "jar");
        MimeTypes.addMapping(false, "application/javascript", "js");
        MimeTypes.addMapping(false, "application/ecmascript", "ecma");
        MimeTypes.addMapping(false, "application/x-javascript", "js");
        MimeTypes.addMapping(true, "application/pdf", "pdf");
        MimeTypes.addMapping(true, "application/x-shockwave-flash", "swf");
        MimeTypes.addMapping(true, "application/zip", "zip");
        MimeTypes.addMapping(true, "image/vnd.microsoft.icon", "ico");
        MimeTypes.addMapping(true, "application/x-font-woff", "woff");
        MimeTypes.addMapping(true, "application/vnd.ms-fontobject", "eot");
    }

    private static class MimeType {
        private final String mimeType;
        private final String defaultExt;
        private final HashSet<String> extensions = new HashSet();
        private final boolean binary;

        public MimeType(String mimeType, boolean binary, String ... ext) {
            this.mimeType = mimeType;
            this.binary = binary;
            this.defaultExt = ext[0];
            this.extensions.addAll(Arrays.asList(ext));
        }

        public boolean isBinary() {
            return this.binary;
        }
    }
}

