/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.constraint;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.opengis.metadata.constraint.Classification;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.util.InternationalString;

@XmlType(name="MD_SecurityConstraints_Type", propOrder={"classification", "userNote", "classificationSystem", "handlingDescription"})
@XmlRootElement(name="MD_SecurityConstraints")
public class DefaultSecurityConstraints
extends DefaultConstraints
implements SecurityConstraints {
    private static final long serialVersionUID = 621767670847345848L;
    private Classification classification;
    private InternationalString userNote;
    private InternationalString classificationSystem;
    private InternationalString handlingDescription;

    public DefaultSecurityConstraints() {
    }

    public DefaultSecurityConstraints(CharSequence useLimitation) {
        super(useLimitation);
    }

    public DefaultSecurityConstraints(Classification classification) {
        this.classification = classification;
    }

    public DefaultSecurityConstraints(SecurityConstraints object) {
        super((Constraints)object);
        if (object != null) {
            this.classification = object.getClassification();
            this.userNote = object.getUserNote();
            this.classificationSystem = object.getClassificationSystem();
            this.handlingDescription = object.getHandlingDescription();
        }
    }

    public static DefaultSecurityConstraints castOrCopy(SecurityConstraints object) {
        if (object == null || object instanceof DefaultSecurityConstraints) {
            return (DefaultSecurityConstraints)object;
        }
        return new DefaultSecurityConstraints(object);
    }

    @XmlElement(name="classification", required=true)
    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification newValue) {
        this.checkWritePermission(this.classification);
        this.classification = newValue;
    }

    @XmlElement(name="userNote")
    public InternationalString getUserNote() {
        return this.userNote;
    }

    public void setUserNote(InternationalString newValue) {
        this.checkWritePermission(this.userNote);
        this.userNote = newValue;
    }

    @XmlElement(name="classificationSystem")
    public InternationalString getClassificationSystem() {
        return this.classificationSystem;
    }

    public void setClassificationSystem(InternationalString newValue) {
        this.checkWritePermission(this.classificationSystem);
        this.classificationSystem = newValue;
    }

    @XmlElement(name="handlingDescription")
    public InternationalString getHandlingDescription() {
        return this.handlingDescription;
    }

    public void setHandlingDescription(InternationalString newValue) {
        this.checkWritePermission(this.handlingDescription);
        this.handlingDescription = newValue;
    }
}

