/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.gui.dataset.WindowManager;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.DataStoreOpener;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.internal.PrivateAccess;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.CloseEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public abstract class WindowHandler {
    public final WindowManager manager;
    private Stage window;
    public final StringProperty title;
    private static final ChangeListener<String> TITLE_CHANGED = (p, o, n) -> {
        WindowHandler handler = (WindowHandler)((StringProperty)p).getBean();
        handler.window.setTitle(n + " \u2014 Apache SIS");
    };

    WindowHandler(WindowHandler creator, Locale locale) {
        this.manager = creator != null ? creator.manager : new WindowManager(this, locale);
        this.title = new SimpleStringProperty((Object)this, "title");
    }

    final WindowHandler finish() {
        String text;
        if (this.manager.main == this) {
            text = Resources.forLocale(this.manager.locale).getString((short)25);
        } else {
            try {
                text = DataStoreOpener.findLabel(this.getResource(), this.manager.locale, true);
            }
            catch (RuntimeException | DataStoreException e) {
                text = Vocabulary.forLocale((Locale)this.manager.locale).getString((short)207);
                Logging.recoverableException((Logger)LogHandler.LOGGER, WindowHandler.class, (String)"<init>", (Throwable)e);
            }
        }
        this.title.set((Object)text);
        this.manager.modifiableWindowList.add((Object)this);
        return this;
    }

    public static WindowHandler create(CoverageExplorer widget) {
        return new ForCoverage(null, widget.getLocale(), widget).finish();
    }

    public static WindowHandler create(FeatureTable widget) {
        return new ForFeatures(null, widget.textLocale, widget).finish();
    }

    public abstract WindowHandler duplicate();

    abstract Resource getResource();

    public abstract Optional<MapCanvas> getCanvas();

    abstract Region getView();

    Window getWindow() {
        return GUIUtilities.getWindow((Node)this.getView());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void show() {
        if (this.window == null) {
            if (this.manager.main == this) {
                Window w = this.getWindow();
                if (!(w instanceof Stage)) return;
                this.window = (Stage)w;
            } else {
                Resource resource = this.getResource();
                if (resource == null) {
                    throw new IllegalStateException(Errors.format((short)36, this.getClass()));
                }
                OnClose listener = new OnClose();
                resource.addListener(CloseEvent.class, (StoreListener)listener);
                this.window = this.manager.newWindow(this.getView());
                this.window.setOnHidden((EventHandler)listener);
                this.title.addListener(TITLE_CHANGED);
                TITLE_CHANGED.changed((ObservableValue)this.title, null, (Object)((String)this.title.get()));
            }
        }
        this.window.show();
        this.window.toFront();
    }

    private static void close(Resource resource, WindowHandler force) {
        WindowHandler ignore = force.manager.main;
        ObservableList<WindowHandler> windows = force.manager.modifiableWindowList;
        int i = windows.size();
        while (--i >= 0) {
            WindowHandler handler = (WindowHandler)windows.get(i);
            if (handler == ignore || handler != force && handler.getResource() != resource) continue;
            windows.remove(i);
            if (handler.window != null) {
                handler.window.setOnHidden(null);
                handler.window.close();
            }
            handler.dispose();
        }
    }

    void dispose() {
        assert (this.manager.main != this);
        this.title.removeListener(TITLE_CHANGED);
        if (this.window != null) {
            this.window.setScene(null);
            this.window = null;
        }
    }

    private static final class ForCoverage
    extends WindowHandler {
        private final CoverageExplorer widget;

        ForCoverage(WindowHandler creator, Locale locale, CoverageExplorer widget) {
            super(creator, locale);
            this.widget = widget;
        }

        private ForCoverage(WindowHandler creator, CoverageExplorer widget) {
            this(creator, null, widget);
        }

        @Override
        Resource getResource() {
            return this.widget.getResource();
        }

        @Override
        public Optional<MapCanvas> getCanvas() {
            return Optional.of(this.widget.getCanvas());
        }

        @Override
        Region getView() {
            return this.widget.getView();
        }

        @Override
        Window getWindow() {
            return GUIUtilities.getWindow((Node)this.widget.getDataView(this.widget.getViewType()));
        }

        @Override
        public WindowHandler duplicate() {
            return new CoverageExplorer(this.widget).getWindowHandler();
        }

        @Override
        void dispose() {
            super.dispose();
            this.widget.setResource(null);
        }

        static {
            PrivateAccess.newWindowHandler = ForCoverage::new;
            PrivateAccess.finishWindowHandler = WindowHandler::finish;
        }
    }

    private static final class ForFeatures
    extends WindowHandler {
        private final FeatureTable widget;

        ForFeatures(WindowHandler creator, Locale locale, FeatureTable widget) {
            super(creator, locale);
            this.widget = widget;
        }

        @Override
        Resource getResource() {
            return this.widget.getFeatures();
        }

        @Override
        public Optional<MapCanvas> getCanvas() {
            return Optional.empty();
        }

        @Override
        Region getView() {
            return this.widget;
        }

        @Override
        public WindowHandler duplicate() {
            return new ForFeatures(this, null, new FeatureTable(this.widget)).finish();
        }

        @Override
        void dispose() {
            super.dispose();
            this.widget.setFeatures(null);
        }
    }

    private final class OnClose
    implements StoreListener<CloseEvent>,
    EventHandler<WindowEvent> {
        OnClose() {
        }

        public void handle(WindowEvent event) {
            WindowHandler.this.manager.modifiableWindowList.remove((Object)WindowHandler.this);
            Resource resource = WindowHandler.this.getResource();
            if (resource != null) {
                resource.removeListener(CloseEvent.class, (StoreListener)this);
            }
            WindowHandler.this.dispose();
        }

        public void eventOccured(CloseEvent event) {
            Resource resource = event.getSource();
            if (Platform.isFxApplicationThread()) {
                WindowHandler.close(resource, WindowHandler.this);
            } else {
                BackgroundThreads.runAndWaitDialog(() -> {
                    WindowHandler.close(resource, WindowHandler.this);
                    return null;
                });
            }
        }
    }
}

