/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    ORIGINAL,
    POSITIVE_RANGE,
    RIGHT_HANDED,
    DISPLAY_ORIENTED{

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            return NORMALIZED.getDirectionReplacement(axis, direction);
        }
    }
    ,
    NORMALIZED{

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            if (Units.isLinear(unit)) {
                unit = Units.METRE;
            } else if (Units.isAngular((Unit)unit)) {
                unit = Units.DEGREE;
            } else if (Units.isTemporal((Unit)unit)) {
                unit = Units.DAY;
            }
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            if (!AxisDirections.isIntercardinal(direction) && (axis == null || axis.getMinimumValue() < 0.0)) {
                return AxisDirections.absolute(direction);
            }
            return direction;
        }
    };


    public static AxesConvention[] valuesForOrder() {
        return new AxesConvention[]{RIGHT_HANDED, DISPLAY_ORIENTED};
    }
}

