/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracer;
import brave.http.HttpTracing;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.tracing.zipkin.ZipkinConsumerDelegate;
import org.apache.servicecomb.tracing.zipkin.ZipkinProviderDelegate;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZipkinTracingHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipkinTracingHandler.class);
    private final HttpTracing httpTracing;

    ZipkinTracingHandler(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
    }

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        ZipkinTracingDelegate tracingDelegate = this.collectTracing(invocation);
        Span span = tracingDelegate.createSpan(invocation);
        try (Tracer.SpanInScope scope = tracingDelegate.tracer().tracer().withSpanInScope(span);){
            LOGGER.debug("{}: Generated tracing span for {}", (Object)tracingDelegate.name(), (Object)invocation.getOperationName());
            invocation.next(this.onResponse(invocation, asyncResp, span, tracingDelegate));
        }
        catch (Exception e) {
            LOGGER.debug("{}: Failed invocation on {}", new Object[]{tracingDelegate.name(), invocation.getOperationName(), e});
            tracingDelegate.onResponse(span, null, e);
            throw e;
        }
    }

    private AsyncResponse onResponse(Invocation invocation, AsyncResponse asyncResp, Span span, ZipkinTracingDelegate tracingDelegate) {
        return response -> {
            Throwable error = response.isFailed() ? (Throwable)response.getResult() : null;
            tracingDelegate.onResponse(span, response, error);
            LOGGER.debug("{}: Completed invocation on {}", new Object[]{tracingDelegate.name(), invocation.getOperationName(), error});
            asyncResp.handle(response);
        };
    }

    private ZipkinTracingDelegate collectTracing(Invocation invocation) {
        if (InvocationType.PRODUCER.equals((Object)invocation.getInvocationType())) {
            return new ZipkinProviderDelegate(this.httpTracing);
        }
        return new ZipkinConsumerDelegate(this.httpTracing);
    }
}

