/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.hook;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.java.hook.Attribute;
import org.apache.rocketmq.client.java.hook.AttributeKey;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContext;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class CompositedMessageInterceptor
implements MessageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MessageInterceptor.class);
    private static final AttributeKey<Map<Integer, Map<AttributeKey, Attribute>>> INTERCEPTOR_ATTRIBUTES_KEY = AttributeKey.create("composited_interceptor_attributes");
    private final List<MessageInterceptor> interceptors = new ArrayList<MessageInterceptor>();

    public CompositedMessageInterceptor(List<MessageInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
    }

    @Override
    public void doBefore(MessageInterceptorContext context0, List<GeneralMessage> messages) {
        HashMap<Integer, Map<AttributeKey, Attribute>> attributeMap = new HashMap<Integer, Map<AttributeKey, Attribute>>();
        MessageHookPoints messageHookPoints = context0.getMessageHookPoints();
        MessageHookPointsStatus status = context0.getStatus();
        MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(messageHookPoints, status);
        for (int index = 0; index < this.interceptors.size(); ++index) {
            MessageInterceptor interceptor = this.interceptors.get(index);
            if (context0 instanceof MessageInterceptorContextImpl) {
                ((MessageInterceptorContextImpl)context0).getAttributes().forEach(context::putAttribute);
            }
            try {
                interceptor.doBefore(context, messages);
            }
            catch (Throwable t2) {
                log.error("Exception raised while handing messages", t2);
            }
            Map<AttributeKey, Attribute> attributes = context.getAttributes();
            attributeMap.put(index, attributes);
        }
        context0.putAttribute(INTERCEPTOR_ATTRIBUTES_KEY, Attribute.create(attributeMap));
    }

    @Override
    public void doAfter(MessageInterceptorContext context0, List<GeneralMessage> messages) {
        for (int index = this.interceptors.size() - 1; index >= 0; --index) {
            Map<Integer, Map<AttributeKey, Attribute>> attributeMap = context0.getAttribute(INTERCEPTOR_ATTRIBUTES_KEY).get();
            Map<AttributeKey, Attribute> attributes = attributeMap.get(index);
            MessageHookPoints messageHookPoints = context0.getMessageHookPoints();
            MessageHookPointsStatus status = context0.getStatus();
            MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(messageHookPoints, status, attributes);
            if (context0 instanceof MessageInterceptorContextImpl) {
                ((MessageInterceptorContextImpl)context0).getAttributes().forEach(context::putAttribute);
            }
            MessageInterceptor interceptor = this.interceptors.get(index);
            try {
                interceptor.doAfter(context, messages);
                continue;
            }
            catch (Throwable t2) {
                log.error("Exception raised while handing messages", t2);
            }
        }
    }

    public void addInterceptor(MessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }
}

