/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.client.java.impl.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.Endpoints;

public class ReceiveMessageResult {
    private final Endpoints endpoints;
    private final List<MessageViewImpl> messages;

    public ReceiveMessageResult(Endpoints endpoints, List<MessageViewImpl> messages) {
        this.endpoints = endpoints;
        this.messages = messages;
    }

    public static ReceiveMessageResult createFilteredResult(ReceiveMessageResult original,
        List<MessageViewImpl> filteredMessages) {
        return new ReceiveMessageResult(original.getEndpoints(), new ArrayList<>(filteredMessages));
    }

    public List<MessageView> getMessageViews() {
        return new ArrayList<>(messages);
    }

    public Endpoints getEndpoints() {
        return endpoints;
    }

    public List<MessageViewImpl> getMessageViewImpls() {
        return messages;
    }
}
