/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class TransactionMetrics
extends ConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private ConcurrentMap<String, Metric> transactionCounts = new ConcurrentHashMap<String, Metric>(1024);
    private DataVersion dataVersion = new DataVersion();
    private final String configPath;

    public TransactionMetrics(String configPath) {
        this.configPath = configPath;
    }

    public long addAndGet(String topic, int value) {
        Metric pair = this.getTopicPair(topic);
        this.getDataVersion().nextVersion();
        pair.setTimeStamp(System.currentTimeMillis());
        return pair.getCount().addAndGet(value);
    }

    public Metric getTopicPair(String topic) {
        Metric pair = (Metric)this.transactionCounts.get(topic);
        if (null != pair) {
            return pair;
        }
        pair = new Metric();
        Metric previous = this.transactionCounts.putIfAbsent(topic, pair);
        if (null != previous) {
            return previous;
        }
        return pair;
    }

    public long getTransactionCount(String topic) {
        Metric pair = (Metric)this.transactionCounts.get(topic);
        if (null == pair) {
            return 0L;
        }
        return pair.getCount().get();
    }

    public Map<String, Metric> getTransactionCounts() {
        return this.transactionCounts;
    }

    public void setTransactionCounts(ConcurrentMap<String, Metric> transactionCounts) {
        this.transactionCounts = transactionCounts;
    }

    protected void write0(Writer writer) throws IOException {
        TransactionMetricsSerializeWrapper wrapper = new TransactionMetricsSerializeWrapper();
        wrapper.setTransactionCount(this.transactionCounts);
        wrapper.setDataVersion(this.dataVersion);
        writer.write(JSON.toJSONString((Object)((Object)wrapper), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible}));
    }

    public String encode() {
        return this.encode(false);
    }

    public String configFilePath() {
        return this.configPath;
    }

    public void decode(String jsonString) {
        TransactionMetricsSerializeWrapper transactionMetricsSerializeWrapper;
        if (jsonString != null && (transactionMetricsSerializeWrapper = (TransactionMetricsSerializeWrapper)((Object)TransactionMetricsSerializeWrapper.fromJson((String)jsonString, TransactionMetricsSerializeWrapper.class))) != null) {
            this.transactionCounts.putAll(transactionMetricsSerializeWrapper.getTransactionCount());
            this.dataVersion.assignNewOne(transactionMetricsSerializeWrapper.getDataVersion());
        }
    }

    public String encode(boolean prettyFormat) {
        TransactionMetricsSerializeWrapper metricsSerializeWrapper = new TransactionMetricsSerializeWrapper();
        metricsSerializeWrapper.setDataVersion(this.dataVersion);
        metricsSerializeWrapper.setTransactionCount(this.transactionCounts);
        return metricsSerializeWrapper.toJson(prettyFormat);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void cleanMetrics(Set<String> topics) {
        if (topics == null || topics.isEmpty()) {
            return;
        }
        Iterator iterator = this.transactionCounts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String topic = (String)entry.getKey();
            if (topic.startsWith("rmq_sys_") || !topics.contains(topic)) continue;
            iterator.remove();
        }
    }

    public synchronized void persist() {
        try {
            File dir;
            String config = this.configFilePath();
            String backup = config + ".bak";
            File configFile = new File(config);
            File bakFile = new File(backup);
            if (configFile.exists()) {
                Files.move(configFile.toPath(), bakFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                MixAll.fsyncDirectory((Path)Paths.get(bakFile.getParent(), new String[0]));
            }
            if (!(dir = new File(configFile.getParent())).exists()) {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            StringWriter stringWriter = new StringWriter();
            this.write0(stringWriter);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(config, "rw");){
                randomAccessFile.write(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
                randomAccessFile.getChannel().force(true);
                MixAll.fsyncDirectory((Path)Paths.get(configFile.getParent(), new String[0]));
            }
        }
        catch (Throwable t) {
            log.error("Failed to persist", t);
        }
    }

    public static class Metric {
        private AtomicLong count = new AtomicLong(0L);
        private long timeStamp = System.currentTimeMillis();

        public AtomicLong getCount() {
            return this.count;
        }

        public void setCount(AtomicLong count) {
            this.count = count;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String toString() {
            return String.format("[%d,%d]", this.count.get(), this.timeStamp);
        }
    }

    public static class TransactionMetricsSerializeWrapper
    extends RemotingSerializable {
        private ConcurrentMap<String, Metric> transactionCount = new ConcurrentHashMap<String, Metric>(1024);
        private DataVersion dataVersion = new DataVersion();

        public ConcurrentMap<String, Metric> getTransactionCount() {
            return this.transactionCount;
        }

        public void setTransactionCount(ConcurrentMap<String, Metric> transactionCount) {
            this.transactionCount = transactionCount;
        }

        public DataVersion getDataVersion() {
            return this.dataVersion;
        }

        public void setDataVersion(DataVersion dataVersion) {
            this.dataVersion = dataVersion;
        }
    }
}

