/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.routeinfo;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.namesrv.NamesrvConfig;
import org.apache.rocketmq.common.sysflag.TopicSysFlag;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.namesrv.routeinfo.BatchUnregistrationService;
import org.apache.rocketmq.namesrv.routeinfo.BrokerAddrInfo;
import org.apache.rocketmq.namesrv.routeinfo.BrokerLiveInfo;
import org.apache.rocketmq.namesrv.routeinfo.BrokerStatusChangeInfo;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.body.TopicList;
import org.apache.rocketmq.remoting.protocol.header.NotifyMinBrokerIdChangeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.remoting.protocol.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.QueueData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingInfo;

public class RouteInfoManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    private static final long DEFAULT_BROKER_CHANNEL_EXPIRED_TIME = 120000L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Map<String, QueueData>> topicQueueTable = new ConcurrentHashMap<String, Map<String, QueueData>>(1024);
    private final Map<String, BrokerData> brokerAddrTable = new ConcurrentHashMap<String, BrokerData>(128);
    private final Map<String, Set<String>> clusterAddrTable = new ConcurrentHashMap<String, Set<String>>(32);
    private final Map<BrokerAddrInfo, BrokerLiveInfo> brokerLiveTable = new ConcurrentHashMap<BrokerAddrInfo, BrokerLiveInfo>(256);
    private final Map<BrokerAddrInfo, List<String>> filterServerTable = new ConcurrentHashMap<BrokerAddrInfo, List<String>>(256);
    private final Map<String, Map<String, TopicQueueMappingInfo>> topicQueueMappingInfoTable = new ConcurrentHashMap<String, Map<String, TopicQueueMappingInfo>>(1024);
    private final BatchUnregistrationService unRegisterService;
    private final NamesrvController namesrvController;
    private final NamesrvConfig namesrvConfig;

    public RouteInfoManager(NamesrvConfig namesrvConfig, NamesrvController namesrvController) {
        this.unRegisterService = new BatchUnregistrationService(this, namesrvConfig);
        this.namesrvConfig = namesrvConfig;
        this.namesrvController = namesrvController;
    }

    public void start() {
        this.unRegisterService.start();
    }

    public void shutdown() {
        this.unRegisterService.shutdown(true);
    }

    public boolean submitUnRegisterBrokerRequest(UnRegisterBrokerRequestHeader unRegisterRequest) {
        return this.unRegisterService.submit(unRegisterRequest);
    }

    int blockedUnRegisterRequests() {
        return this.unRegisterService.queueLength();
    }

    public ClusterInfo getAllClusterInfo() {
        ClusterInfo clusterInfoSerializeWrapper = new ClusterInfo();
        clusterInfoSerializeWrapper.setBrokerAddrTable(this.brokerAddrTable);
        clusterInfoSerializeWrapper.setClusterAddrTable(this.clusterAddrTable);
        return clusterInfoSerializeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTopic(String topic, List<QueueData> queueDatas) {
        if (queueDatas == null || queueDatas.isEmpty()) {
            return;
        }
        try {
            Map<Object, Object> queueDataMap;
            this.lock.writeLock().lockInterruptibly();
            if (this.topicQueueTable.containsKey(topic)) {
                queueDataMap = this.topicQueueTable.get(topic);
                for (QueueData queueData : queueDatas) {
                    if (!this.brokerAddrTable.containsKey(queueData.getBrokerName())) {
                        log.warn("Register topic contains illegal broker, {}, {}", (Object)topic, (Object)queueData);
                        return;
                    }
                    queueDataMap.put(queueData.getBrokerName(), queueData);
                }
                log.info("Topic route already exist.{}, {}", (Object)topic, this.topicQueueTable.get(topic));
            } else {
                queueDataMap = new HashMap();
                for (QueueData queueData : queueDatas) {
                    if (!this.brokerAddrTable.containsKey(queueData.getBrokerName())) {
                        log.warn("Register topic contains illegal broker, {}, {}", (Object)topic, (Object)queueData);
                        return;
                    }
                    queueDataMap.put(queueData.getBrokerName(), queueData);
                }
                this.topicQueueTable.put(topic, queueDataMap);
                log.info("Register topic route:{}, {}", (Object)topic, queueDatas);
            }
        }
        catch (Exception e) {
            log.error("registerTopic Exception", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteTopic(String topic) {
        try {
            this.lock.writeLock().lockInterruptibly();
            this.topicQueueTable.remove(topic);
        }
        catch (Exception e) {
            log.error("deleteTopic Exception", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTopic(String topic, String clusterName) {
        try {
            this.lock.writeLock().lockInterruptibly();
            Set<String> brokerNames = this.clusterAddrTable.get(clusterName);
            if (brokerNames == null || brokerNames.isEmpty()) {
                return;
            }
            Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topic);
            if (queueDataMap != null) {
                for (String brokerName : brokerNames) {
                    QueueData removedQD = queueDataMap.remove(brokerName);
                    if (removedQD == null) continue;
                    log.info("deleteTopic, remove one broker's topic {} {} {}", new Object[]{brokerName, topic, removedQD});
                }
                if (queueDataMap.isEmpty()) {
                    log.info("deleteTopic, remove the topic all queue {} {}", (Object)clusterName, (Object)topic);
                    this.topicQueueTable.remove(topic);
                }
            }
        }
        catch (Exception e) {
            log.error("deleteTopic Exception", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public TopicList getAllTopicList() {
        TopicList topicList = new TopicList();
        try {
            this.lock.readLock().lockInterruptibly();
            topicList.getTopicList().addAll(this.topicQueueTable.keySet());
        }
        catch (Exception e) {
            log.error("getAllTopicList Exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return topicList;
    }

    public RegisterBrokerResult registerBroker(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, String zoneName, Long timeoutMillis, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, Channel channel) {
        return this.registerBroker(clusterName, brokerAddr, brokerName, brokerId, haServerAddr, zoneName, timeoutMillis, false, topicConfigWrapper, filterServerList, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterBrokerResult registerBroker(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, String zoneName, Long timeoutMillis, Boolean enableActingMaster, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, Channel channel) {
        RegisterBrokerResult result = new RegisterBrokerResult();
        try {
            BrokerAddrInfo masterAddrInfo;
            BrokerLiveInfo masterLiveInfo;
            String masterAddr;
            BrokerAddrInfo brokerAddrInfo;
            BrokerLiveInfo prevBrokerLiveInfo;
            ConcurrentMap tcTable;
            boolean isPrimeSlave;
            long newStateVersion;
            long oldStateVersion;
            BrokerLiveInfo oldBrokerInfo;
            this.lock.writeLock().lockInterruptibly();
            Set brokerNames = (Set)ConcurrentHashMapUtils.computeIfAbsent((ConcurrentMap)((ConcurrentHashMap)this.clusterAddrTable), (Object)clusterName, k -> new HashSet());
            brokerNames.add(brokerName);
            boolean registerFirst = false;
            BrokerData brokerData = this.brokerAddrTable.get(brokerName);
            if (null == brokerData) {
                registerFirst = true;
                brokerData = new BrokerData(clusterName, brokerName, new HashMap());
                this.brokerAddrTable.put(brokerName, brokerData);
            }
            boolean isOldVersionBroker = enableActingMaster == null;
            brokerData.setEnableActingMaster(!isOldVersionBroker && enableActingMaster != false);
            brokerData.setZoneName(zoneName);
            HashMap brokerAddrsMap = brokerData.getBrokerAddrs();
            boolean isMinBrokerIdChanged = false;
            long prevMinBrokerId = 0L;
            if (!brokerAddrsMap.isEmpty()) {
                prevMinBrokerId = (Long)Collections.min(brokerAddrsMap.keySet());
            }
            if (brokerId < prevMinBrokerId) {
                isMinBrokerIdChanged = true;
            }
            brokerAddrsMap.entrySet().removeIf(item -> null != brokerAddr && brokerAddr.equals(item.getValue()) && brokerId != (Long)item.getKey());
            String oldBrokerAddr = (String)brokerAddrsMap.get(brokerId);
            if (null != oldBrokerAddr && !oldBrokerAddr.equals(brokerAddr) && null != (oldBrokerInfo = this.brokerLiveTable.get(new BrokerAddrInfo(clusterName, oldBrokerAddr))) && (oldStateVersion = oldBrokerInfo.getDataVersion().getStateVersion()) > (newStateVersion = topicConfigWrapper.getDataVersion().getStateVersion())) {
                log.warn("Registered Broker conflicts with the existed one, just ignore.: Cluster:{}, BrokerName:{}, BrokerId:{}, Old BrokerAddr:{}, Old Version:{}, New BrokerAddr:{}, New Version:{}.", new Object[]{clusterName, brokerName, brokerId, oldBrokerAddr, oldStateVersion, brokerAddr, newStateVersion});
                this.brokerLiveTable.remove(new BrokerAddrInfo(clusterName, brokerAddr));
                RegisterBrokerResult registerBrokerResult = result;
                return registerBrokerResult;
            }
            if (!brokerAddrsMap.containsKey(brokerId) && topicConfigWrapper.getTopicConfigTable().size() == 1) {
                log.warn("Can't register topicConfigWrapper={} because broker[{}]={} has not registered.", new Object[]{topicConfigWrapper.getTopicConfigTable(), brokerId, brokerAddr});
                oldBrokerInfo = null;
                return oldBrokerInfo;
            }
            String oldAddr = brokerAddrsMap.put(brokerId, brokerAddr);
            registerFirst = registerFirst || StringUtils.isEmpty((CharSequence)oldAddr);
            boolean isMaster = 0L == brokerId;
            boolean bl = isPrimeSlave = !isOldVersionBroker && !isMaster && brokerId == (Long)Collections.min(brokerAddrsMap.keySet());
            if (null != topicConfigWrapper && (isMaster || isPrimeSlave) && (tcTable = topicConfigWrapper.getTopicConfigTable()) != null) {
                TopicConfigAndMappingSerializeWrapper mappingSerializeWrapper = TopicConfigAndMappingSerializeWrapper.from((TopicConfigSerializeWrapper)topicConfigWrapper);
                Map topicQueueMappingInfoMap = mappingSerializeWrapper.getTopicQueueMappingInfoMap();
                if (this.namesrvConfig.isDeleteTopicWithBrokerRegistration() && topicQueueMappingInfoMap.isEmpty()) {
                    Iterator oldTopicSet = this.topicSetOfBrokerName(brokerName);
                    Set newTopicSet = tcTable.keySet();
                    Sets.SetView toDeleteTopics = Sets.difference((Set)((Object)oldTopicSet), newTopicSet);
                    for (String toDeleteTopic : toDeleteTopics) {
                        Map<String, QueueData> queueDataMap = this.topicQueueTable.get(toDeleteTopic);
                        QueueData removedQD = queueDataMap.remove(brokerName);
                        if (removedQD != null) {
                            log.info("deleteTopic, remove one broker's topic {} {} {}", new Object[]{brokerName, toDeleteTopic, removedQD});
                        }
                        if (!queueDataMap.isEmpty()) continue;
                        log.info("deleteTopic, remove the topic all queue {}", (Object)toDeleteTopic);
                        this.topicQueueTable.remove(toDeleteTopic);
                    }
                }
                for (Map.Entry entry : tcTable.entrySet()) {
                    if (!registerFirst && !this.isTopicConfigChanged(clusterName, brokerAddr, topicConfigWrapper.getDataVersion(), brokerName, ((TopicConfig)entry.getValue()).getTopicName())) continue;
                    TopicConfig topicConfig = (TopicConfig)entry.getValue();
                    if (isPrimeSlave && brokerData.isEnableActingMaster()) {
                        topicConfig.setPerm(topicConfig.getPerm() & 0xFFFFFFFD);
                    }
                    this.createAndUpdateQueueData(brokerName, topicConfig);
                }
                if (this.isBrokerTopicConfigChanged(clusterName, brokerAddr, topicConfigWrapper.getDataVersion()) || registerFirst) {
                    for (Map.Entry entry : topicQueueMappingInfoMap.entrySet()) {
                        if (!this.topicQueueMappingInfoTable.containsKey(entry.getKey())) {
                            this.topicQueueMappingInfoTable.put((String)entry.getKey(), new HashMap());
                        }
                        this.topicQueueMappingInfoTable.get(entry.getKey()).put(((TopicQueueMappingInfo)entry.getValue()).getBname(), (TopicQueueMappingInfo)entry.getValue());
                    }
                }
            }
            if (null == (prevBrokerLiveInfo = this.brokerLiveTable.put(brokerAddrInfo = new BrokerAddrInfo(clusterName, brokerAddr), new BrokerLiveInfo(System.currentTimeMillis(), timeoutMillis == null ? 120000L : timeoutMillis, topicConfigWrapper == null ? new DataVersion() : topicConfigWrapper.getDataVersion(), channel, haServerAddr)))) {
                log.info("new broker registered, {} HAService: {}", (Object)brokerAddrInfo, (Object)haServerAddr);
            }
            if (filterServerList != null) {
                if (filterServerList.isEmpty()) {
                    this.filterServerTable.remove(brokerAddrInfo);
                } else {
                    this.filterServerTable.put(brokerAddrInfo, filterServerList);
                }
            }
            if (0L != brokerId && (masterAddr = (String)brokerData.getBrokerAddrs().get(0L)) != null && (masterLiveInfo = this.brokerLiveTable.get(masterAddrInfo = new BrokerAddrInfo(clusterName, masterAddr))) != null) {
                result.setHaServerAddr(masterLiveInfo.getHaServerAddr());
                result.setMasterAddr(masterAddr);
            }
            if (isMinBrokerIdChanged && this.namesrvConfig.isNotifyMinBrokerIdChanged()) {
                this.notifyMinBrokerIdChanged(brokerAddrsMap, null, this.brokerLiveTable.get(brokerAddrInfo).getHaServerAddr());
            }
        }
        catch (Exception e) {
            log.error("registerBroker Exception", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    private Set<String> topicSetOfBrokerName(String brokerName) {
        HashSet<String> topicOfBroker = new HashSet<String>();
        for (Map.Entry<String, Map<String, QueueData>> entry : this.topicQueueTable.entrySet()) {
            if (!entry.getValue().containsKey(brokerName)) continue;
            topicOfBroker.add(entry.getKey());
        }
        return topicOfBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerMemberGroup getBrokerMemberGroup(String clusterName, String brokerName) {
        BrokerMemberGroup groupMember = new BrokerMemberGroup(clusterName, brokerName);
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (brokerData != null) {
                    groupMember.getBrokerAddrs().putAll(brokerData.getBrokerAddrs());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("Get broker member group exception", (Throwable)e);
        }
        return groupMember;
    }

    public boolean isBrokerTopicConfigChanged(String clusterName, String brokerAddr, DataVersion dataVersion) {
        DataVersion prev = this.queryBrokerTopicConfig(clusterName, brokerAddr);
        return null == prev || !prev.equals((Object)dataVersion);
    }

    public boolean isTopicConfigChanged(String clusterName, String brokerAddr, DataVersion dataVersion, String brokerName, String topic) {
        boolean isChange = this.isBrokerTopicConfigChanged(clusterName, brokerAddr, dataVersion);
        if (isChange) {
            return true;
        }
        Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topic);
        if (queueDataMap == null || queueDataMap.isEmpty()) {
            return true;
        }
        return !queueDataMap.containsKey(brokerName);
    }

    public DataVersion queryBrokerTopicConfig(String clusterName, String brokerAddr) {
        BrokerAddrInfo addrInfo = new BrokerAddrInfo(clusterName, brokerAddr);
        BrokerLiveInfo prev = this.brokerLiveTable.get(addrInfo);
        if (prev != null) {
            return prev.getDataVersion();
        }
        return null;
    }

    public void updateBrokerInfoUpdateTimestamp(String clusterName, String brokerAddr) {
        BrokerAddrInfo addrInfo = new BrokerAddrInfo(clusterName, brokerAddr);
        BrokerLiveInfo prev = this.brokerLiveTable.get(addrInfo);
        if (prev != null) {
            prev.setLastUpdateTimestamp(System.currentTimeMillis());
        }
    }

    private void createAndUpdateQueueData(String brokerName, TopicConfig topicConfig) {
        QueueData queueData = new QueueData();
        queueData.setBrokerName(brokerName);
        queueData.setWriteQueueNums(topicConfig.getWriteQueueNums());
        queueData.setReadQueueNums(topicConfig.getReadQueueNums());
        queueData.setPerm(topicConfig.getPerm());
        queueData.setTopicSysFlag(topicConfig.getTopicSysFlag());
        Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topicConfig.getTopicName());
        if (null == queueDataMap) {
            queueDataMap = new HashMap<String, QueueData>();
            queueDataMap.put(brokerName, queueData);
            this.topicQueueTable.put(topicConfig.getTopicName(), queueDataMap);
            log.info("new topic registered, {} {}", (Object)topicConfig.getTopicName(), (Object)queueData);
        } else {
            QueueData existedQD = queueDataMap.get(brokerName);
            if (existedQD == null) {
                queueDataMap.put(brokerName, queueData);
            } else if (!existedQD.equals((Object)queueData)) {
                log.info("topic changed, {} OLD: {} NEW: {}", new Object[]{topicConfig.getTopicName(), existedQD, queueData});
                queueDataMap.put(brokerName, queueData);
            }
        }
    }

    public int wipeWritePermOfBrokerByLock(String brokerName) {
        try {
            this.lock.writeLock().lockInterruptibly();
            int n = this.operateWritePermOfBroker(brokerName, 205);
            this.lock.writeLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                log.error("wipeWritePermOfBrokerByLock Exception", (Throwable)e);
                return 0;
            }
        }
    }

    public int addWritePermOfBrokerByLock(String brokerName) {
        try {
            this.lock.writeLock().lockInterruptibly();
            int n = this.operateWritePermOfBroker(brokerName, 327);
            this.lock.writeLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.writeLock().unlock();
                throw throwable;
            }
            catch (Exception e) {
                log.error("addWritePermOfBrokerByLock Exception", (Throwable)e);
                return 0;
            }
        }
    }

    private int operateWritePermOfBroker(String brokerName, int requestCode) {
        int topicCnt = 0;
        for (Map.Entry<String, Map<String, QueueData>> entry : this.topicQueueTable.entrySet()) {
            Map<String, QueueData> qdMap = entry.getValue();
            QueueData qd = qdMap.get(brokerName);
            if (qd == null) continue;
            int perm = qd.getPerm();
            switch (requestCode) {
                case 205: {
                    perm &= 0xFFFFFFFD;
                    break;
                }
                case 327: {
                    perm = 6;
                }
            }
            qd.setPerm(perm);
            ++topicCnt;
        }
        return topicCnt;
    }

    public void unregisterBroker(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        UnRegisterBrokerRequestHeader unRegisterBrokerRequest = new UnRegisterBrokerRequestHeader();
        unRegisterBrokerRequest.setClusterName(clusterName);
        unRegisterBrokerRequest.setBrokerAddr(brokerAddr);
        unRegisterBrokerRequest.setBrokerName(brokerName);
        unRegisterBrokerRequest.setBrokerId(Long.valueOf(brokerId));
        this.unRegisterBroker(Sets.newHashSet((Object[])new UnRegisterBrokerRequestHeader[]{unRegisterBrokerRequest}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterBroker(Set<UnRegisterBrokerRequestHeader> unRegisterRequests) {
        try {
            HashSet<String> removedBroker = new HashSet<String>();
            HashSet<String> reducedBroker = new HashSet<String>();
            HashMap<String, BrokerStatusChangeInfo> needNotifyBrokerMap = new HashMap<String, BrokerStatusChangeInfo>();
            this.lock.writeLock().lockInterruptibly();
            for (UnRegisterBrokerRequestHeader unRegisterRequest : unRegisterRequests) {
                String brokerAddr;
                String brokerName = unRegisterRequest.getBrokerName();
                String clusterName = unRegisterRequest.getClusterName();
                BrokerAddrInfo brokerAddrInfo = new BrokerAddrInfo(clusterName, brokerAddr = unRegisterRequest.getBrokerAddr());
                BrokerLiveInfo brokerLiveInfo = this.brokerLiveTable.remove(brokerAddrInfo);
                log.info("unregisterBroker, remove from brokerLiveTable {}, {}", (Object)(brokerLiveInfo != null ? "OK" : "Failed"), (Object)brokerAddrInfo);
                this.filterServerTable.remove(brokerAddrInfo);
                boolean removeBrokerName = false;
                boolean isMinBrokerIdChanged = false;
                BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                if (null != brokerData) {
                    boolean removed;
                    if (!brokerData.getBrokerAddrs().isEmpty() && unRegisterRequest.getBrokerId().equals(Collections.min(brokerData.getBrokerAddrs().keySet()))) {
                        isMinBrokerIdChanged = true;
                    }
                    log.info("unregisterBroker, remove addr from brokerAddrTable {}, {}", (Object)((removed = brokerData.getBrokerAddrs().entrySet().removeIf(item -> ((String)item.getValue()).equals(brokerAddr))) ? "OK" : "Failed"), (Object)brokerAddrInfo);
                    if (brokerData.getBrokerAddrs().isEmpty()) {
                        this.brokerAddrTable.remove(brokerName);
                        log.info("unregisterBroker, remove name from brokerAddrTable OK, {}", (Object)brokerName);
                        removeBrokerName = true;
                    } else if (isMinBrokerIdChanged) {
                        needNotifyBrokerMap.put(brokerName, new BrokerStatusChangeInfo(brokerData.getBrokerAddrs(), brokerAddr, null));
                    }
                }
                if (removeBrokerName) {
                    Set<String> nameSet = this.clusterAddrTable.get(clusterName);
                    if (nameSet != null) {
                        boolean removed = nameSet.remove(brokerName);
                        log.info("unregisterBroker, remove name from clusterAddrTable {}, {}", (Object)(removed ? "OK" : "Failed"), (Object)brokerName);
                        if (nameSet.isEmpty()) {
                            this.clusterAddrTable.remove(clusterName);
                            log.info("unregisterBroker, remove cluster from clusterAddrTable {}", (Object)clusterName);
                        }
                    }
                    removedBroker.add(brokerName);
                    continue;
                }
                reducedBroker.add(brokerName);
            }
            this.cleanTopicByUnRegisterRequests(removedBroker, reducedBroker);
            if (!needNotifyBrokerMap.isEmpty() && this.namesrvConfig.isNotifyMinBrokerIdChanged()) {
                this.notifyMinBrokerIdChanged(needNotifyBrokerMap);
            }
        }
        catch (Exception e) {
            log.error("unregisterBroker Exception", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void cleanTopicByUnRegisterRequests(Set<String> removedBroker, Set<String> reducedBroker) {
        Iterator<Map.Entry<String, Map<String, QueueData>>> itMap = this.topicQueueTable.entrySet().iterator();
        while (itMap.hasNext()) {
            Map.Entry<String, Map<String, QueueData>> entry = itMap.next();
            String topic = entry.getKey();
            Map<String, QueueData> queueDataMap = entry.getValue();
            for (String brokerName : removedBroker) {
                QueueData removedQD = queueDataMap.remove(brokerName);
                if (removedQD == null) continue;
                log.debug("removeTopicByBrokerName, remove one broker's topic {} {}", (Object)topic, (Object)removedQD);
            }
            if (queueDataMap.isEmpty()) {
                log.debug("removeTopicByBrokerName, remove the topic all queue {}", (Object)topic);
                itMap.remove();
            }
            for (String brokerName : reducedBroker) {
                QueueData queueData = queueDataMap.get(brokerName);
                if (queueData == null || !this.brokerAddrTable.get(brokerName).isEnableActingMaster() || !this.isNoMasterExists(brokerName)) continue;
                queueData.setPerm(queueData.getPerm() & 0xFFFFFFFD);
            }
        }
    }

    private boolean isNoMasterExists(String brokerName) {
        BrokerData brokerData = this.brokerAddrTable.get(brokerName);
        if (brokerData == null) {
            return true;
        }
        if (brokerData.getBrokerAddrs().size() == 0) {
            return true;
        }
        return (Long)Collections.min(brokerData.getBrokerAddrs().keySet()) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicRouteData pickupTopicRouteData(String topic) {
        TopicRouteData topicRouteData = new TopicRouteData();
        boolean foundQueueData = false;
        boolean foundBrokerData = false;
        LinkedList<BrokerData> brokerDataList = new LinkedList<BrokerData>();
        topicRouteData.setBrokerDatas(brokerDataList);
        HashMap<String, List<String>> filterServerMap = new HashMap<String, List<String>>();
        topicRouteData.setFilterServerTable(filterServerMap);
        try {
            this.lock.readLock().lockInterruptibly();
            Map<String, QueueData> queueDataMap = this.topicQueueTable.get(topic);
            if (queueDataMap != null) {
                topicRouteData.setQueueDatas(new ArrayList<QueueData>(queueDataMap.values()));
                foundQueueData = true;
                HashSet<String> brokerNameSet = new HashSet<String>(queueDataMap.keySet());
                for (String brokerName : brokerNameSet) {
                    BrokerData brokerData = this.brokerAddrTable.get(brokerName);
                    if (null == brokerData) continue;
                    BrokerData brokerDataClone = new BrokerData(brokerData);
                    brokerDataList.add(brokerDataClone);
                    foundBrokerData = true;
                    if (this.filterServerTable.isEmpty()) continue;
                    for (String brokerAddr : brokerDataClone.getBrokerAddrs().values()) {
                        BrokerAddrInfo brokerAddrInfo = new BrokerAddrInfo(brokerDataClone.getCluster(), brokerAddr);
                        List<String> filterServerList = this.filterServerTable.get(brokerAddrInfo);
                        filterServerMap.put(brokerAddr, filterServerList);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("pickupTopicRouteData Exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        log.debug("pickupTopicRouteData {} {}", (Object)topic, (Object)topicRouteData);
        if (foundBrokerData && foundQueueData) {
            topicRouteData.setTopicQueueMappingByBroker(this.topicQueueMappingInfoTable.get(topic));
            if (!this.namesrvConfig.isSupportActingMaster()) {
                return topicRouteData;
            }
            if (topic.startsWith("rmq_sys_SYNC_BROKER_MEMBER_")) {
                return topicRouteData;
            }
            if (topicRouteData.getBrokerDatas().size() == 0 || topicRouteData.getQueueDatas().size() == 0) {
                return topicRouteData;
            }
            boolean needActingMaster = false;
            for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                if (brokerData.getBrokerAddrs().size() == 0 || brokerData.getBrokerAddrs().containsKey(0L)) continue;
                needActingMaster = true;
                break;
            }
            if (!needActingMaster) {
                return topicRouteData;
            }
            block8: for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                HashMap brokerAddrs = brokerData.getBrokerAddrs();
                if (brokerAddrs.size() == 0 || brokerAddrs.containsKey(0L) || !brokerData.isEnableActingMaster()) continue;
                for (QueueData queueData : topicRouteData.getQueueDatas()) {
                    if (!queueData.getBrokerName().equals(brokerData.getBrokerName())) continue;
                    if (PermName.isWriteable((int)queueData.getPerm())) continue block8;
                    Long minBrokerId = (Long)Collections.min(brokerAddrs.keySet());
                    String actingMasterAddr = (String)brokerAddrs.remove(minBrokerId);
                    brokerAddrs.put(0L, actingMasterAddr);
                    continue block8;
                }
            }
            return topicRouteData;
        }
        return null;
    }

    public void scanNotActiveBroker() {
        try {
            log.info("start scanNotActiveBroker");
            for (Map.Entry<BrokerAddrInfo, BrokerLiveInfo> next : this.brokerLiveTable.entrySet()) {
                long timeoutMillis;
                long last = next.getValue().getLastUpdateTimestamp();
                if (last + (timeoutMillis = next.getValue().getHeartbeatTimeoutMillis()) >= System.currentTimeMillis()) continue;
                RemotingHelper.closeChannel((Channel)next.getValue().getChannel());
                log.warn("The broker channel expired, {} {}ms", (Object)next.getKey(), (Object)timeoutMillis);
                this.onChannelDestroy(next.getKey());
            }
        }
        catch (Exception e) {
            log.error("scanNotActiveBroker exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelDestroy(BrokerAddrInfo brokerAddrInfo) {
        UnRegisterBrokerRequestHeader unRegisterRequest = new UnRegisterBrokerRequestHeader();
        boolean needUnRegister = false;
        if (brokerAddrInfo != null) {
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    needUnRegister = this.setupUnRegisterRequest(unRegisterRequest, brokerAddrInfo);
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
        if (needUnRegister) {
            boolean result = this.submitUnRegisterBrokerRequest(unRegisterRequest);
            log.info("the broker's channel destroyed, submit the unregister request at once, broker info: {}, submit result: {}", (Object)unRegisterRequest, (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelDestroy(Channel channel) {
        UnRegisterBrokerRequestHeader unRegisterRequest = new UnRegisterBrokerRequestHeader();
        BrokerAddrInfo brokerAddrFound = null;
        boolean needUnRegister = false;
        if (channel != null) {
            try {
                try {
                    this.lock.readLock().lockInterruptibly();
                    for (Map.Entry<BrokerAddrInfo, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
                        if (entry.getValue().getChannel() != channel) continue;
                        brokerAddrFound = entry.getKey();
                        break;
                    }
                    if (brokerAddrFound != null) {
                        needUnRegister = this.setupUnRegisterRequest(unRegisterRequest, brokerAddrFound);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            catch (Exception e) {
                log.error("onChannelDestroy Exception", (Throwable)e);
            }
        }
        if (needUnRegister) {
            boolean result = this.submitUnRegisterBrokerRequest(unRegisterRequest);
            log.info("the broker's channel destroyed, submit the unregister request at once, broker info: {}, submit result: {}", (Object)unRegisterRequest, (Object)result);
        }
    }

    private boolean setupUnRegisterRequest(UnRegisterBrokerRequestHeader unRegisterRequest, BrokerAddrInfo brokerAddrInfo) {
        unRegisterRequest.setClusterName(brokerAddrInfo.getClusterName());
        unRegisterRequest.setBrokerAddr(brokerAddrInfo.getBrokerAddr());
        for (Map.Entry<String, BrokerData> stringBrokerDataEntry : this.brokerAddrTable.entrySet()) {
            BrokerData brokerData = stringBrokerDataEntry.getValue();
            if (!brokerAddrInfo.getClusterName().equals(brokerData.getCluster())) continue;
            for (Map.Entry entry : brokerData.getBrokerAddrs().entrySet()) {
                Long brokerId = (Long)entry.getKey();
                String brokerAddr = (String)entry.getValue();
                if (!brokerAddr.equals(brokerAddrInfo.getBrokerAddr())) continue;
                unRegisterRequest.setBrokerName(brokerData.getBrokerName());
                unRegisterRequest.setBrokerId(brokerId);
                return true;
            }
        }
        return false;
    }

    private void notifyMinBrokerIdChanged(Map<String, BrokerStatusChangeInfo> needNotifyBrokerMap) throws InterruptedException, RemotingConnectException, RemotingTimeoutException, RemotingSendRequestException, RemotingTooMuchRequestException {
        for (String brokerName : needNotifyBrokerMap.keySet()) {
            BrokerStatusChangeInfo brokerStatusChangeInfo = needNotifyBrokerMap.get(brokerName);
            BrokerData brokerData = this.brokerAddrTable.get(brokerName);
            if (brokerData == null || !brokerData.isEnableActingMaster()) continue;
            this.notifyMinBrokerIdChanged(brokerStatusChangeInfo.getBrokerAddrs(), brokerStatusChangeInfo.getOfflineBrokerAddr(), brokerStatusChangeInfo.getHaBrokerAddr());
        }
    }

    private void notifyMinBrokerIdChanged(Map<Long, String> brokerAddrMap, String offlineBrokerAddr, String haBrokerAddr) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException, RemotingTooMuchRequestException, RemotingConnectException {
        if (brokerAddrMap == null || brokerAddrMap.isEmpty() || this.namesrvController == null) {
            return;
        }
        NotifyMinBrokerIdChangeRequestHeader requestHeader = new NotifyMinBrokerIdChangeRequestHeader();
        long minBrokerId = Collections.min(brokerAddrMap.keySet());
        requestHeader.setMinBrokerId(Long.valueOf(minBrokerId));
        requestHeader.setMinBrokerAddr(brokerAddrMap.get(minBrokerId));
        requestHeader.setOfflineBrokerAddr(offlineBrokerAddr);
        requestHeader.setHaBrokerAddr(haBrokerAddr);
        List<String> brokerAddrsNotify = this.chooseBrokerAddrsToNotify(brokerAddrMap, offlineBrokerAddr);
        log.info("min broker id changed to {}, notify {}, offline broker addr {}", new Object[]{minBrokerId, brokerAddrsNotify, offlineBrokerAddr});
        RemotingCommand request = RemotingCommand.createRequestCommand((int)905, (CommandCustomHeader)requestHeader);
        for (String brokerAddr : brokerAddrsNotify) {
            this.namesrvController.getRemotingClient().invokeOneway(brokerAddr, request, 300L);
        }
    }

    private List<String> chooseBrokerAddrsToNotify(Map<Long, String> brokerAddrMap, String offlineBrokerAddr) {
        if (offlineBrokerAddr != null || brokerAddrMap.size() == 1) {
            return new ArrayList<String>(brokerAddrMap.values());
        }
        long minBrokerId = Collections.min(brokerAddrMap.keySet());
        ArrayList<String> brokerAddrList = new ArrayList<String>();
        for (Long brokerId : brokerAddrMap.keySet()) {
            if (brokerId == minBrokerId) continue;
            brokerAddrList.add(brokerAddrMap.get(brokerId));
        }
        return brokerAddrList;
    }

    public void printAllPeriodically() {
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                log.info("--------------------------------------------------------");
                log.info("topicQueueTable SIZE: {}", (Object)this.topicQueueTable.size());
                for (Map.Entry<String, Map<String, QueueData>> entry : this.topicQueueTable.entrySet()) {
                    log.info("topicQueueTable Topic: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerAddrTable SIZE: {}", (Object)this.brokerAddrTable.size());
                for (Map.Entry<String, Map<String, QueueData>> entry : this.brokerAddrTable.entrySet()) {
                    log.info("brokerAddrTable brokerName: {} {}", (Object)entry.getKey(), entry.getValue());
                }
                log.info("brokerLiveTable SIZE: {}", (Object)this.brokerLiveTable.size());
                for (Map.Entry<Object, Object> entry : this.brokerLiveTable.entrySet()) {
                    log.info("brokerLiveTable brokerAddr: {} {}", entry.getKey(), entry.getValue());
                }
                log.info("clusterAddrTable SIZE: {}", (Object)this.clusterAddrTable.size());
                for (Map.Entry<Object, Object> entry : this.clusterAddrTable.entrySet()) {
                    log.info("clusterAddrTable clusterName: {} {}", entry.getKey(), entry.getValue());
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("printAllPeriodically Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getSystemTopicList() {
        TopicList topicList;
        block7: {
            topicList = new TopicList();
            try {
                this.lock.readLock().lockInterruptibly();
                for (Map.Entry<String, Set<String>> entry : this.clusterAddrTable.entrySet()) {
                    topicList.getTopicList().add(entry.getKey());
                    topicList.getTopicList().addAll((Collection)entry.getValue());
                }
                if (this.brokerAddrTable.isEmpty()) break block7;
                for (String s : this.brokerAddrTable.keySet()) {
                    BrokerData bd = this.brokerAddrTable.get(s);
                    HashMap brokerAddrs = bd.getBrokerAddrs();
                    if (brokerAddrs == null || brokerAddrs.isEmpty()) continue;
                    Iterator it2 = brokerAddrs.keySet().iterator();
                    topicList.setBrokerAddr((String)brokerAddrs.get(it2.next()));
                    break;
                }
            }
            catch (Exception e) {
                log.error("getSystemTopicList Exception", (Throwable)e);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getTopicsByCluster(String cluster) {
        TopicList topicList = new TopicList();
        try {
            try {
                this.lock.readLock().lockInterruptibly();
                Set<String> brokerNameSet = this.clusterAddrTable.get(cluster);
                for (String brokerName : brokerNameSet) {
                    for (Map.Entry<String, Map<String, QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                        String topic = topicEntry.getKey();
                        Map<String, QueueData> queueDataMap = topicEntry.getValue();
                        QueueData qd = queueDataMap.get(brokerName);
                        if (qd == null) continue;
                        topicList.getTopicList().add(topic);
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (Exception e) {
            log.error("getTopicsByCluster Exception", (Throwable)e);
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getUnitTopics() {
        TopicList topicList = new TopicList();
        try {
            this.lock.readLock().lockInterruptibly();
            for (Map.Entry<String, Map<String, QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                String topic = topicEntry.getKey();
                Map<String, QueueData> queueDatas = topicEntry.getValue();
                if (queueDatas == null || queueDatas.size() <= 0 || !TopicSysFlag.hasUnitFlag((int)queueDatas.values().iterator().next().getTopicSysFlag())) continue;
                topicList.getTopicList().add(topic);
            }
        }
        catch (Exception e) {
            log.error("getUnitTopics Exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getHasUnitSubTopicList() {
        TopicList topicList = new TopicList();
        try {
            this.lock.readLock().lockInterruptibly();
            for (Map.Entry<String, Map<String, QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                String topic = topicEntry.getKey();
                Map<String, QueueData> queueDatas = topicEntry.getValue();
                if (queueDatas == null || queueDatas.size() <= 0 || !TopicSysFlag.hasUnitSubFlag((int)queueDatas.values().iterator().next().getTopicSysFlag())) continue;
                topicList.getTopicList().add(topic);
            }
        }
        catch (Exception e) {
            log.error("getHasUnitSubTopicList Exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return topicList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicList getHasUnitSubUnUnitTopicList() {
        TopicList topicList = new TopicList();
        try {
            this.lock.readLock().lockInterruptibly();
            for (Map.Entry<String, Map<String, QueueData>> topicEntry : this.topicQueueTable.entrySet()) {
                String topic = topicEntry.getKey();
                Map<String, QueueData> queueDatas = topicEntry.getValue();
                if (queueDatas == null || queueDatas.size() <= 0 || TopicSysFlag.hasUnitFlag((int)queueDatas.values().iterator().next().getTopicSysFlag()) || !TopicSysFlag.hasUnitSubFlag((int)queueDatas.values().iterator().next().getTopicSysFlag())) continue;
                topicList.getTopicList().add(topic);
            }
        }
        catch (Exception e) {
            log.error("getHasUnitSubUnUnitTopicList Exception", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return topicList;
    }
}

