/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.FileQueueLifeCycle;
import org.apache.rocketmq.store.queue.MultiDispatchUtils;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;
import org.apache.rocketmq.store.queue.ReferredIterator;

public class ConsumeQueue
implements ConsumeQueueInterface,
FileQueueLifeCycle {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int CQ_STORE_UNIT_SIZE = 20;
    public static final int MSG_TAG_OFFSET_INDEX = 12;
    private static final Logger LOG_ERROR = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private final MessageStore messageStore;
    private final MappedFileQueue mappedFileQueue;
    private final String topic;
    private final int queueId;
    private final ByteBuffer byteBufferIndex;
    private final String storePath;
    private final int mappedFileSize;
    private long maxPhysicOffset = -1L;
    private volatile long minLogicOffset = 0L;
    private ConsumeQueueExt consumeQueueExt = null;

    public ConsumeQueue(String topic, int queueId, String storePath, int mappedFileSize, MessageStore messageStore) {
        this.storePath = storePath;
        this.mappedFileSize = mappedFileSize;
        this.messageStore = messageStore;
        this.topic = topic;
        this.queueId = queueId;
        String queueDir = this.storePath + File.separator + topic + File.separator + queueId;
        this.mappedFileQueue = new MappedFileQueue(queueDir, mappedFileSize, null);
        this.byteBufferIndex = ByteBuffer.allocate(20);
        if (messageStore.getMessageStoreConfig().isEnableConsumeQueueExt()) {
            this.consumeQueueExt = new ConsumeQueueExt(topic, queueId, StorePathConfigHelper.getStorePathConsumeQueueExt(messageStore.getMessageStoreConfig().getStorePathRootDir()), messageStore.getMessageStoreConfig().getMappedFileSizeConsumeQueueExt(), messageStore.getMessageStoreConfig().getBitMapLengthConsumeQueueExt());
        }
    }

    @Override
    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        log.info("load consume queue " + this.topic + "-" + this.queueId + " " + (result ? "OK" : "Failed"));
        if (this.isExtReadEnable()) {
            result &= this.consumeQueueExt.load();
        }
        return result;
    }

    @Override
    public void recover() {
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long maxExtAddr;
            long mappedFileOffset;
            long processOffset;
            block7: {
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                int mappedFileSizeLogics = this.mappedFileSize;
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                maxExtAddr = 1L;
                while (true) {
                    for (int i = 0; i < mappedFileSizeLogics; i += 20) {
                        long offset = byteBuffer.getLong();
                        int size = byteBuffer.getInt();
                        long tagsCode = byteBuffer.getLong();
                        if (offset >= 0L && size > 0) {
                            mappedFileOffset = i + 20;
                            this.setMaxPhysicOffset(offset + (long)size);
                            if (!this.isExtAddr(tagsCode)) continue;
                            maxExtAddr = tagsCode;
                            continue;
                        }
                        log.info("recover current consume queue file over,  " + mappedFile.getFileName() + " " + offset + " " + size + " " + tagsCode);
                        break;
                    }
                    if (mappedFileOffset != (long)mappedFileSizeLogics) break;
                    if (++index >= mappedFiles.size()) {
                        log.info("recover last consume queue file over, last mapped file " + mappedFile.getFileName());
                        break block7;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("recover next consume queue file, " + mappedFile.getFileName());
                }
                log.info("recover current consume queue over " + mappedFile.getFileName() + " " + (processOffset + mappedFileOffset));
            }
            this.mappedFileQueue.setFlushedWhere(processOffset += mappedFileOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
            if (this.isExtReadEnable()) {
                this.consumeQueueExt.recover();
                log.info("Truncate consume queue extend file by max {}", (Object)maxExtAddr);
                this.consumeQueueExt.truncateByMaxAddress(maxExtAddr);
            }
        }
    }

    @Override
    public long getTotalSize() {
        long totalSize = this.mappedFileQueue.getTotalFileSize();
        if (this.isExtReadEnable()) {
            totalSize += this.consumeQueueExt.getTotalSize();
        }
        return totalSize;
    }

    @Override
    public int getUnitSize() {
        return 20;
    }

    @Override
    @Deprecated
    public long getOffsetInQueueByTime(long timestamp) {
        MappedFile mappedFile = this.mappedFileQueue.getConsumeQueueMappedFileByTime(timestamp, this.messageStore.getCommitLog(), BoundaryType.LOWER);
        return this.binarySearchInQueueByTime(mappedFile, timestamp, BoundaryType.LOWER);
    }

    @Override
    public long getOffsetInQueueByTime(long timestamp, BoundaryType boundaryType) {
        MappedFile mappedFile = this.mappedFileQueue.getConsumeQueueMappedFileByTime(timestamp, this.messageStore.getCommitLog(), boundaryType);
        return this.binarySearchInQueueByTime(mappedFile, timestamp, boundaryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long binarySearchInQueueByTime(MappedFile mappedFile, long timestamp, BoundaryType boundaryType) {
        if (mappedFile != null) {
            SelectMappedBufferResult sbr;
            long offset = 0L;
            int low = this.minLogicOffset > mappedFile.getFileFromOffset() ? (int)(this.minLogicOffset - mappedFile.getFileFromOffset()) : 0;
            int high = 0;
            int midOffset = -1;
            int targetOffset = -1;
            int leftOffset = -1;
            int rightOffset = -1;
            long minPhysicOffset = this.messageStore.getMinPhyOffset();
            int range = mappedFile.getFileSize();
            if (mappedFile.getWrotePosition() != 0 && mappedFile.getWrotePosition() != mappedFile.getFileSize()) {
                range = mappedFile.getWrotePosition();
            }
            if (null != (sbr = mappedFile.selectMappedBuffer(0, range))) {
                ByteBuffer byteBuffer = sbr.getByteBuffer();
                int ceiling = byteBuffer.limit() - 20;
                int floor = low;
                high = ceiling;
                try {
                    byteBuffer.position(ceiling);
                    long phyOffset = byteBuffer.getLong();
                    int size = byteBuffer.getInt();
                    long storeTime = this.messageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
                    if (storeTime < timestamp) {
                        switch (boundaryType) {
                            case LOWER: {
                                long l = (mappedFile.getFileFromOffset() + (long)ceiling + 20L) / 20L;
                                return l;
                            }
                            case UPPER: {
                                long l = (mappedFile.getFileFromOffset() + (long)ceiling) / 20L;
                                return l;
                            }
                        }
                        log.warn("Unknown boundary type");
                    }
                    byteBuffer.position(floor);
                    phyOffset = byteBuffer.getLong();
                    size = byteBuffer.getInt();
                    storeTime = this.messageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
                    if (storeTime > timestamp) {
                        switch (boundaryType) {
                            case LOWER: {
                                long l = mappedFile.getFileFromOffset() / 20L;
                                return l;
                            }
                            case UPPER: {
                                long l = 0L;
                                return l;
                            }
                        }
                        log.warn("Unknown boundary type");
                    }
                    while (high >= low) {
                        midOffset = (low + high) / 40 * 20;
                        byteBuffer.position(midOffset);
                        phyOffset = byteBuffer.getLong();
                        size = byteBuffer.getInt();
                        if (phyOffset < minPhysicOffset) {
                            low = midOffset + 20;
                            leftOffset = midOffset;
                            continue;
                        }
                        storeTime = this.messageStore.getCommitLog().pickupStoreTimestamp(phyOffset, size);
                        if (storeTime < 0L) {
                            log.warn("Failed to query store timestamp for commit log offset: {}", (Object)phyOffset);
                            long l = 0L;
                            return l;
                        }
                        if (storeTime == timestamp) {
                            targetOffset = midOffset;
                            break;
                        }
                        if (storeTime > timestamp) {
                            high = midOffset - 20;
                            rightOffset = midOffset;
                            continue;
                        }
                        low = midOffset + 20;
                        leftOffset = midOffset;
                    }
                    if (targetOffset != -1) {
                        offset = targetOffset;
                        switch (boundaryType) {
                            case LOWER: {
                                int attempt;
                                int previousAttempt = targetOffset;
                                while ((attempt = previousAttempt - 20) >= floor) {
                                    byteBuffer.position(attempt);
                                    long physicalOffset = byteBuffer.getLong();
                                    int messageSize = byteBuffer.getInt();
                                    long messageStoreTimestamp = this.messageStore.getCommitLog().pickupStoreTimestamp(physicalOffset, messageSize);
                                    if (messageStoreTimestamp != timestamp) break;
                                    previousAttempt = attempt;
                                }
                                offset = previousAttempt;
                                break;
                            }
                            case UPPER: {
                                int attempt;
                                int previousAttempt = targetOffset;
                                while ((attempt = previousAttempt + 20) <= ceiling) {
                                    byteBuffer.position(attempt);
                                    long physicalOffset = byteBuffer.getLong();
                                    int messageSize = byteBuffer.getInt();
                                    long messageStoreTimestamp = this.messageStore.getCommitLog().pickupStoreTimestamp(physicalOffset, messageSize);
                                    if (messageStoreTimestamp != timestamp) break;
                                    previousAttempt = attempt;
                                }
                                offset = previousAttempt;
                                break;
                            }
                            default: {
                                log.warn("Unknown boundary type");
                                break;
                            }
                        }
                    } else {
                        switch (boundaryType) {
                            case LOWER: {
                                offset = rightOffset;
                                break;
                            }
                            case UPPER: {
                                offset = leftOffset;
                                break;
                            }
                            default: {
                                log.warn("Unknown boundary type");
                            }
                        }
                    }
                    long l = (mappedFile.getFileFromOffset() + offset) / 20L;
                    return l;
                }
                finally {
                    sbr.release();
                }
            }
        }
        return 0L;
    }

    @Override
    public void truncateDirtyLogicFiles(long phyOffset) {
        this.truncateDirtyLogicFiles(phyOffset, true);
    }

    public void truncateDirtyLogicFiles(long phyOffset, boolean deleteFile) {
        MappedFile mappedFile;
        int logicFileSize = this.mappedFileSize;
        this.setMaxPhysicOffset(phyOffset);
        long maxExtAddr = 1L;
        boolean shouldDeleteFile = false;
        while ((mappedFile = this.mappedFileQueue.getLastMappedFile()) != null) {
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            mappedFile.setWrotePosition(0);
            mappedFile.setCommittedPosition(0);
            mappedFile.setFlushedPosition(0);
            for (int i = 0; i < logicFileSize; i += 20) {
                int pos;
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                long tagsCode = byteBuffer.getLong();
                if (0 == i) {
                    if (offset >= phyOffset) {
                        shouldDeleteFile = true;
                        break;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.setMaxPhysicOffset(offset + (long)size);
                    if (!this.isExtAddr(tagsCode)) continue;
                    maxExtAddr = tagsCode;
                    continue;
                }
                if (offset >= 0L && size > 0) {
                    if (offset >= phyOffset) {
                        return;
                    }
                    pos = i + 20;
                    mappedFile.setWrotePosition(pos);
                    mappedFile.setCommittedPosition(pos);
                    mappedFile.setFlushedPosition(pos);
                    this.setMaxPhysicOffset(offset + (long)size);
                    if (this.isExtAddr(tagsCode)) {
                        maxExtAddr = tagsCode;
                    }
                    if (pos != logicFileSize) continue;
                    return;
                }
                return;
            }
            if (!shouldDeleteFile) continue;
            if (deleteFile) {
                this.mappedFileQueue.deleteLastMappedFile();
                continue;
            }
            this.mappedFileQueue.deleteExpiredFile(Collections.singletonList(this.mappedFileQueue.getLastMappedFile()));
        }
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.truncateByMaxAddress(maxExtAddr);
        }
    }

    @Override
    public long getLastOffset() {
        long lastOffset = -1L;
        int logicFileSize = this.mappedFileSize;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        if (mappedFile != null) {
            int position = mappedFile.getWrotePosition() - 20;
            if (position < 0) {
                position = 0;
            }
            ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
            byteBuffer.position(position);
            for (int i = 0; i < logicFileSize; i += 20) {
                long offset = byteBuffer.getLong();
                int size = byteBuffer.getInt();
                byteBuffer.getLong();
                if (offset < 0L || size <= 0) break;
                lastOffset = offset + (long)size;
            }
        }
        return lastOffset;
    }

    @Override
    public boolean flush(int flushLeastPages) {
        boolean result = this.mappedFileQueue.flush(flushLeastPages);
        if (this.isExtReadEnable()) {
            result &= this.consumeQueueExt.flush(flushLeastPages);
        }
        return result;
    }

    @Override
    public int deleteExpiredFile(long offset) {
        int cnt = this.mappedFileQueue.deleteExpiredFileByOffset(offset, 20);
        this.correctMinOffset(offset);
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void correctMinOffset(long minCommitLogOffset) {
        if (this.minLogicOffset >= this.mappedFileQueue.getMaxOffset()) {
            log.info("ConsumeQueue[Topic={}, queue-id={}] contains no valid entries", (Object)this.topic, (Object)this.queueId);
            return;
        }
        MappedFile lastMappedFile = this.mappedFileQueue.getLastMappedFile();
        if (null == lastMappedFile) {
            return;
        }
        SelectMappedBufferResult lastRecord = null;
        try {
            ByteBuffer buffer;
            long commitLogOffset;
            int maxReadablePosition = lastMappedFile.getReadPosition();
            lastRecord = lastMappedFile.selectMappedBuffer(maxReadablePosition - 20, 20);
            if (null != lastRecord && (commitLogOffset = (buffer = lastRecord.getByteBuffer()).getLong()) < minCommitLogOffset) {
                this.minLogicOffset = lastMappedFile.getFileFromOffset() + (long)maxReadablePosition;
                log.info("ConsumeQueue[topic={}, queue-id={}] contains no valid entries. Min-offset is assigned as: {}.", new Object[]{this.topic, this.queueId, this.getMinOffsetInQueue()});
                return;
            }
        }
        finally {
            if (null != lastRecord) {
                lastRecord.release();
            }
        }
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        long minExtAddr = 1L;
        if (mappedFile != null) {
            boolean intact = true;
            long start = this.minLogicOffset - mappedFile.getFileFromOffset();
            if (start < 0L) {
                intact = false;
                start = 0L;
            }
            if (start > (long)mappedFile.getReadPosition()) {
                log.error("[Bug][InconsistentState] ConsumeQueue file {} should have been deleted", (Object)mappedFile.getFileName());
                return;
            }
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer((int)start);
            if (result == null) {
                log.warn("[Bug] Failed to scan consume queue entries from file on correcting min offset: {}", (Object)mappedFile.getFileName());
                return;
            }
            try {
                if (result.getSize() == 0) {
                    log.debug("ConsumeQueue[topic={}, queue-id={}] contains no valid entries", (Object)this.topic, (Object)this.queueId);
                    return;
                }
                ByteBuffer buffer = result.getByteBuffer().slice();
                long commitLogOffset = buffer.getLong();
                if (intact && commitLogOffset >= minCommitLogOffset) {
                    log.info("Abort correction as previous min-offset points to {}, which is greater than {}", (Object)commitLogOffset, (Object)minCommitLogOffset);
                    return;
                }
                int low = 0;
                int high = result.getSize() - 20;
                while (high - low > 20) {
                    int mid = (low + high) / 2 / 20 * 20;
                    buffer.position(mid);
                    commitLogOffset = buffer.getLong();
                    if (commitLogOffset > minCommitLogOffset) {
                        high = mid;
                        continue;
                    }
                    if (commitLogOffset == minCommitLogOffset) {
                        low = mid;
                        high = mid;
                        break;
                    }
                    low = mid;
                }
                for (int i = low; i <= high; i += 20) {
                    buffer.position(i);
                    long offsetPy = buffer.getLong();
                    buffer.position(i + 12);
                    long tagsCode = buffer.getLong();
                    if (offsetPy < minCommitLogOffset) continue;
                    this.minLogicOffset = mappedFile.getFileFromOffset() + start + (long)i;
                    log.info("Compute logical min offset: {}, topic: {}, queueId: {}", new Object[]{this.getMinOffsetInQueue(), this.topic, this.queueId});
                    if (this.isExtAddr(tagsCode)) {
                        minExtAddr = tagsCode;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Exception thrown when correctMinOffset", (Throwable)e);
            }
            finally {
                result.release();
            }
        }
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.truncateByMinAddress(minExtAddr);
        }
    }

    @Override
    public long getMinOffsetInQueue() {
        return this.minLogicOffset / 20L;
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) {
        int maxRetries = 30;
        boolean canWrite = this.messageStore.getRunningFlags().isCQWriteable();
        for (int i = 0; i < 30 && canWrite; ++i) {
            boolean result;
            long tagsCode = request.getTagsCode();
            if (this.isExtWriteEnable()) {
                ConsumeQueueExt.CqExtUnit cqExtUnit = new ConsumeQueueExt.CqExtUnit();
                cqExtUnit.setFilterBitMap(request.getBitMap());
                cqExtUnit.setMsgStoreTime(request.getStoreTimestamp());
                cqExtUnit.setTagsCode(request.getTagsCode());
                long extAddr = this.consumeQueueExt.put(cqExtUnit);
                if (this.isExtAddr(extAddr)) {
                    tagsCode = extAddr;
                } else {
                    log.warn("Save consume queue extend fail, So just save tagsCode! {}, topic:{}, queueId:{}, offset:{}", new Object[]{cqExtUnit, this.topic, this.queueId, request.getCommitLogOffset()});
                }
            }
            if (result = this.putMessagePositionInfo(request.getCommitLogOffset(), request.getMsgSize(), tagsCode, request.getConsumeQueueOffset())) {
                if (this.messageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE || this.messageStore.getMessageStoreConfig().isEnableDLegerCommitLog()) {
                    this.messageStore.getStoreCheckpoint().setPhysicMsgTimestamp(request.getStoreTimestamp());
                }
                this.messageStore.getStoreCheckpoint().setLogicsMsgTimestamp(request.getStoreTimestamp());
                if (MultiDispatchUtils.checkMultiDispatchQueue(this.messageStore.getMessageStoreConfig(), request)) {
                    this.multiDispatchLmqQueue(request, 30);
                }
                return;
            }
            log.warn("[BUG]put commit log position info to " + this.topic + ":" + this.queueId + " " + request.getCommitLogOffset() + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
        log.error("[BUG]consume queue can not write, {} {}", (Object)this.topic, (Object)this.queueId);
        this.messageStore.getRunningFlags().makeLogicsQueueError();
    }

    private void multiDispatchLmqQueue(DispatchRequest request, int maxRetries) {
        String[] queueOffsets;
        Map<String, String> prop = request.getPropertiesMap();
        String multiDispatchQueue = prop.get("INNER_MULTI_DISPATCH");
        String multiQueueOffset = prop.get("INNER_MULTI_QUEUE_OFFSET");
        String[] queues = multiDispatchQueue.split(",");
        if (queues.length != (queueOffsets = multiQueueOffset.split(",")).length) {
            log.error("[bug] queues.length!=queueOffsets.length ", (Object)request.getTopic());
            return;
        }
        for (int i = 0; i < queues.length; ++i) {
            String queueName = queues[i];
            if (StringUtils.contains((CharSequence)queueName, (CharSequence)File.separator)) continue;
            long queueOffset = Long.parseLong(queueOffsets[i]);
            int queueId = request.getQueueId();
            if (this.messageStore.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)queueName)) {
                queueId = 0;
            }
            this.doDispatchLmqQueue(request, maxRetries, queueName, queueOffset, queueId);
        }
    }

    private void doDispatchLmqQueue(DispatchRequest request, int maxRetries, String queueName, long queueOffset, int queueId) {
        boolean result;
        ConsumeQueueInterface cq = this.messageStore.findConsumeQueue(queueName, queueId);
        boolean canWrite = this.messageStore.getRunningFlags().isCQWriteable();
        for (int i = 0; i < maxRetries && canWrite && !(result = ((ConsumeQueue)cq).putMessagePositionInfo(request.getCommitLogOffset(), request.getMsgSize(), request.getTagsCode(), queueOffset)); ++i) {
            log.warn("[BUG]put commit log position info to " + queueName + ":" + queueId + " " + request.getCommitLogOffset() + " failed, retry " + i + " times");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("", (Throwable)e);
            }
        }
    }

    @Override
    public void assignQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        long queueOffset = queueOffsetOperator.getQueueOffset(topicQueueKey);
        msg.setQueueOffset(queueOffset);
    }

    @Override
    public void increaseQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg, short messageNum) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        queueOffsetOperator.increaseQueueOffset(topicQueueKey, messageNum);
    }

    private boolean putMessagePositionInfo(long offset, int size, long tagsCode, long cqOffset) {
        if (offset + (long)size <= this.getMaxPhysicOffset()) {
            log.warn("Maybe try to build consume queue repeatedly maxPhysicOffset={} phyOffset={}", (Object)this.getMaxPhysicOffset(), (Object)offset);
            return true;
        }
        this.byteBufferIndex.flip();
        this.byteBufferIndex.limit(20);
        this.byteBufferIndex.putLong(offset);
        this.byteBufferIndex.putInt(size);
        this.byteBufferIndex.putLong(tagsCode);
        long expectLogicOffset = cqOffset * 20L;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(expectLogicOffset);
        if (mappedFile != null) {
            if (mappedFile.isFirstCreateInQueue() && cqOffset != 0L && mappedFile.getWrotePosition() == 0) {
                this.minLogicOffset = expectLogicOffset;
                this.mappedFileQueue.setFlushedWhere(expectLogicOffset);
                this.mappedFileQueue.setCommittedWhere(expectLogicOffset);
                this.fillPreBlank(mappedFile, expectLogicOffset);
                log.info("fill pre blank space " + mappedFile.getFileName() + " " + expectLogicOffset + " " + mappedFile.getWrotePosition());
            }
            if (cqOffset != 0L) {
                long currentLogicOffset = (long)mappedFile.getWrotePosition() + mappedFile.getFileFromOffset();
                if (expectLogicOffset < currentLogicOffset) {
                    log.warn("Build  consume queue repeatedly, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
                    return true;
                }
                if (expectLogicOffset != currentLogicOffset) {
                    LOG_ERROR.warn("[BUG]logic queue order maybe wrong, expectLogicOffset: {} currentLogicOffset: {} Topic: {} QID: {} Diff: {}", new Object[]{expectLogicOffset, currentLogicOffset, this.topic, this.queueId, expectLogicOffset - currentLogicOffset});
                }
            }
            this.setMaxPhysicOffset(offset + (long)size);
            return mappedFile.appendMessage(this.byteBufferIndex.array());
        }
        return false;
    }

    private void fillPreBlank(MappedFile mappedFile, long untilWhere) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putLong(0L);
        byteBuffer.putInt(Integer.MAX_VALUE);
        byteBuffer.putLong(0L);
        int until = (int)(untilWhere % (long)this.mappedFileQueue.getMappedFileSize());
        for (int i = 0; i < until; i += 20) {
            mappedFile.appendMessage(byteBuffer.array());
        }
    }

    public SelectMappedBufferResult getIndexBuffer(long startIndex) {
        MappedFile mappedFile;
        int mappedFileSize = this.mappedFileSize;
        long offset = startIndex * 20L;
        if (offset >= this.getMinLogicOffset() && (mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset)) != null) {
            return mappedFile.selectMappedBuffer((int)(offset % (long)mappedFileSize));
        }
        return null;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startOffset) {
        SelectMappedBufferResult sbr = this.getIndexBuffer(startOffset);
        if (sbr == null) {
            return null;
        }
        return new ConsumeQueueIterator(sbr);
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startIndex, int count) {
        return this.iterateFrom(startIndex);
    }

    @Override
    public CqUnit get(long offset) {
        ReferredIterator<CqUnit> it = this.iterateFrom(offset);
        if (it == null) {
            return null;
        }
        return it.nextAndRelease();
    }

    @Override
    public Pair<CqUnit, Long> getCqUnitAndStoreTime(long index) {
        CqUnit cqUnit = this.get(index);
        Long messageStoreTime = this.messageStore.getQueueStore().getStoreTime(cqUnit);
        return new Pair((Object)cqUnit, (Object)messageStoreTime);
    }

    @Override
    public Pair<CqUnit, Long> getEarliestUnitAndStoreTime() {
        CqUnit cqUnit = this.getEarliestUnit();
        Long messageStoreTime = this.messageStore.getQueueStore().getStoreTime(cqUnit);
        return new Pair((Object)cqUnit, (Object)messageStoreTime);
    }

    @Override
    public CqUnit getEarliestUnit() {
        ReferredIterator<CqUnit> it = this.iterateFrom(this.minLogicOffset / 20L);
        if (it == null) {
            return null;
        }
        return it.nextAndRelease();
    }

    @Override
    public CqUnit getLatestUnit() {
        ReferredIterator<CqUnit> it = this.iterateFrom(this.mappedFileQueue.getMaxOffset() / 20L - 1L);
        if (it == null) {
            return null;
        }
        return it.nextAndRelease();
    }

    @Override
    public boolean isFirstFileAvailable() {
        return false;
    }

    @Override
    public boolean isFirstFileExist() {
        return false;
    }

    public ConsumeQueueExt.CqExtUnit getExt(long offset) {
        if (this.isExtReadEnable()) {
            return this.consumeQueueExt.get(offset);
        }
        return null;
    }

    public boolean getExt(long offset, ConsumeQueueExt.CqExtUnit cqExtUnit) {
        if (this.isExtReadEnable()) {
            return this.consumeQueueExt.get(offset, cqExtUnit);
        }
        return false;
    }

    @Override
    public long getMinLogicOffset() {
        return this.minLogicOffset;
    }

    public void setMinLogicOffset(long minLogicOffset) {
        this.minLogicOffset = minLogicOffset;
    }

    @Override
    public long rollNextFile(long nextBeginOffset) {
        int mappedFileSize = this.mappedFileSize;
        int totalUnitsInFile = mappedFileSize / 20;
        return nextBeginOffset + (long)totalUnitsInFile - nextBeginOffset % (long)totalUnitsInFile;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getQueueId() {
        return this.queueId;
    }

    @Override
    public CQType getCQType() {
        return CQType.SimpleCQ;
    }

    @Override
    public long getMaxPhysicOffset() {
        return this.maxPhysicOffset;
    }

    public void setMaxPhysicOffset(long maxPhysicOffset) {
        this.maxPhysicOffset = maxPhysicOffset;
    }

    @Override
    public void destroy() {
        this.setMaxPhysicOffset(-1L);
        this.minLogicOffset = 0L;
        this.mappedFileQueue.destroy();
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.destroy();
        }
    }

    @Override
    public long getMessageTotalInQueue() {
        return this.getMaxOffsetInQueue() - this.getMinOffsetInQueue();
    }

    @Override
    public long getMaxOffsetInQueue() {
        return this.mappedFileQueue.getMaxOffset() / 20L;
    }

    @Override
    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
        if (this.isExtReadEnable()) {
            this.consumeQueueExt.checkSelf();
        }
    }

    protected boolean isExtReadEnable() {
        return this.consumeQueueExt != null;
    }

    protected boolean isExtWriteEnable() {
        return this.consumeQueueExt != null && this.messageStore.getMessageStoreConfig().isEnableConsumeQueueExt();
    }

    public boolean isExtAddr(long tagsCode) {
        return ConsumeQueueExt.isExtAddr(tagsCode);
    }

    @Override
    public void swapMap(int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
        this.mappedFileQueue.swapMap(reserveNum, forceSwapIntervalMs, normalSwapIntervalMs);
    }

    @Override
    public void cleanSwappedMap(long forceCleanSwapIntervalMs) {
        this.mappedFileQueue.cleanSwappedMap(forceCleanSwapIntervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long estimateMessageCount(long from, long to, MessageFilter filter) {
        long physicalOffsetFrom = from * 20L;
        long physicalOffsetTo = to * 20L;
        List<MappedFile> mappedFiles = this.mappedFileQueue.range(physicalOffsetFrom, physicalOffsetTo);
        if (mappedFiles.isEmpty()) {
            return -1L;
        }
        boolean sample = false;
        long match = 0L;
        long raw = 0L;
        for (MappedFile mappedFile : mappedFiles) {
            SelectMappedBufferResult slice;
            int start = 0;
            int len = mappedFile.getFileSize();
            if (mappedFile.getFileFromOffset() <= physicalOffsetFrom) {
                start = (int)(physicalOffsetFrom - mappedFile.getFileFromOffset());
                len = mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize() >= physicalOffsetTo ? (int)(physicalOffsetTo - physicalOffsetFrom) : mappedFile.getFileSize() - start;
            }
            if (0 == start && mappedFile.getFileFromOffset() + (long)mappedFile.getFileSize() > physicalOffsetTo) {
                len = (int)(physicalOffsetTo - mappedFile.getFileFromOffset());
            }
            if (null != (slice = mappedFile.selectMappedBuffer(start, len))) {
                try {
                    ByteBuffer buffer = slice.getByteBuffer();
                    for (int current = 0; current < len; current += 20) {
                        buffer.position(current + 12);
                        long tagCode = buffer.getLong();
                        ConsumeQueueExt.CqExtUnit ext = null;
                        if (this.isExtWriteEnable()) {
                            ext = this.consumeQueueExt.get(tagCode);
                            tagCode = ext.getTagsCode();
                        }
                        if (filter.isMatchedByConsumeQueue(tagCode, ext)) {
                            ++match;
                        }
                        if (++raw < (long)this.messageStore.getMessageStoreConfig().getMaxConsumeQueueScan()) continue;
                        sample = true;
                        break;
                    }
                }
                finally {
                    slice.release();
                }
            }
            if (!sample) continue;
            break;
        }
        long result = match;
        if (sample) {
            if (0L == raw) {
                log.error("[BUG]. Raw should NOT be 0");
                return 0L;
            }
            result = (long)((double)(match * (to - from)) * 1.0 / (double)raw);
        }
        log.debug("Result={}, raw={}, match={}, sample={}", new Object[]{result, raw, match, sample});
        return result;
    }

    private class ConsumeQueueIterator
    implements ReferredIterator<CqUnit> {
        private SelectMappedBufferResult sbr;
        private int relativePos = 0;

        public ConsumeQueueIterator(SelectMappedBufferResult sbr) {
            this.sbr = sbr;
            if (sbr != null && sbr.getByteBuffer() != null) {
                this.relativePos = sbr.getByteBuffer().position();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.sbr == null || this.sbr.getByteBuffer() == null) {
                return false;
            }
            return this.sbr.getByteBuffer().hasRemaining();
        }

        @Override
        public CqUnit next() {
            if (!this.hasNext()) {
                return null;
            }
            long queueOffset = (this.sbr.getStartOffset() + (long)this.sbr.getByteBuffer().position() - (long)this.relativePos) / 20L;
            CqUnit cqUnit = new CqUnit(queueOffset, this.sbr.getByteBuffer().getLong(), this.sbr.getByteBuffer().getInt(), this.sbr.getByteBuffer().getLong());
            if (ConsumeQueue.this.isExtAddr(cqUnit.getTagsCode())) {
                ConsumeQueueExt.CqExtUnit cqExtUnit = new ConsumeQueueExt.CqExtUnit();
                boolean extRet = ConsumeQueue.this.getExt(cqUnit.getTagsCode(), cqExtUnit);
                if (extRet) {
                    cqUnit.setTagsCode(cqExtUnit.getTagsCode());
                    cqUnit.setCqExtUnit(cqExtUnit);
                } else {
                    log.error("[BUG] can't find consume queue extend file content! addr={}, offsetPy={}, sizePy={}, topic={}", new Object[]{cqUnit.getTagsCode(), cqUnit.getPos(), cqUnit.getPos(), ConsumeQueue.this.getTopic()});
                }
            }
            return cqUnit;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void release() {
            if (this.sbr != null) {
                this.sbr.release();
                this.sbr = null;
            }
        }

        @Override
        public CqUnit nextAndRelease() {
            try {
                CqUnit cqUnit = this.next();
                return cqUnit;
            }
            finally {
                this.release();
            }
        }
    }
}

