/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.evolve;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutation;
import com.sleepycat.persist.evolve.Renamer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Mutations
implements Serializable {
    private static final long serialVersionUID = -1744401530444812916L;
    private Map<Mutation, Renamer> renamers = new HashMap<Mutation, Renamer>();
    private Map<Mutation, Deleter> deleters = new HashMap<Mutation, Deleter>();
    private Map<Mutation, Converter> converters = new HashMap<Mutation, Converter>();

    public boolean isEmpty() {
        return this.renamers.isEmpty() && this.deleters.isEmpty() && this.converters.isEmpty();
    }

    public void addRenamer(Renamer renamer) {
        this.renamers.put(new Key(renamer), renamer);
    }

    public Renamer getRenamer(String className, int classVersion, String fieldName) {
        return this.renamers.get(new Key(className, classVersion, fieldName));
    }

    public Collection<Renamer> getRenamers() {
        return this.renamers.values();
    }

    public void addDeleter(Deleter deleter) {
        this.deleters.put(new Key(deleter), deleter);
    }

    public Deleter getDeleter(String className, int classVersion, String fieldName) {
        return this.deleters.get(new Key(className, classVersion, fieldName));
    }

    public Collection<Deleter> getDeleters() {
        return this.deleters.values();
    }

    public void addConverter(Converter converter) {
        this.converters.put(new Key(converter), converter);
    }

    public Converter getConverter(String className, int classVersion, String fieldName) {
        return this.converters.get(new Key(className, classVersion, fieldName));
    }

    public Collection<Converter> getConverters() {
        return this.converters.values();
    }

    public boolean equals(Object other) {
        if (other instanceof Mutations) {
            Mutations o = (Mutations)other;
            return this.renamers.equals(o.renamers) && this.deleters.equals(o.deleters) && this.converters.equals(o.converters);
        }
        return false;
    }

    public int hashCode() {
        return this.renamers.hashCode() + this.deleters.hashCode() + this.converters.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.renamers.size() > 0) {
            buf.append(this.renamers.values());
        }
        if (this.deleters.size() > 0) {
            buf.append(this.deleters.values());
        }
        if (this.converters.size() > 0) {
            buf.append(this.converters.values());
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return "[Empty Mutations]";
    }

    private static class Key
    extends Mutation {
        static final long serialVersionUID = 2793516787097085621L;

        Key(String className, int classVersion, String fieldName) {
            super(className, classVersion, fieldName);
        }

        Key(Mutation mutation) {
            super(mutation.getClassName(), mutation.getClassVersion(), mutation.getFieldName());
        }
    }
}

