/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.tenants;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.TenantsClient;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;

public class UpdateUserGroup
extends AbstractNiFiCommand<VoidResult> {
    public UpdateUserGroup() {
        super("update-user-group", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates a user group.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.UG_NAME.createOption());
        this.addOption(CommandOption.UG_ID.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        UserGroupEntity existingGroup;
        TenantsClient tenantsClient = client.getTenantsClient();
        String group = this.getArg(properties, CommandOption.UG_NAME);
        String groupId = this.getArg(properties, CommandOption.UG_ID);
        if (StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)groupId) || StringUtils.isNotBlank((CharSequence)group) && StringUtils.isNotBlank((CharSequence)groupId)) {
            throw new CommandException("Specify either \"" + CommandOption.UG_NAME.getLongName() + "\" or \"" + CommandOption.UG_ID.getLongName() + "\" (not both)");
        }
        if (StringUtils.isNotBlank((CharSequence)group)) {
            Optional<UserGroupEntity> existingGroupEntity = tenantsClient.getUserGroups().getUserGroups().stream().filter(userGroupEntity -> group.equals(userGroupEntity.getComponent().getIdentity())).findAny();
            if (!existingGroupEntity.isPresent()) {
                throw new CommandException("User group does not exist for identity \"" + group + "\"");
            }
            existingGroup = existingGroupEntity.get();
        } else {
            existingGroup = tenantsClient.getUserGroup(groupId);
        }
        String users = this.getArg(properties, CommandOption.USER_NAME_LIST);
        String userIds = this.getArg(properties, CommandOption.USER_ID_LIST);
        HashSet<TenantEntity> tenantEntities = new HashSet<TenantEntity>();
        if (StringUtils.isNotBlank((CharSequence)users)) {
            tenantEntities.addAll(UpdateUserGroup.generateTenantEntities(users, client.getTenantsClient().getUsers()));
        }
        if (StringUtils.isNotBlank((CharSequence)userIds)) {
            tenantEntities.addAll(UpdateUserGroup.generateTenantEntities(userIds));
        }
        existingGroup.getComponent().setUsers(tenantEntities);
        String clientId = this.getContext().getSession().getNiFiClientID();
        existingGroup.getRevision().setClientId(clientId);
        tenantsClient.updateUserGroup(existingGroup);
        return VoidResult.getInstance();
    }
}

