/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class InstantCastEvaluator
extends InstantEvaluator {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private final Evaluator<?> subjectEvaluator;

    public InstantCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + String.valueOf(subjectEvaluator.getResultType()) + " to " + String.valueOf(AttributeExpression.ResultType.INSTANT));
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Instant> evaluate(EvaluationContext evaluationContext) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(evaluationContext);
        if (result.getValue() == null) {
            return new InstantQueryResult(null);
        }
        switch (result.getResultType()) {
            case INSTANT: {
                return (InstantQueryResult)result;
            }
            case STRING: {
                String value = ((StringQueryResult)result).getValue().trim();
                if (NUMBER_PATTERN.matcher(value).matches()) {
                    return new InstantQueryResult(Instant.ofEpochMilli(Long.parseLong(value)));
                }
                DateTimeFormatter dtf = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ISO_INSTANT).appendOptional(DateTimeFormatter.ISO_OFFSET_DATE_TIME).appendOptional(DateTimeFormatter.RFC_1123_DATE_TIME).toFormatter();
                try {
                    Instant instant = dtf.parse((CharSequence)value, Instant::from);
                    return new InstantQueryResult(instant);
                }
                catch (DateTimeParseException e) {
                    throw new AttributeExpressionLanguageException("Could not implicitly convert input to INSTANT: " + value);
                }
            }
            case WHOLE_NUMBER: {
                return new InstantQueryResult(Instant.ofEpochMilli((Long)result.getValue()));
            }
            case DECIMAL: {
                Double resultDouble = (Double)result.getValue();
                return new InstantQueryResult(Instant.ofEpochMilli(resultDouble.longValue()));
            }
            case NUMBER: {
                Number numberValue = ((NumberQueryResult)result).getValue();
                return new InstantQueryResult(Instant.ofEpochMilli(numberValue.longValue()));
            }
        }
        return new InstantQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

