/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Order(value=-2147483608)
class OnPropertyCondition
extends SpringBootCondition {
    OnPropertyCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotations mergedAnnotations = metadata.getAnnotations();
        List<MergedAnnotation<Annotation>> annotations = this.stream(mergedAnnotations).toList();
        ArrayList noMatch = new ArrayList();
        ArrayList<ConditionMessage> match = new ArrayList<ConditionMessage>();
        for (MergedAnnotation<Annotation> annotation : annotations) {
            ConditionOutcome outcome = this.determineOutcome(annotation, (PropertyResolver)context.getEnvironment());
            (outcome.isMatch() ? match : noMatch).add(outcome.getConditionMessage());
        }
        if (!noMatch.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.of(noMatch));
        }
        return ConditionOutcome.match(ConditionMessage.of(match));
    }

    private Stream<MergedAnnotation<Annotation>> stream(MergedAnnotations mergedAnnotations) {
        return Stream.concat(this.stream(mergedAnnotations, ConditionalOnProperty.class, ConditionalOnProperties.class), this.stream(mergedAnnotations, ConditionalOnBooleanProperty.class, ConditionalOnBooleanProperties.class));
    }

    private Stream<MergedAnnotation<Annotation>> stream(MergedAnnotations mergedAnnotations, Class<? extends Annotation> type, Class<? extends Annotation> containerType) {
        return Stream.concat(this.stream(mergedAnnotations, type), this.streamRepeated(mergedAnnotations, type, containerType));
    }

    private Stream<MergedAnnotation<Annotation>> streamRepeated(MergedAnnotations mergedAnnotations, Class<? extends Annotation> type, Class<? extends Annotation> containerType) {
        return this.stream(mergedAnnotations, containerType).flatMap(container -> this.streamRepeated((MergedAnnotation<Annotation>)container, type));
    }

    private Stream<MergedAnnotation<Annotation>> streamRepeated(MergedAnnotation<Annotation> container, Class<? extends Annotation> type) {
        MergedAnnotation[] repeated = container.getAnnotationArray("value", type);
        return Arrays.stream(repeated);
    }

    private Stream<MergedAnnotation<Annotation>> stream(MergedAnnotations annotations, Class<? extends Annotation> type) {
        return annotations.stream(type.getName()).filter(MergedAnnotationPredicates.unique(MergedAnnotation::getMetaTypes));
    }

    private ConditionOutcome determineOutcome(MergedAnnotation<Annotation> annotation, PropertyResolver resolver) {
        Class annotationType = annotation.getType();
        Spec spec = new Spec(annotationType, annotation.asAnnotationAttributes(new MergedAnnotation.Adapt[0]));
        ArrayList<String> missingProperties = new ArrayList<String>();
        ArrayList<String> nonMatchingProperties = new ArrayList<String>();
        spec.collectProperties(resolver, missingProperties, nonMatchingProperties);
        if (!missingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(annotationType, spec).didNotFind("property", "properties").items(ConditionMessage.Style.QUOTE, missingProperties));
        }
        if (!nonMatchingProperties.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(annotationType, spec).found("different value in property", "different value in properties").items(ConditionMessage.Style.QUOTE, nonMatchingProperties));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(annotationType, spec).because("matched"));
    }

    private static class Spec {
        private final Class<? extends Annotation> annotationType;
        private final String prefix;
        private final String[] names;
        private final String havingValue;
        private final boolean matchIfMissing;

        Spec(Class<? extends Annotation> annotationType, AnnotationAttributes annotationAttributes) {
            this.annotationType = annotationType;
            this.prefix = !annotationAttributes.containsKey((Object)"prefix") ? "" : this.getPrefix(annotationAttributes);
            this.names = this.getNames(annotationAttributes);
            this.havingValue = annotationAttributes.get((Object)"havingValue").toString();
            this.matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        }

        private String getPrefix(AnnotationAttributes annotationAttributes) {
            Object prefix = annotationAttributes.getString("prefix").trim();
            if (StringUtils.hasText((String)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            return prefix;
        }

        private String[] getNames(AnnotationAttributes annotationAttributes) {
            String[] value = (String[])annotationAttributes.get((Object)"value");
            String[] name = (String[])annotationAttributes.get((Object)"name");
            Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, () -> "The name or value attribute of @%s must be specified".formatted(ClassUtils.getShortName(this.annotationType)));
            Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, () -> "The name and value attributes of @%s are exclusive".formatted(ClassUtils.getShortName(this.annotationType)));
            return value.length > 0 ? value : name;
        }

        private void collectProperties(PropertyResolver resolver, List<String> missing, List<String> nonMatching) {
            for (String name : this.names) {
                String key = this.prefix + name;
                if (resolver.containsProperty(key)) {
                    if (this.isMatch(resolver.getProperty(key), this.havingValue)) continue;
                    nonMatching.add(name);
                    continue;
                }
                if (this.matchIfMissing) continue;
                missing.add(name);
            }
        }

        private boolean isMatch(String value, String requiredValue) {
            if (StringUtils.hasLength((String)requiredValue)) {
                return requiredValue.equalsIgnoreCase(value);
            }
            return !"false".equalsIgnoreCase(value);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            result.append(this.prefix);
            if (this.names.length == 1) {
                result.append(this.names[0]);
            } else {
                result.append("[");
                result.append(StringUtils.arrayToCommaDelimitedString((Object[])this.names));
                result.append("]");
            }
            if (StringUtils.hasLength((String)this.havingValue)) {
                result.append("=").append(this.havingValue);
            }
            result.append(")");
            return result.toString();
        }
    }
}

