/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.SkinResourceLoader;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidad.skin.CustomMetadata;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinProvider;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.share.xml.ClassParserFactory;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.skin.SkinExtension;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetEntry;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinsNode;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;
import org.xml.sax.InputSource;

public class SkinUtils {
    private static ParserManager _sManager;
    private static final String _LAF_PARSE_PACKAGE = "org.apache.myfaces.trinidadinternal.skin.parse.";
    private static final String _CONFIG_FILE = "/WEB-INF/trinidad-skins.xml";
    private static final String _META_INF_CONFIG_FILE = "META-INF/trinidad-skins.xml";
    private static final String _TRINIDAD_SKINS_XML = "trinidad-skins.xml";
    private static final TrinidadLogger _LOG;

    public static FacesContext getNonNullFacesContext(FacesContext context) {
        if (context != null) {
            return context;
        }
        context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new NullPointerException("FacesContext is null. Cannot retrieve default FacesContext");
        }
        return context;
    }

    public static Skin getDefaultSkinForRenderKitId(SkinProvider provider, ExternalContext context, String renderKitId) {
        if (provider == null || context == null) {
            throw new NullPointerException("SkinProvider or FacesContext is passed as null.");
        }
        String defaultSkinId = "portlet".equals(renderKitId) ? "simple.portlet" : ("org.apache.myfaces.trinidad.pda".equals(renderKitId) ? "simple.pda" : "simple.desktop");
        Skin defaultSkin = provider.getSkin(context, new SkinMetadata.Builder().id(defaultSkinId).build());
        assert (defaultSkin != null);
        return defaultSkin;
    }

    public static List<SkinsNode> buildSkinsNodes(ExternalContext extCtxt) {
        List<SkinsNode> metaInfSkinsNode = SkinUtils._getMetaInfSkinsNodeList();
        SkinsNode webInfSkinsNode = SkinUtils._getWebInfSkinsNode(extCtxt);
        List<SkinsNode> resourceLoaderSkinsNodes = SkinUtils._getSkinsNodesFromSkinResourceLoaderServices(extCtxt);
        ArrayList<SkinsNode> skinsNodes = new ArrayList<SkinsNode>(20);
        if (metaInfSkinsNode != null) {
            skinsNodes.addAll(metaInfSkinsNode);
        }
        if (webInfSkinsNode != null) {
            skinsNodes.add(webInfSkinsNode);
        }
        if (resourceLoaderSkinsNodes != null) {
            skinsNodes.addAll(resourceLoaderSkinsNodes);
        }
        return skinsNodes;
    }

    public static Icon resolveReferenceIcon(Skin skin, ReferenceIcon refIcon) {
        return SkinUtils._resolveReferenceIcon(skin, refIcon, null);
    }

    public static String getSkinDebugInfo(Skin skin) {
        return SkinUtils.getSkinDebugInfo(skin, DebugInfoLevel.NORMAL);
    }

    public static String getSkinDebugInfo(Skin skin, DebugInfoLevel level) {
        assert (null != skin);
        StringBuilder sb = new StringBuilder();
        try {
            JsonUtils.writeObject(sb, SkinUtils._getDebugInfoMap(skin, level), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private static Map<String, Object> _getDebugInfoMap(Skin skin, DebugInfoLevel level) {
        assert (null != skin);
        RenderingContext rc = RenderingContext.getCurrentInstance();
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("id", skin.getId());
        m.put("family", skin.getFamily());
        m.put("version", skin.getVersion().getName());
        m.put("renderkit", skin.getRenderKitId());
        if (null != rc) {
            m.put("documentId", skin.getStyleSheetDocumentId(rc));
        }
        if (!DebugInfoLevel.TERSE.equals((Object)level)) {
            m.put("document", SkinUtils._getStyleSheetLocation(skin.getStyleSheetName(), level));
            m.put("features", skin.getSkinFeatures());
            StyleContext sctx = null != rc && rc instanceof CoreRenderingContext ? ((CoreRenderingContext)rc).getStyleContext() : null;
            List additions = skin.getSkinAdditions();
            LinkedList additionList = new LinkedList();
            m.put("additions", additionList);
            for (SkinAddition addition : additions) {
                LinkedHashMap<String, String> additionMap = new LinkedHashMap<String, String>();
                additionList.add(additionMap);
                String styleSheetName = addition.getStyleSheetName();
                additionMap.put("document", SkinUtils._getStyleSheetLocation(styleSheetName, level));
                if (null == sctx) continue;
                StyleSheetEntry entry = StyleSheetEntry.createEntry(sctx, styleSheetName);
                String documentId = "Unknown - Entry could not be created";
                if (null != entry) {
                    StyleSheetDocument document = entry.getDocument();
                    documentId = null == document ? "Unknown - Document could not be created" : document.getDocumentId(sctx);
                }
                additionMap.put("documentId", documentId);
            }
        }
        if (null != (skin = SkinUtils._findParentSkin(skin))) {
            m.put("parent", SkinUtils._getDebugInfoMap(skin, level));
        }
        return m;
    }

    private static String _getStyleSheetLocation(String location, DebugInfoLevel level) {
        URL url = ClassLoaderUtils.getResource((String)location);
        String loc = null == url ? location : url.getPath();
        return DebugInfoLevel.VERBOSE.equals((Object)level) ? loc : location;
    }

    private static List<SkinsNode> _getMetaInfSkinsNodeList() {
        ArrayList<SkinsNode> allSkinsNodes = new ArrayList<SkinsNode>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources(_META_INF_CONFIG_FILE);
            HashSet<String> urlPaths = new HashSet<String>(16);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                boolean successfullyAdded = urlPaths.add(url.getPath());
                SkinUtils._processTrinidadSkinsURL(allSkinsNodes, url, successfullyAdded);
            }
        }
        catch (IOException e) {
            _LOG.severe("ERR_LOADING_FILE", (Object)_META_INF_CONFIG_FILE);
            _LOG.severe((Throwable)e);
        }
        return allSkinsNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SkinsNode _getSkinsNodeFromInputStream(XMLProvider provider, NameResolver resolver, InputStream inputStream, ParserManager parserManager, String configFile, boolean isMetaInf) {
        if (inputStream == null) {
            throw new NullPointerException(_LOG.getMessage("NO_INPUTSTREAM"));
        }
        if (parserManager == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_PARSEMANAGER"));
        }
        SkinsNode skinsNode = null;
        try {
            InputSource input = new InputSource();
            input.setByteStream(inputStream);
            input.setPublicId(configFile);
            ParseContextImpl context = new ParseContextImpl();
            if (isMetaInf) {
                context.setProperty("http://myfaces.apache.org/trinidad/skin", "meta-inf", isMetaInf);
            }
            if (resolver != null) {
                XMLUtils.setResolver(context, resolver);
            }
            TreeBuilder builder = new TreeBuilder(parserManager, SkinsNode.class);
            skinsNode = (SkinsNode)builder.parse(provider, input, context);
            if (isMetaInf) {
                context.setProperty("http://myfaces.apache.org/trinidad/skin", "meta-inf", null);
            }
        }
        catch (Exception e) {
            _LOG.warning("SKIN_CONFIG_PROCESS_FAILURE", (Object)configFile);
            _LOG.warning((Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return skinsNode;
    }

    public static ParserManager createDefaultManager() {
        ParserManager manager = new ParserManager();
        SkinUtils._registerFactory(manager, SkinsNode.class, "SkinsNode");
        SkinUtils._registerFactory(manager, SkinMetadata.class, "SkinMetadata");
        SkinUtils._registerFactory(manager, SkinAddition.class, "SkinAddition");
        SkinUtils._registerFactory(manager, SkinVersion.class, "SkinVersion");
        SkinUtils._registerFactory(manager, SkinFeatures.class, "SkinFeatures");
        SkinUtils._registerFactory(manager, CustomMetadata.class, "CustomMetadata");
        return manager;
    }

    private static Skin _findParentSkin(Skin skin) {
        while (skin instanceof RequestSkinWrapper) {
            skin = ((RequestSkinWrapper)skin).getWrappedSkin();
        }
        if (skin instanceof SkinExtension) {
            return ((SkinExtension)skin).getBaseSkin();
        }
        return null;
    }

    private static ParserManager _getDefaultManager() {
        if (_sManager == null) {
            _sManager = SkinUtils.createDefaultManager();
        }
        return _sManager;
    }

    private static void _registerFactory(ParserManager manager, Class<?> expectedType, String baseName) {
        String className = _LAF_PARSE_PACKAGE + baseName + "Parser";
        ClassParserFactory factory = new ClassParserFactory(className);
        manager.registerFactory(expectedType, "http://myfaces.apache.org/trinidad/skin", factory);
    }

    private static SkinsNode _getWebInfSkinsNode(ExternalContext context) {
        InputStream in = context.getResourceAsStream(_CONFIG_FILE);
        if (in != null) {
            SkinsNode webInfSkinsNode = SkinUtils._getSkinsNodeFromInputStream(null, null, in, SkinUtils._getDefaultManager(), _CONFIG_FILE, false);
            if (_LOG.isFine()) {
                for (SkinMetadata skinMetadata : webInfSkinsNode.getSkinNodes()) {
                    _LOG.fine("Skin {0} with stylesheet {1}", new Object[]{skinMetadata.getId(), skinMetadata.getStyleSheetName()});
                }
                for (SkinAddition skinAddition : webInfSkinsNode.getSkinAdditionNodes()) {
                    _LOG.fine("SkinAddition {0} with stylesheet {1}", new Object[]{skinAddition.getSkinId(), skinAddition.getStyleSheetName()});
                }
            }
            return webInfSkinsNode;
        }
        return null;
    }

    private static List<SkinsNode> _getSkinsNodesFromSkinResourceLoaderServices(ExternalContext context) {
        List urlProviders;
        if (_LOG.isFine()) {
            _LOG.fine("Parse SkinResourceLoader trinidad-skins.xml");
        }
        if ((urlProviders = ClassLoaderUtils.getServices((String)"org.apache.myfaces.trinidad.resource.SkinResourceLoader")) != null && !urlProviders.isEmpty()) {
            return SkinUtils._getResourceLoadedTrinidadSkins(context, urlProviders);
        }
        return Collections.emptyList();
    }

    private static List<SkinsNode> _getResourceLoadedTrinidadSkins(ExternalContext context, List<SkinResourceLoader> providers) {
        HashSet<String> urlPaths = new HashSet<String>(16);
        ArrayList<SkinsNode> allSkinsNodes = new ArrayList<SkinsNode>();
        for (SkinResourceLoader urlProvider : providers) {
            Iterator urlIterator = urlProvider.findResources(context, _TRINIDAD_SKINS_XML);
            if (urlIterator == null) continue;
            try {
                while (urlIterator.hasNext()) {
                    URL url = (URL)urlIterator.next();
                    boolean successfullyAdded = urlPaths.add(url.getPath());
                    SkinUtils._processTrinidadSkinsURL(allSkinsNodes, url, successfullyAdded);
                }
            }
            catch (IOException e) {
                _LOG.severe("ERR_LOADING_FILE", (Object)_META_INF_CONFIG_FILE);
                _LOG.severe((Throwable)e);
            }
        }
        return allSkinsNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _processTrinidadSkinsURL(List<SkinsNode> allSkinsNodes, URL url, boolean successfullyAdded) throws IOException {
        if (!successfullyAdded) {
            if (_LOG.isFine()) {
                _LOG.fine("Skipping skin URL:{0} because it was already processed. It was on the classpath more than once.", (Object)url);
            }
        } else {
            if (_LOG.isFine()) {
                _LOG.fine("Processing skin URL:{0}", (Object)url);
            }
            URLConnection urlConnection = url.openConnection();
            if (Beans.isDesignTime()) {
                urlConnection.setUseCaches(false);
            }
            try (InputStream in = urlConnection.getInputStream();){
                if (in != null) {
                    SkinsNode metaInfSkinsNode = SkinUtils._getSkinsNodeFromInputStream(null, null, in, SkinUtils._getDefaultManager(), url.toString(), true);
                    if (metaInfSkinsNode != null) {
                        if (_LOG.isFine()) {
                            for (SkinMetadata skinMetadata : metaInfSkinsNode.getSkinNodes()) {
                                _LOG.fine("Skin {0} with stylesheet {1}", new Object[]{skinMetadata.getId(), skinMetadata.getStyleSheetName()});
                            }
                            for (SkinAddition skinAddition : metaInfSkinsNode.getSkinAdditionNodes()) {
                                _LOG.fine("SkinAddition {0} with stylesheet {1}", new Object[]{skinAddition.getSkinId(), skinAddition.getStyleSheetName()});
                            }
                        }
                        allSkinsNodes.add(metaInfSkinsNode);
                    } else if (_LOG.isFine()) {
                        _LOG.fine("No skins found in the URL.");
                    }
                }
            }
        }
    }

    private static Icon _resolveReferenceIcon(Skin skin, ReferenceIcon refIcon, Stack<String> referencedIconStack) {
        String refName = refIcon.getName();
        if (referencedIconStack != null && referencedIconStack.contains(refName)) {
            if (_LOG.isWarning()) {
                _LOG.warning("SKIN_CIRCULAR_INCLUDE_ERROR", (Object)refName);
            }
            return null;
        }
        if (referencedIconStack == null) {
            referencedIconStack = new Stack();
        }
        referencedIconStack.push(refName);
        Icon icon = skin.getIcon(refName, false);
        if (icon instanceof ReferenceIcon && icon != null) {
            return SkinUtils._resolveReferenceIcon(skin, (ReferenceIcon)icon, referencedIconStack);
        }
        return icon;
    }

    private SkinUtils() {
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(SkinUtils.class);
    }

    public static enum DebugInfoLevel {
        TERSE,
        NORMAL,
        VERBOSE;

        private static final long serialVersionUID = 1L;
    }
}

