/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.RegexValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIIn;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.renderkit.renderer.MessageLayoutRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InRenderer<T extends AbstractUIIn>
extends MessageLayoutRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_IN;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        this.insideBegin(facesContext, HtmlElements.TOBAGO_IN);
        super.encodeBeginInternal(facesContext, component);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        super.encodeEndInternal(facesContext, component);
        this.insideEnd(facesContext, HtmlElements.TOBAGO_IN);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String currentValue = this.getCurrentValue(facesContext, component);
        boolean password = ((AbstractUIIn)component).isPassword();
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '{}'", (Object)StringUtils.toConfidentialString(currentValue, password));
        }
        HtmlInputTypes type = password ? HtmlInputTypes.PASSWORD : HtmlInputTypes.TEXT;
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUIInput)component).getFieldId(facesContext);
        boolean readonly = ((AbstractUIInput)component).isReadonly();
        boolean disabled = ((AbstractUIInput)component).isDisabled();
        Markup markup = component.getMarkup();
        boolean required = ComponentUtils.getBooleanAttribute(component, Attributes.required);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent after = ComponentUtils.getFacet(component, Facets.after);
        UIComponent before = ComponentUtils.getFacet(component, Facets.before);
        if (after != null || before != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        }
        this.encodeGroupAddon(facesContext, writer, before, false);
        writer.startElement(HtmlElements.INPUT);
        if (component.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(component.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, component.getAccessKey(), clientId);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, type);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (currentValue != null && !password) {
            writer.writeAttribute(HtmlAttributes.VALUE, currentValue, true);
        }
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        int maxLength = 0;
        int minLength = 0;
        String pattern = null;
        for (Validator validator : component.getValidators()) {
            if (validator instanceof LengthValidator) {
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
                minLength = lengthValidator.getMinimum();
                continue;
            }
            if (!(validator instanceof RegexValidator)) continue;
            RegexValidator regexValidator = (RegexValidator)validator;
            pattern = regexValidator.getPattern();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (minLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MINLENGTH, minLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, true);
        }
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)component).getTabIndex());
        if (!disabled && !readonly) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, ((AbstractUIIn)component).getPlaceholder(), true);
        }
        writer.writeAttribute(HtmlAttributes.AUTOCOMPLETE, component.getAutocompleteString(), true);
        writer.writeClassAttribute(markup != null && markup.contains(Markup.NUMBER) ? TobagoClass.NUMBER : null, BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity(component)), BootstrapClass.FORM_CONTROL, component.getCustomClass());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
        InRenderer.renderFocus(clientId, ((AbstractUIInput)component).isFocus(), ((AbstractUIInput)component).isError(), facesContext, writer);
        writer.endElement(HtmlElements.INPUT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        this.encodeGroupAddon(facesContext, writer, after, true);
        if (after != null || before != null) {
            writer.endElement(HtmlElements.DIV);
        }
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIInput)component).getFieldId(facesContext);
    }
}

