/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.concurrency;

import java.util.Objects;
import java.util.concurrent.Executors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.util.concurrency.SmartExecutor;
import org.eclipse.aether.util.concurrency.WorkerThreadFactory;

public final class SmartExecutorUtils {
    private static final SmartExecutor DIRECT = new SmartExecutor.Direct();

    private SmartExecutorUtils() {
    }

    public static SmartExecutor newSmartExecutor(Integer tasks, int maxConcurrentTasks, String namePrefix) {
        int poolSize;
        if (maxConcurrentTasks < 1) {
            throw new IllegalArgumentException("maxConcurrentTasks must be > 0");
        }
        Objects.requireNonNull(namePrefix);
        if (tasks != null) {
            if (tasks < 1) {
                throw new IllegalArgumentException("tasks must be > 0");
            }
            if (tasks == 1 || maxConcurrentTasks == 1) {
                return DIRECT;
            }
            poolSize = Math.min(tasks, maxConcurrentTasks);
        } else {
            if (maxConcurrentTasks == 1) {
                return DIRECT;
            }
            poolSize = maxConcurrentTasks;
        }
        return new SmartExecutor.Pooled(Executors.newFixedThreadPool(poolSize, new WorkerThreadFactory(namePrefix)));
    }

    public static SmartExecutor smartExecutor(RepositorySystemSession session, Integer tasks, int maxConcurrentTasks, String namePrefix) {
        if (tasks == null && maxConcurrentTasks > 1) {
            return (SmartExecutor)session.getData().computeIfAbsent((Object)(SmartExecutor.class.getSimpleName() + "-" + namePrefix), () -> {
                SmartExecutor smartExecutor = SmartExecutorUtils.newSmartExecutor(null, maxConcurrentTasks, namePrefix);
                session.addOnSessionEndedHandler(smartExecutor::close);
                return new SmartExecutor.NonClosing(smartExecutor);
            });
        }
        return SmartExecutorUtils.newSmartExecutor(tasks, maxConcurrentTasks, namePrefix);
    }
}

