/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.InvocationTargetException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInfo;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;

public abstract class LoadedGeneratedClass
implements GeneratedClass {
    private final ClassInfo ci;
    private final int classLoaderVersion;

    public LoadedGeneratedClass(ClassFactory classFactory, Class clazz) {
        this.ci = new ClassInfo(clazz);
        this.classLoaderVersion = classFactory.getClassLoaderVersion();
    }

    @Override
    public String getName() {
        return this.ci.getClassName();
    }

    @Override
    public Object newInstance(Context context) throws StandardException {
        Throwable throwable;
        try {
            GeneratedByteCode generatedByteCode = (GeneratedByteCode)this.ci.getNewInstance();
            generatedByteCode.initFromContext(context);
            generatedByteCode.setGC(this);
            generatedByteCode.postConstructor();
            return generatedByteCode;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw StandardException.newException("XBCM2.S", throwable, this.getName());
    }

    @Override
    public final int getClassLoaderVersion() {
        return this.classLoaderVersion;
    }

    protected Class<?> getJVMClass() {
        return this.ci.getClassObject();
    }
}

