/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.FreeIPAAccountState;
import org.ldaptive.io.GeneralizedTimeValueTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeIPAAuthenticationResponseHandler
implements AuthenticationResponseHandler {
    private static final int HASH_CODE_SEED = 1217;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxPasswordAge;
    private int maxLoginFailures;
    private int warningHours;

    public FreeIPAAuthenticationResponseHandler() {
    }

    public FreeIPAAuthenticationResponseHandler(int warning, int passwordAge, int loginFailures) {
        if (warning < 0) {
            throw new IllegalArgumentException("Warning hours must be >= 0");
        }
        this.warningHours = warning;
        if (passwordAge < 0) {
            throw new IllegalArgumentException("Password age must be >= 0");
        }
        this.maxPasswordAge = passwordAge;
        if (loginFailures < 0) {
            throw new IllegalArgumentException("Login failures must be >= 0");
        }
        this.maxLoginFailures = loginFailures;
    }

    public FreeIPAAuthenticationResponseHandler(String warning, String passwordAge, int loginFailures) {
        this((int)LdapUtils.durationDecode(warning, TimeUnit.HOURS), (int)LdapUtils.durationDecode(passwordAge, TimeUnit.DAYS), loginFailures);
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.getResultCode() != ResultCode.SUCCESS) {
            FreeIPAAccountState.Error fError = FreeIPAAccountState.Error.parse(response.getResultCode(), response.getMessage());
            if (fError != null) {
                response.setAccountState(new FreeIPAAccountState(fError));
            }
        } else if (((Boolean)response.getResult()).booleanValue()) {
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry.getAttribute("krbPasswordExpiration");
            LdapAttribute failedLogins = entry.getAttribute("krbLoginFailedCount");
            LdapAttribute lastPwdChange = entry.getAttribute("krbLastPwdChange");
            Calendar exp = null;
            Integer loginRemaining = null;
            if (failedLogins != null && this.maxLoginFailures > 0) {
                loginRemaining = this.maxLoginFailures - Integer.parseInt(failedLogins.getStringValue());
            }
            Calendar now = Calendar.getInstance();
            if (expTime != null) {
                exp = expTime.getValue(new GeneralizedTimeValueTranscoder());
            } else if (this.maxPasswordAge > 0 && lastPwdChange != null) {
                exp = lastPwdChange.getValue(new GeneralizedTimeValueTranscoder());
                exp.setTimeInMillis(exp.getTimeInMillis() + TimeUnit.DAYS.toMillis(this.maxPasswordAge));
            }
            if (exp != null) {
                if (this.warningHours > 0) {
                    Calendar warn = (Calendar)exp.clone();
                    warn.add(11, -this.warningHours);
                    if (now.after(warn)) {
                        response.setAccountState(new FreeIPAAccountState(exp, loginRemaining != null ? loginRemaining : 0));
                    }
                } else {
                    response.setAccountState(new FreeIPAAccountState(exp, loginRemaining != null ? loginRemaining : 0));
                }
            } else if (loginRemaining != null) {
                response.setAccountState(new FreeIPAAccountState(null, loginRemaining));
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FreeIPAAuthenticationResponseHandler) {
            FreeIPAAuthenticationResponseHandler v = (FreeIPAAuthenticationResponseHandler)o;
            return LdapUtils.areEqual(this.maxPasswordAge, v.maxPasswordAge) && LdapUtils.areEqual(this.maxLoginFailures, v.maxLoginFailures) && LdapUtils.areEqual(this.warningHours, v.warningHours);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1217, this.maxPasswordAge, this.maxLoginFailures, this.warningHours);
    }

    public String toString() {
        return String.format("[%s@%d::maxPasswordAge=%s, maxLoginFailures=%s, warningHours=%s]", this.getClass().getName(), this.hashCode(), this.maxPasswordAge, this.maxLoginFailures, this.warningHours);
    }
}

